/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ImportConflictResolution
extends ExplicitlySetBmcModel {
    @JsonProperty(value="duplicatePrefix")
    private final String duplicatePrefix;
    @JsonProperty(value="duplicateSuffix")
    private final String duplicateSuffix;
    @JsonProperty(value="importConflictResolutionType")
    private final ImportConflictResolutionType importConflictResolutionType;

    @Deprecated
    @ConstructorProperties(value={"duplicatePrefix", "duplicateSuffix", "importConflictResolutionType"})
    public ImportConflictResolution(String duplicatePrefix, String duplicateSuffix, ImportConflictResolutionType importConflictResolutionType) {
        this.duplicatePrefix = duplicatePrefix;
        this.duplicateSuffix = duplicateSuffix;
        this.importConflictResolutionType = importConflictResolutionType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDuplicatePrefix() {
        return this.duplicatePrefix;
    }

    public String getDuplicateSuffix() {
        return this.duplicateSuffix;
    }

    public ImportConflictResolutionType getImportConflictResolutionType() {
        return this.importConflictResolutionType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImportConflictResolution(");
        sb.append("super=").append(super.toString());
        sb.append("duplicatePrefix=").append(String.valueOf(this.duplicatePrefix));
        sb.append(", duplicateSuffix=").append(String.valueOf(this.duplicateSuffix));
        sb.append(", importConflictResolutionType=").append(String.valueOf((Object)this.importConflictResolutionType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportConflictResolution)) {
            return false;
        }
        ImportConflictResolution other = (ImportConflictResolution)((Object)o);
        return Objects.equals(this.duplicatePrefix, other.duplicatePrefix) && Objects.equals(this.duplicateSuffix, other.duplicateSuffix) && Objects.equals((Object)this.importConflictResolutionType, (Object)other.importConflictResolutionType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.duplicatePrefix == null ? 43 : this.duplicatePrefix.hashCode());
        result = result * 59 + (this.duplicateSuffix == null ? 43 : this.duplicateSuffix.hashCode());
        result = result * 59 + (this.importConflictResolutionType == null ? 43 : this.importConflictResolutionType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ImportConflictResolutionType implements BmcEnum
    {
        Duplicate("DUPLICATE"),
        Replace("REPLACE"),
        Retain("RETAIN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ImportConflictResolutionType> map;

        private ImportConflictResolutionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ImportConflictResolutionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ImportConflictResolutionType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ImportConflictResolutionType.class);
            map = new HashMap<String, ImportConflictResolutionType>();
            for (ImportConflictResolutionType v : ImportConflictResolutionType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="duplicatePrefix")
        private String duplicatePrefix;
        @JsonProperty(value="duplicateSuffix")
        private String duplicateSuffix;
        @JsonProperty(value="importConflictResolutionType")
        private ImportConflictResolutionType importConflictResolutionType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder duplicatePrefix(String duplicatePrefix) {
            this.duplicatePrefix = duplicatePrefix;
            this.__explicitlySet__.add("duplicatePrefix");
            return this;
        }

        public Builder duplicateSuffix(String duplicateSuffix) {
            this.duplicateSuffix = duplicateSuffix;
            this.__explicitlySet__.add("duplicateSuffix");
            return this;
        }

        public Builder importConflictResolutionType(ImportConflictResolutionType importConflictResolutionType) {
            this.importConflictResolutionType = importConflictResolutionType;
            this.__explicitlySet__.add("importConflictResolutionType");
            return this;
        }

        public ImportConflictResolution build() {
            ImportConflictResolution model = new ImportConflictResolution(this.duplicatePrefix, this.duplicateSuffix, this.importConflictResolutionType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ImportConflictResolution model) {
            if (model.wasPropertyExplicitlySet("duplicatePrefix")) {
                this.duplicatePrefix(model.getDuplicatePrefix());
            }
            if (model.wasPropertyExplicitlySet("duplicateSuffix")) {
                this.duplicateSuffix(model.getDuplicateSuffix());
            }
            if (model.wasPropertyExplicitlySet("importConflictResolutionType")) {
                this.importConflictResolutionType(model.getImportConflictResolutionType());
            }
            return this;
        }
    }
}

