/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ImportConflictResolution;
import com.oracle.bmc.dataintegration.model.ImportObjectMetadataSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ImportRequestSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="bucketName")
    private final String bucketName;
    @JsonProperty(value="fileName")
    private final String fileName;
    @JsonProperty(value="objectStorageTenancyId")
    private final String objectStorageTenancyId;
    @JsonProperty(value="objectStorageRegion")
    private final String objectStorageRegion;
    @JsonProperty(value="objectKeyForImport")
    private final String objectKeyForImport;
    @JsonProperty(value="areDataAssetReferencesIncluded")
    private final Boolean areDataAssetReferencesIncluded;
    @JsonProperty(value="importConflictResolution")
    private final ImportConflictResolution importConflictResolution;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="createdBy")
    private final String createdBy;
    @JsonProperty(value="totalImportedObjectCount")
    private final Integer totalImportedObjectCount;
    @JsonProperty(value="timeStartedInMillis")
    private final Long timeStartedInMillis;
    @JsonProperty(value="timeEndedInMillis")
    private final Long timeEndedInMillis;
    @JsonProperty(value="errorMessages")
    private final Map<String, String> errorMessages;
    @JsonProperty(value="importedObjects")
    private final List<ImportObjectMetadataSummary> importedObjects;
    @JsonProperty(value="name")
    private final String name;

    @Deprecated
    @ConstructorProperties(value={"key", "bucketName", "fileName", "objectStorageTenancyId", "objectStorageRegion", "objectKeyForImport", "areDataAssetReferencesIncluded", "importConflictResolution", "status", "createdBy", "totalImportedObjectCount", "timeStartedInMillis", "timeEndedInMillis", "errorMessages", "importedObjects", "name"})
    public ImportRequestSummary(String key, String bucketName, String fileName, String objectStorageTenancyId, String objectStorageRegion, String objectKeyForImport, Boolean areDataAssetReferencesIncluded, ImportConflictResolution importConflictResolution, Status status, String createdBy, Integer totalImportedObjectCount, Long timeStartedInMillis, Long timeEndedInMillis, Map<String, String> errorMessages, List<ImportObjectMetadataSummary> importedObjects, String name) {
        this.key = key;
        this.bucketName = bucketName;
        this.fileName = fileName;
        this.objectStorageTenancyId = objectStorageTenancyId;
        this.objectStorageRegion = objectStorageRegion;
        this.objectKeyForImport = objectKeyForImport;
        this.areDataAssetReferencesIncluded = areDataAssetReferencesIncluded;
        this.importConflictResolution = importConflictResolution;
        this.status = status;
        this.createdBy = createdBy;
        this.totalImportedObjectCount = totalImportedObjectCount;
        this.timeStartedInMillis = timeStartedInMillis;
        this.timeEndedInMillis = timeEndedInMillis;
        this.errorMessages = errorMessages;
        this.importedObjects = importedObjects;
        this.name = name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getObjectStorageTenancyId() {
        return this.objectStorageTenancyId;
    }

    public String getObjectStorageRegion() {
        return this.objectStorageRegion;
    }

    public String getObjectKeyForImport() {
        return this.objectKeyForImport;
    }

    public Boolean getAreDataAssetReferencesIncluded() {
        return this.areDataAssetReferencesIncluded;
    }

    public ImportConflictResolution getImportConflictResolution() {
        return this.importConflictResolution;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Integer getTotalImportedObjectCount() {
        return this.totalImportedObjectCount;
    }

    public Long getTimeStartedInMillis() {
        return this.timeStartedInMillis;
    }

    public Long getTimeEndedInMillis() {
        return this.timeEndedInMillis;
    }

    public Map<String, String> getErrorMessages() {
        return this.errorMessages;
    }

    public List<ImportObjectMetadataSummary> getImportedObjects() {
        return this.importedObjects;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImportRequestSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", bucketName=").append(String.valueOf(this.bucketName));
        sb.append(", fileName=").append(String.valueOf(this.fileName));
        sb.append(", objectStorageTenancyId=").append(String.valueOf(this.objectStorageTenancyId));
        sb.append(", objectStorageRegion=").append(String.valueOf(this.objectStorageRegion));
        sb.append(", objectKeyForImport=").append(String.valueOf(this.objectKeyForImport));
        sb.append(", areDataAssetReferencesIncluded=").append(String.valueOf(this.areDataAssetReferencesIncluded));
        sb.append(", importConflictResolution=").append(String.valueOf((Object)this.importConflictResolution));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", createdBy=").append(String.valueOf(this.createdBy));
        sb.append(", totalImportedObjectCount=").append(String.valueOf(this.totalImportedObjectCount));
        sb.append(", timeStartedInMillis=").append(String.valueOf(this.timeStartedInMillis));
        sb.append(", timeEndedInMillis=").append(String.valueOf(this.timeEndedInMillis));
        sb.append(", errorMessages=").append(String.valueOf(this.errorMessages));
        sb.append(", importedObjects=").append(String.valueOf(this.importedObjects));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportRequestSummary)) {
            return false;
        }
        ImportRequestSummary other = (ImportRequestSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.fileName, other.fileName) && Objects.equals(this.objectStorageTenancyId, other.objectStorageTenancyId) && Objects.equals(this.objectStorageRegion, other.objectStorageRegion) && Objects.equals(this.objectKeyForImport, other.objectKeyForImport) && Objects.equals(this.areDataAssetReferencesIncluded, other.areDataAssetReferencesIncluded) && Objects.equals((Object)this.importConflictResolution, (Object)other.importConflictResolution) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.createdBy, other.createdBy) && Objects.equals(this.totalImportedObjectCount, other.totalImportedObjectCount) && Objects.equals(this.timeStartedInMillis, other.timeStartedInMillis) && Objects.equals(this.timeEndedInMillis, other.timeEndedInMillis) && Objects.equals(this.errorMessages, other.errorMessages) && Objects.equals(this.importedObjects, other.importedObjects) && Objects.equals(this.name, other.name) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.fileName == null ? 43 : this.fileName.hashCode());
        result = result * 59 + (this.objectStorageTenancyId == null ? 43 : this.objectStorageTenancyId.hashCode());
        result = result * 59 + (this.objectStorageRegion == null ? 43 : this.objectStorageRegion.hashCode());
        result = result * 59 + (this.objectKeyForImport == null ? 43 : this.objectKeyForImport.hashCode());
        result = result * 59 + (this.areDataAssetReferencesIncluded == null ? 43 : this.areDataAssetReferencesIncluded.hashCode());
        result = result * 59 + (this.importConflictResolution == null ? 43 : this.importConflictResolution.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.createdBy == null ? 43 : this.createdBy.hashCode());
        result = result * 59 + (this.totalImportedObjectCount == null ? 43 : this.totalImportedObjectCount.hashCode());
        result = result * 59 + (this.timeStartedInMillis == null ? 43 : this.timeStartedInMillis.hashCode());
        result = result * 59 + (this.timeEndedInMillis == null ? 43 : this.timeEndedInMillis.hashCode());
        result = result * 59 + (this.errorMessages == null ? 43 : this.errorMessages.hashCode());
        result = result * 59 + (this.importedObjects == null ? 43 : this.importedObjects.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Successful("SUCCESSFUL"),
        Failed("FAILED"),
        InProgress("IN_PROGRESS"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Queued("QUEUED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="bucketName")
        private String bucketName;
        @JsonProperty(value="fileName")
        private String fileName;
        @JsonProperty(value="objectStorageTenancyId")
        private String objectStorageTenancyId;
        @JsonProperty(value="objectStorageRegion")
        private String objectStorageRegion;
        @JsonProperty(value="objectKeyForImport")
        private String objectKeyForImport;
        @JsonProperty(value="areDataAssetReferencesIncluded")
        private Boolean areDataAssetReferencesIncluded;
        @JsonProperty(value="importConflictResolution")
        private ImportConflictResolution importConflictResolution;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="createdBy")
        private String createdBy;
        @JsonProperty(value="totalImportedObjectCount")
        private Integer totalImportedObjectCount;
        @JsonProperty(value="timeStartedInMillis")
        private Long timeStartedInMillis;
        @JsonProperty(value="timeEndedInMillis")
        private Long timeEndedInMillis;
        @JsonProperty(value="errorMessages")
        private Map<String, String> errorMessages;
        @JsonProperty(value="importedObjects")
        private List<ImportObjectMetadataSummary> importedObjects;
        @JsonProperty(value="name")
        private String name;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            this.__explicitlySet__.add("bucketName");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.__explicitlySet__.add("fileName");
            return this;
        }

        public Builder objectStorageTenancyId(String objectStorageTenancyId) {
            this.objectStorageTenancyId = objectStorageTenancyId;
            this.__explicitlySet__.add("objectStorageTenancyId");
            return this;
        }

        public Builder objectStorageRegion(String objectStorageRegion) {
            this.objectStorageRegion = objectStorageRegion;
            this.__explicitlySet__.add("objectStorageRegion");
            return this;
        }

        public Builder objectKeyForImport(String objectKeyForImport) {
            this.objectKeyForImport = objectKeyForImport;
            this.__explicitlySet__.add("objectKeyForImport");
            return this;
        }

        public Builder areDataAssetReferencesIncluded(Boolean areDataAssetReferencesIncluded) {
            this.areDataAssetReferencesIncluded = areDataAssetReferencesIncluded;
            this.__explicitlySet__.add("areDataAssetReferencesIncluded");
            return this;
        }

        public Builder importConflictResolution(ImportConflictResolution importConflictResolution) {
            this.importConflictResolution = importConflictResolution;
            this.__explicitlySet__.add("importConflictResolution");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.__explicitlySet__.add("createdBy");
            return this;
        }

        public Builder totalImportedObjectCount(Integer totalImportedObjectCount) {
            this.totalImportedObjectCount = totalImportedObjectCount;
            this.__explicitlySet__.add("totalImportedObjectCount");
            return this;
        }

        public Builder timeStartedInMillis(Long timeStartedInMillis) {
            this.timeStartedInMillis = timeStartedInMillis;
            this.__explicitlySet__.add("timeStartedInMillis");
            return this;
        }

        public Builder timeEndedInMillis(Long timeEndedInMillis) {
            this.timeEndedInMillis = timeEndedInMillis;
            this.__explicitlySet__.add("timeEndedInMillis");
            return this;
        }

        public Builder errorMessages(Map<String, String> errorMessages) {
            this.errorMessages = errorMessages;
            this.__explicitlySet__.add("errorMessages");
            return this;
        }

        public Builder importedObjects(List<ImportObjectMetadataSummary> importedObjects) {
            this.importedObjects = importedObjects;
            this.__explicitlySet__.add("importedObjects");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public ImportRequestSummary build() {
            ImportRequestSummary model = new ImportRequestSummary(this.key, this.bucketName, this.fileName, this.objectStorageTenancyId, this.objectStorageRegion, this.objectKeyForImport, this.areDataAssetReferencesIncluded, this.importConflictResolution, this.status, this.createdBy, this.totalImportedObjectCount, this.timeStartedInMillis, this.timeEndedInMillis, this.errorMessages, this.importedObjects, this.name);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ImportRequestSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("bucketName")) {
                this.bucketName(model.getBucketName());
            }
            if (model.wasPropertyExplicitlySet("fileName")) {
                this.fileName(model.getFileName());
            }
            if (model.wasPropertyExplicitlySet("objectStorageTenancyId")) {
                this.objectStorageTenancyId(model.getObjectStorageTenancyId());
            }
            if (model.wasPropertyExplicitlySet("objectStorageRegion")) {
                this.objectStorageRegion(model.getObjectStorageRegion());
            }
            if (model.wasPropertyExplicitlySet("objectKeyForImport")) {
                this.objectKeyForImport(model.getObjectKeyForImport());
            }
            if (model.wasPropertyExplicitlySet("areDataAssetReferencesIncluded")) {
                this.areDataAssetReferencesIncluded(model.getAreDataAssetReferencesIncluded());
            }
            if (model.wasPropertyExplicitlySet("importConflictResolution")) {
                this.importConflictResolution(model.getImportConflictResolution());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("createdBy")) {
                this.createdBy(model.getCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("totalImportedObjectCount")) {
                this.totalImportedObjectCount(model.getTotalImportedObjectCount());
            }
            if (model.wasPropertyExplicitlySet("timeStartedInMillis")) {
                this.timeStartedInMillis(model.getTimeStartedInMillis());
            }
            if (model.wasPropertyExplicitlySet("timeEndedInMillis")) {
                this.timeEndedInMillis(model.getTimeEndedInMillis());
            }
            if (model.wasPropertyExplicitlySet("errorMessages")) {
                this.errorMessages(model.getErrorMessages());
            }
            if (model.wasPropertyExplicitlySet("importedObjects")) {
                this.importedObjects(model.getImportedObjects());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            return this;
        }
    }
}

