/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.Expression;
import com.oracle.bmc.dataintegration.model.InputPort;
import com.oracle.bmc.dataintegration.model.Operator;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.TypedObject;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class Joiner
extends Operator {
    @JsonProperty(value="joinType")
    private final JoinType joinType;
    @JsonProperty(value="joinCondition")
    private final Expression joinCondition;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public Joiner(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, List<InputPort> inputPorts, List<TypedObject> outputPorts, Integer objectStatus, String identifier, List<Parameter> parameters, ConfigValues opConfigValues, JoinType joinType, Expression joinCondition) {
        super(key, modelVersion, parentRef, name, description, objectVersion, inputPorts, outputPorts, objectStatus, identifier, parameters, opConfigValues);
        this.joinType = joinType;
        this.joinCondition = joinCondition;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public Expression getJoinCondition() {
        return this.joinCondition;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Joiner(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", joinType=").append(String.valueOf((Object)this.joinType));
        sb.append(", joinCondition=").append(String.valueOf((Object)this.joinCondition));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Joiner)) {
            return false;
        }
        Joiner other = (Joiner)((Object)o);
        return Objects.equals((Object)this.joinType, (Object)other.joinType) && Objects.equals((Object)this.joinCondition, (Object)other.joinCondition) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.joinType == null ? 43 : this.joinType.hashCode());
        result = result * 59 + (this.joinCondition == null ? 43 : this.joinCondition.hashCode());
        return result;
    }

    public static enum JoinType implements BmcEnum
    {
        Inner("INNER"),
        Full("FULL"),
        Left("LEFT"),
        Right("RIGHT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, JoinType> map;

        private JoinType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static JoinType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'JoinType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(JoinType.class);
            map = new HashMap<String, JoinType>();
            for (JoinType v : JoinType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="inputPorts")
        private List<InputPort> inputPorts;
        @JsonProperty(value="outputPorts")
        private List<TypedObject> outputPorts;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
        @JsonProperty(value="opConfigValues")
        private ConfigValues opConfigValues;
        @JsonProperty(value="joinType")
        private JoinType joinType;
        @JsonProperty(value="joinCondition")
        private Expression joinCondition;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder inputPorts(List<InputPort> inputPorts) {
            this.inputPorts = inputPorts;
            this.__explicitlySet__.add("inputPorts");
            return this;
        }

        public Builder outputPorts(List<TypedObject> outputPorts) {
            this.outputPorts = outputPorts;
            this.__explicitlySet__.add("outputPorts");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder opConfigValues(ConfigValues opConfigValues) {
            this.opConfigValues = opConfigValues;
            this.__explicitlySet__.add("opConfigValues");
            return this;
        }

        public Builder joinType(JoinType joinType) {
            this.joinType = joinType;
            this.__explicitlySet__.add("joinType");
            return this;
        }

        public Builder joinCondition(Expression joinCondition) {
            this.joinCondition = joinCondition;
            this.__explicitlySet__.add("joinCondition");
            return this;
        }

        public Joiner build() {
            Joiner model = new Joiner(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.inputPorts, this.outputPorts, this.objectStatus, this.identifier, this.parameters, this.opConfigValues, this.joinType, this.joinCondition);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Joiner model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("inputPorts")) {
                this.inputPorts(model.getInputPorts());
            }
            if (model.wasPropertyExplicitlySet("outputPorts")) {
                this.outputPorts(model.getOutputPorts());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("opConfigValues")) {
                this.opConfigValues(model.getOpConfigValues());
            }
            if (model.wasPropertyExplicitlySet("joinType")) {
                this.joinType(model.getJoinType());
            }
            if (model.wasPropertyExplicitlySet("joinCondition")) {
                this.joinCondition(model.getJoinCondition());
            }
            return this;
        }
    }
}

