/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sparkVersion")
    private final String sparkVersion;
    @JsonProperty(value="driverShape")
    private final String driverShape;
    @JsonProperty(value="executorShape")
    private final String executorShape;
    @JsonProperty(value="totalExecutors")
    private final Integer totalExecutors;

    @Deprecated
    @ConstructorProperties(value={"sparkVersion", "driverShape", "executorShape", "totalExecutors"})
    public ResourceConfiguration(String sparkVersion, String driverShape, String executorShape, Integer totalExecutors) {
        this.sparkVersion = sparkVersion;
        this.driverShape = driverShape;
        this.executorShape = executorShape;
        this.totalExecutors = totalExecutors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSparkVersion() {
        return this.sparkVersion;
    }

    public String getDriverShape() {
        return this.driverShape;
    }

    public String getExecutorShape() {
        return this.executorShape;
    }

    public Integer getTotalExecutors() {
        return this.totalExecutors;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("sparkVersion=").append(String.valueOf(this.sparkVersion));
        sb.append(", driverShape=").append(String.valueOf(this.driverShape));
        sb.append(", executorShape=").append(String.valueOf(this.executorShape));
        sb.append(", totalExecutors=").append(String.valueOf(this.totalExecutors));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceConfiguration)) {
            return false;
        }
        ResourceConfiguration other = (ResourceConfiguration)((Object)o);
        return Objects.equals(this.sparkVersion, other.sparkVersion) && Objects.equals(this.driverShape, other.driverShape) && Objects.equals(this.executorShape, other.executorShape) && Objects.equals(this.totalExecutors, other.totalExecutors) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sparkVersion == null ? 43 : this.sparkVersion.hashCode());
        result = result * 59 + (this.driverShape == null ? 43 : this.driverShape.hashCode());
        result = result * 59 + (this.executorShape == null ? 43 : this.executorShape.hashCode());
        result = result * 59 + (this.totalExecutors == null ? 43 : this.totalExecutors.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sparkVersion")
        private String sparkVersion;
        @JsonProperty(value="driverShape")
        private String driverShape;
        @JsonProperty(value="executorShape")
        private String executorShape;
        @JsonProperty(value="totalExecutors")
        private Integer totalExecutors;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sparkVersion(String sparkVersion) {
            this.sparkVersion = sparkVersion;
            this.__explicitlySet__.add("sparkVersion");
            return this;
        }

        public Builder driverShape(String driverShape) {
            this.driverShape = driverShape;
            this.__explicitlySet__.add("driverShape");
            return this;
        }

        public Builder executorShape(String executorShape) {
            this.executorShape = executorShape;
            this.__explicitlySet__.add("executorShape");
            return this;
        }

        public Builder totalExecutors(Integer totalExecutors) {
            this.totalExecutors = totalExecutors;
            this.__explicitlySet__.add("totalExecutors");
            return this;
        }

        public ResourceConfiguration build() {
            ResourceConfiguration model = new ResourceConfiguration(this.sparkVersion, this.driverShape, this.executorShape, this.totalExecutors);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceConfiguration model) {
            if (model.wasPropertyExplicitlySet("sparkVersion")) {
                this.sparkVersion(model.getSparkVersion());
            }
            if (model.wasPropertyExplicitlySet("driverShape")) {
                this.driverShape(model.getDriverShape());
            }
            if (model.wasPropertyExplicitlySet("executorShape")) {
                this.executorShape(model.getExecutorShape());
            }
            if (model.wasPropertyExplicitlySet("totalExecutors")) {
                this.totalExecutors(model.getTotalExecutors());
            }
            return this;
        }
    }
}

