/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigurationDetails;
import com.oracle.bmc.dataintegration.model.ResourceConfiguration;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateExternalPublicationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="applicationId")
    private final String applicationId;
    @JsonProperty(value="applicationCompartmentId")
    private final String applicationCompartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="resourceConfiguration")
    private final ResourceConfiguration resourceConfiguration;
    @JsonProperty(value="configurationDetails")
    private final ConfigurationDetails configurationDetails;

    @Deprecated
    @ConstructorProperties(value={"applicationId", "applicationCompartmentId", "displayName", "description", "resourceConfiguration", "configurationDetails"})
    public UpdateExternalPublicationDetails(String applicationId, String applicationCompartmentId, String displayName, String description, ResourceConfiguration resourceConfiguration, ConfigurationDetails configurationDetails) {
        this.applicationId = applicationId;
        this.applicationCompartmentId = applicationCompartmentId;
        this.displayName = displayName;
        this.description = description;
        this.resourceConfiguration = resourceConfiguration;
        this.configurationDetails = configurationDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationCompartmentId() {
        return this.applicationCompartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public ResourceConfiguration getResourceConfiguration() {
        return this.resourceConfiguration;
    }

    public ConfigurationDetails getConfigurationDetails() {
        return this.configurationDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateExternalPublicationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("applicationId=").append(String.valueOf(this.applicationId));
        sb.append(", applicationCompartmentId=").append(String.valueOf(this.applicationCompartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", resourceConfiguration=").append(String.valueOf((Object)this.resourceConfiguration));
        sb.append(", configurationDetails=").append(String.valueOf((Object)this.configurationDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateExternalPublicationDetails)) {
            return false;
        }
        UpdateExternalPublicationDetails other = (UpdateExternalPublicationDetails)((Object)o);
        return Objects.equals(this.applicationId, other.applicationId) && Objects.equals(this.applicationCompartmentId, other.applicationCompartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.resourceConfiguration, (Object)other.resourceConfiguration) && Objects.equals((Object)this.configurationDetails, (Object)other.configurationDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.applicationId == null ? 43 : this.applicationId.hashCode());
        result = result * 59 + (this.applicationCompartmentId == null ? 43 : this.applicationCompartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.resourceConfiguration == null ? 43 : this.resourceConfiguration.hashCode());
        result = result * 59 + (this.configurationDetails == null ? 43 : this.configurationDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="applicationId")
        private String applicationId;
        @JsonProperty(value="applicationCompartmentId")
        private String applicationCompartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="resourceConfiguration")
        private ResourceConfiguration resourceConfiguration;
        @JsonProperty(value="configurationDetails")
        private ConfigurationDetails configurationDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            this.__explicitlySet__.add("applicationId");
            return this;
        }

        public Builder applicationCompartmentId(String applicationCompartmentId) {
            this.applicationCompartmentId = applicationCompartmentId;
            this.__explicitlySet__.add("applicationCompartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder resourceConfiguration(ResourceConfiguration resourceConfiguration) {
            this.resourceConfiguration = resourceConfiguration;
            this.__explicitlySet__.add("resourceConfiguration");
            return this;
        }

        public Builder configurationDetails(ConfigurationDetails configurationDetails) {
            this.configurationDetails = configurationDetails;
            this.__explicitlySet__.add("configurationDetails");
            return this;
        }

        public UpdateExternalPublicationDetails build() {
            UpdateExternalPublicationDetails model = new UpdateExternalPublicationDetails(this.applicationId, this.applicationCompartmentId, this.displayName, this.description, this.resourceConfiguration, this.configurationDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateExternalPublicationDetails model) {
            if (model.wasPropertyExplicitlySet("applicationId")) {
                this.applicationId(model.getApplicationId());
            }
            if (model.wasPropertyExplicitlySet("applicationCompartmentId")) {
                this.applicationCompartmentId(model.getApplicationCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("resourceConfiguration")) {
                this.resourceConfiguration(model.getResourceConfiguration());
            }
            if (model.wasPropertyExplicitlySet("configurationDetails")) {
                this.configurationDetails(model.getConfigurationDetails());
            }
            return this;
        }
    }
}

