/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateTaskScheduleDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateTaskScheduleRequest
extends BmcRequest<CreateTaskScheduleDetails> {
    private String workspaceId;
    private String applicationKey;
    private CreateTaskScheduleDetails createTaskScheduleDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public CreateTaskScheduleDetails getCreateTaskScheduleDetails() {
        return this.createTaskScheduleDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateTaskScheduleDetails getBody$() {
        return this.createTaskScheduleDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).applicationKey(this.applicationKey).createTaskScheduleDetails(this.createTaskScheduleDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",applicationKey=").append(String.valueOf(this.applicationKey));
        sb.append(",createTaskScheduleDetails=").append(String.valueOf((Object)this.createTaskScheduleDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTaskScheduleRequest)) {
            return false;
        }
        CreateTaskScheduleRequest other = (CreateTaskScheduleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.applicationKey, other.applicationKey) && Objects.equals((Object)this.createTaskScheduleDetails, (Object)other.createTaskScheduleDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.applicationKey == null ? 43 : this.applicationKey.hashCode());
        result = result * 59 + (this.createTaskScheduleDetails == null ? 43 : this.createTaskScheduleDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateTaskScheduleRequest, CreateTaskScheduleDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String applicationKey = null;
        private CreateTaskScheduleDetails createTaskScheduleDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder createTaskScheduleDetails(CreateTaskScheduleDetails createTaskScheduleDetails) {
            this.createTaskScheduleDetails = createTaskScheduleDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTaskScheduleRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.createTaskScheduleDetails(o.getCreateTaskScheduleDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTaskScheduleRequest build() {
            CreateTaskScheduleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateTaskScheduleDetails body) {
            this.createTaskScheduleDetails(body);
            return this;
        }

        public CreateTaskScheduleRequest buildWithoutInvocationCallback() {
            CreateTaskScheduleRequest request = new CreateTaskScheduleRequest();
            request.workspaceId = this.workspaceId;
            request.applicationKey = this.applicationKey;
            request.createTaskScheduleDetails = this.createTaskScheduleDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

