/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListDisApplicationTaskRunLineagesRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String disApplicationId;
    private String opcRequestId;
    private List<String> fields;
    private String page;
    private Integer limit;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private List<String> filter;
    private Date timeUpdatedGreaterThan;
    private Date timeUpdatedGreaterThanOrEqualTo;
    private Date timeUpatedLessThan;
    private Date timeUpatedLessThanOrEqualTo;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getDisApplicationId() {
        return this.disApplicationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public List<String> getFilter() {
        return this.filter;
    }

    public Date getTimeUpdatedGreaterThan() {
        return this.timeUpdatedGreaterThan;
    }

    public Date getTimeUpdatedGreaterThanOrEqualTo() {
        return this.timeUpdatedGreaterThanOrEqualTo;
    }

    public Date getTimeUpatedLessThan() {
        return this.timeUpatedLessThan;
    }

    public Date getTimeUpatedLessThanOrEqualTo() {
        return this.timeUpatedLessThanOrEqualTo;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).disApplicationId(this.disApplicationId).opcRequestId(this.opcRequestId).fields(this.fields).page(this.page).limit(this.limit).sortOrder(this.sortOrder).sortBy(this.sortBy).filter(this.filter).timeUpdatedGreaterThan(this.timeUpdatedGreaterThan).timeUpdatedGreaterThanOrEqualTo(this.timeUpdatedGreaterThanOrEqualTo).timeUpatedLessThan(this.timeUpatedLessThan).timeUpatedLessThanOrEqualTo(this.timeUpatedLessThanOrEqualTo);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",disApplicationId=").append(String.valueOf(this.disApplicationId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",filter=").append(String.valueOf(this.filter));
        sb.append(",timeUpdatedGreaterThan=").append(String.valueOf(this.timeUpdatedGreaterThan));
        sb.append(",timeUpdatedGreaterThanOrEqualTo=").append(String.valueOf(this.timeUpdatedGreaterThanOrEqualTo));
        sb.append(",timeUpatedLessThan=").append(String.valueOf(this.timeUpatedLessThan));
        sb.append(",timeUpatedLessThanOrEqualTo=").append(String.valueOf(this.timeUpatedLessThanOrEqualTo));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDisApplicationTaskRunLineagesRequest)) {
            return false;
        }
        ListDisApplicationTaskRunLineagesRequest other = (ListDisApplicationTaskRunLineagesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.disApplicationId, other.disApplicationId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.fields, other.fields) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.filter, other.filter) && Objects.equals(this.timeUpdatedGreaterThan, other.timeUpdatedGreaterThan) && Objects.equals(this.timeUpdatedGreaterThanOrEqualTo, other.timeUpdatedGreaterThanOrEqualTo) && Objects.equals(this.timeUpatedLessThan, other.timeUpatedLessThan) && Objects.equals(this.timeUpatedLessThanOrEqualTo, other.timeUpatedLessThanOrEqualTo);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.disApplicationId == null ? 43 : this.disApplicationId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.filter == null ? 43 : this.filter.hashCode());
        result = result * 59 + (this.timeUpdatedGreaterThan == null ? 43 : this.timeUpdatedGreaterThan.hashCode());
        result = result * 59 + (this.timeUpdatedGreaterThanOrEqualTo == null ? 43 : this.timeUpdatedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeUpatedLessThan == null ? 43 : this.timeUpatedLessThan.hashCode());
        result = result * 59 + (this.timeUpatedLessThanOrEqualTo == null ? 43 : this.timeUpatedLessThanOrEqualTo.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDisApplicationTaskRunLineagesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String disApplicationId = null;
        private String opcRequestId = null;
        private List<String> fields = null;
        private String page = null;
        private Integer limit = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private List<String> filter = null;
        private Date timeUpdatedGreaterThan = null;
        private Date timeUpdatedGreaterThanOrEqualTo = null;
        private Date timeUpatedLessThan = null;
        private Date timeUpatedLessThanOrEqualTo = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder disApplicationId(String disApplicationId) {
            this.disApplicationId = disApplicationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(String singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public Builder filter(String singularValue) {
            return this.filter(Arrays.asList(singularValue));
        }

        public Builder timeUpdatedGreaterThan(Date timeUpdatedGreaterThan) {
            this.timeUpdatedGreaterThan = timeUpdatedGreaterThan;
            return this;
        }

        public Builder timeUpdatedGreaterThanOrEqualTo(Date timeUpdatedGreaterThanOrEqualTo) {
            this.timeUpdatedGreaterThanOrEqualTo = timeUpdatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeUpatedLessThan(Date timeUpatedLessThan) {
            this.timeUpatedLessThan = timeUpatedLessThan;
            return this;
        }

        public Builder timeUpatedLessThanOrEqualTo(Date timeUpatedLessThanOrEqualTo) {
            this.timeUpatedLessThanOrEqualTo = timeUpatedLessThanOrEqualTo;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDisApplicationTaskRunLineagesRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.disApplicationId(o.getDisApplicationId());
            this.opcRequestId(o.getOpcRequestId());
            this.fields(o.getFields());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.filter(o.getFilter());
            this.timeUpdatedGreaterThan(o.getTimeUpdatedGreaterThan());
            this.timeUpdatedGreaterThanOrEqualTo(o.getTimeUpdatedGreaterThanOrEqualTo());
            this.timeUpatedLessThan(o.getTimeUpatedLessThan());
            this.timeUpatedLessThanOrEqualTo(o.getTimeUpatedLessThanOrEqualTo());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDisApplicationTaskRunLineagesRequest build() {
            ListDisApplicationTaskRunLineagesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDisApplicationTaskRunLineagesRequest buildWithoutInvocationCallback() {
            ListDisApplicationTaskRunLineagesRequest request = new ListDisApplicationTaskRunLineagesRequest();
            request.workspaceId = this.workspaceId;
            request.disApplicationId = this.disApplicationId;
            request.opcRequestId = this.opcRequestId;
            request.fields = this.fields;
            request.page = this.page;
            request.limit = this.limit;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.filter = this.filter;
            request.timeUpdatedGreaterThan = this.timeUpdatedGreaterThan;
            request.timeUpdatedGreaterThanOrEqualTo = this.timeUpdatedGreaterThanOrEqualTo;
            request.timeUpatedLessThan = this.timeUpatedLessThan;
            request.timeUpatedLessThanOrEqualTo = this.timeUpatedLessThanOrEqualTo;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("TIME_CREATED"),
        DisplayName("DISPLAY_NAME"),
        TimeUpdated("TIME_UPDATED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

