/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdateCopyObjectRequestDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateCopyObjectRequestRequest
extends BmcRequest<UpdateCopyObjectRequestDetails> {
    private String workspaceId;
    private String copyObjectRequestKey;
    private UpdateCopyObjectRequestDetails updateCopyObjectRequestDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getCopyObjectRequestKey() {
        return this.copyObjectRequestKey;
    }

    public UpdateCopyObjectRequestDetails getUpdateCopyObjectRequestDetails() {
        return this.updateCopyObjectRequestDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateCopyObjectRequestDetails getBody$() {
        return this.updateCopyObjectRequestDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).copyObjectRequestKey(this.copyObjectRequestKey).updateCopyObjectRequestDetails(this.updateCopyObjectRequestDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",copyObjectRequestKey=").append(String.valueOf(this.copyObjectRequestKey));
        sb.append(",updateCopyObjectRequestDetails=").append(String.valueOf((Object)this.updateCopyObjectRequestDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateCopyObjectRequestRequest)) {
            return false;
        }
        UpdateCopyObjectRequestRequest other = (UpdateCopyObjectRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.copyObjectRequestKey, other.copyObjectRequestKey) && Objects.equals((Object)this.updateCopyObjectRequestDetails, (Object)other.updateCopyObjectRequestDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.copyObjectRequestKey == null ? 43 : this.copyObjectRequestKey.hashCode());
        result = result * 59 + (this.updateCopyObjectRequestDetails == null ? 43 : this.updateCopyObjectRequestDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateCopyObjectRequestRequest, UpdateCopyObjectRequestDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String copyObjectRequestKey = null;
        private UpdateCopyObjectRequestDetails updateCopyObjectRequestDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder copyObjectRequestKey(String copyObjectRequestKey) {
            this.copyObjectRequestKey = copyObjectRequestKey;
            return this;
        }

        public Builder updateCopyObjectRequestDetails(UpdateCopyObjectRequestDetails updateCopyObjectRequestDetails) {
            this.updateCopyObjectRequestDetails = updateCopyObjectRequestDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateCopyObjectRequestRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.copyObjectRequestKey(o.getCopyObjectRequestKey());
            this.updateCopyObjectRequestDetails(o.getUpdateCopyObjectRequestDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateCopyObjectRequestRequest build() {
            UpdateCopyObjectRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateCopyObjectRequestDetails body) {
            this.updateCopyObjectRequestDetails(body);
            return this;
        }

        public UpdateCopyObjectRequestRequest buildWithoutInvocationCallback() {
            UpdateCopyObjectRequestRequest request = new UpdateCopyObjectRequestRequest();
            request.workspaceId = this.workspaceId;
            request.copyObjectRequestKey = this.copyObjectRequestKey;
            request.updateCopyObjectRequestDetails = this.updateCopyObjectRequestDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

