/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdateImportRequestDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateImportRequestRequest
extends BmcRequest<UpdateImportRequestDetails> {
    private String workspaceId;
    private String importRequestKey;
    private UpdateImportRequestDetails updateImportRequestDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getImportRequestKey() {
        return this.importRequestKey;
    }

    public UpdateImportRequestDetails getUpdateImportRequestDetails() {
        return this.updateImportRequestDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateImportRequestDetails getBody$() {
        return this.updateImportRequestDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).importRequestKey(this.importRequestKey).updateImportRequestDetails(this.updateImportRequestDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",importRequestKey=").append(String.valueOf(this.importRequestKey));
        sb.append(",updateImportRequestDetails=").append(String.valueOf((Object)this.updateImportRequestDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateImportRequestRequest)) {
            return false;
        }
        UpdateImportRequestRequest other = (UpdateImportRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.importRequestKey, other.importRequestKey) && Objects.equals((Object)this.updateImportRequestDetails, (Object)other.updateImportRequestDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.importRequestKey == null ? 43 : this.importRequestKey.hashCode());
        result = result * 59 + (this.updateImportRequestDetails == null ? 43 : this.updateImportRequestDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateImportRequestRequest, UpdateImportRequestDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String importRequestKey = null;
        private UpdateImportRequestDetails updateImportRequestDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder importRequestKey(String importRequestKey) {
            this.importRequestKey = importRequestKey;
            return this;
        }

        public Builder updateImportRequestDetails(UpdateImportRequestDetails updateImportRequestDetails) {
            this.updateImportRequestDetails = updateImportRequestDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateImportRequestRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.importRequestKey(o.getImportRequestKey());
            this.updateImportRequestDetails(o.getUpdateImportRequestDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateImportRequestRequest build() {
            UpdateImportRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateImportRequestDetails body) {
            this.updateImportRequestDetails(body);
            return this;
        }

        public UpdateImportRequestRequest buildWithoutInvocationCallback() {
            UpdateImportRequestRequest request = new UpdateImportRequestRequest();
            request.workspaceId = this.workspaceId;
            request.importRequestKey = this.importRequestKey;
            request.updateImportRequestDetails = this.updateImportRequestDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

