/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration;

import com.oracle.bmc.dataintegration.DataIntegration;
import com.oracle.bmc.dataintegration.model.Application;
import com.oracle.bmc.dataintegration.model.DependentObject;
import com.oracle.bmc.dataintegration.model.DisApplication;
import com.oracle.bmc.dataintegration.model.Template;
import com.oracle.bmc.dataintegration.model.Workspace;
import com.oracle.bmc.dataintegration.requests.GetApplicationRequest;
import com.oracle.bmc.dataintegration.requests.GetDependentObjectRequest;
import com.oracle.bmc.dataintegration.requests.GetDisApplicationRequest;
import com.oracle.bmc.dataintegration.requests.GetTemplateRequest;
import com.oracle.bmc.dataintegration.requests.GetWorkRequestRequest;
import com.oracle.bmc.dataintegration.requests.GetWorkspaceRequest;
import com.oracle.bmc.dataintegration.responses.GetApplicationResponse;
import com.oracle.bmc.dataintegration.responses.GetDependentObjectResponse;
import com.oracle.bmc.dataintegration.responses.GetDisApplicationResponse;
import com.oracle.bmc.dataintegration.responses.GetTemplateResponse;
import com.oracle.bmc.dataintegration.responses.GetWorkRequestResponse;
import com.oracle.bmc.dataintegration.responses.GetWorkspaceResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DataIntegrationWaiters {
    private final ExecutorService executorService;
    private final DataIntegration client;

    public DataIntegrationWaiters(ExecutorService executorService, DataIntegration client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(GetApplicationRequest request, Application.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forApplication(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(GetApplicationRequest request, Application.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forApplication(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(GetApplicationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Application.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forApplication(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(BmcGenericWaiter waiter, GetApplicationRequest request, Application.LifecycleState ... targetStates) {
        final HashSet<Application.LifecycleState> targetStatesSet = new HashSet<Application.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetApplicationRequest, GetApplicationResponse>(){

            @Override
            public GetApplicationResponse apply(GetApplicationRequest request) {
                return DataIntegrationWaiters.this.client.getApplication(request);
            }
        }, (Predicate)new Predicate<GetApplicationResponse>(){

            @Override
            public boolean test(GetApplicationResponse response) {
                return targetStatesSet.contains((Object)response.getApplication().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Application.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDependentObjectRequest, GetDependentObjectResponse> forDependentObject(GetDependentObjectRequest request, DependentObject.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDependentObject(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDependentObjectRequest, GetDependentObjectResponse> forDependentObject(GetDependentObjectRequest request, DependentObject.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDependentObject(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDependentObjectRequest, GetDependentObjectResponse> forDependentObject(GetDependentObjectRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DependentObject.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDependentObject(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDependentObjectRequest, GetDependentObjectResponse> forDependentObject(BmcGenericWaiter waiter, GetDependentObjectRequest request, DependentObject.LifecycleState ... targetStates) {
        final HashSet<DependentObject.LifecycleState> targetStatesSet = new HashSet<DependentObject.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDependentObjectRequest, GetDependentObjectResponse>(){

            @Override
            public GetDependentObjectResponse apply(GetDependentObjectRequest request) {
                return DataIntegrationWaiters.this.client.getDependentObject(request);
            }
        }, (Predicate)new Predicate<GetDependentObjectResponse>(){

            @Override
            public boolean test(GetDependentObjectResponse response) {
                return targetStatesSet.contains((Object)response.getDependentObject().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DependentObject.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDisApplicationRequest, GetDisApplicationResponse> forDisApplication(GetDisApplicationRequest request, DisApplication.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDisApplication(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDisApplicationRequest, GetDisApplicationResponse> forDisApplication(GetDisApplicationRequest request, DisApplication.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDisApplication(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDisApplicationRequest, GetDisApplicationResponse> forDisApplication(GetDisApplicationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DisApplication.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDisApplication(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDisApplicationRequest, GetDisApplicationResponse> forDisApplication(BmcGenericWaiter waiter, GetDisApplicationRequest request, DisApplication.LifecycleState ... targetStates) {
        final HashSet<DisApplication.LifecycleState> targetStatesSet = new HashSet<DisApplication.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDisApplicationRequest, GetDisApplicationResponse>(){

            @Override
            public GetDisApplicationResponse apply(GetDisApplicationRequest request) {
                return DataIntegrationWaiters.this.client.getDisApplication(request);
            }
        }, (Predicate)new Predicate<GetDisApplicationResponse>(){

            @Override
            public boolean test(GetDisApplicationResponse response) {
                return targetStatesSet.contains((Object)response.getDisApplication().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DisApplication.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTemplateRequest, GetTemplateResponse> forTemplate(GetTemplateRequest request, Template.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTemplate(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTemplateRequest, GetTemplateResponse> forTemplate(GetTemplateRequest request, Template.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTemplate(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTemplateRequest, GetTemplateResponse> forTemplate(GetTemplateRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Template.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTemplate(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTemplateRequest, GetTemplateResponse> forTemplate(BmcGenericWaiter waiter, GetTemplateRequest request, Template.LifecycleState ... targetStates) {
        final HashSet<Template.LifecycleState> targetStatesSet = new HashSet<Template.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTemplateRequest, GetTemplateResponse>(){

            @Override
            public GetTemplateResponse apply(GetTemplateRequest request) {
                return DataIntegrationWaiters.this.client.getTemplate(request);
            }
        }, (Predicate)new Predicate<GetTemplateResponse>(){

            @Override
            public boolean test(GetTemplateResponse response) {
                return targetStatesSet.contains((Object)response.getTemplate().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Template.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DataIntegrationWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    public Waiter<GetWorkspaceRequest, GetWorkspaceResponse> forWorkspace(GetWorkspaceRequest request, Workspace.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forWorkspace(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetWorkspaceRequest, GetWorkspaceResponse> forWorkspace(GetWorkspaceRequest request, Workspace.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forWorkspace(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetWorkspaceRequest, GetWorkspaceResponse> forWorkspace(GetWorkspaceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Workspace.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forWorkspace(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetWorkspaceRequest, GetWorkspaceResponse> forWorkspace(BmcGenericWaiter waiter, GetWorkspaceRequest request, Workspace.LifecycleState ... targetStates) {
        final HashSet<Workspace.LifecycleState> targetStatesSet = new HashSet<Workspace.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkspaceRequest, GetWorkspaceResponse>(){

            @Override
            public GetWorkspaceResponse apply(GetWorkspaceRequest request) {
                return DataIntegrationWaiters.this.client.getWorkspace(request);
            }
        }, (Predicate)new Predicate<GetWorkspaceResponse>(){

            @Override
            public boolean test(GetWorkspaceResponse response) {
                return targetStatesSet.contains((Object)response.getWorkspace().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Workspace.LifecycleState.Deleted)), (Object)request);
    }
}

