/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CancelRestCallConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="methodType")
    private final MethodType methodType;
    @JsonProperty(value="requestHeaders")
    private final Map<String, String> requestHeaders;
    @JsonProperty(value="configValues")
    private final ConfigValues configValues;

    @Deprecated
    @ConstructorProperties(value={"methodType", "requestHeaders", "configValues"})
    public CancelRestCallConfig(MethodType methodType, Map<String, String> requestHeaders, ConfigValues configValues) {
        this.methodType = methodType;
        this.requestHeaders = requestHeaders;
        this.configValues = configValues;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public ConfigValues getConfigValues() {
        return this.configValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CancelRestCallConfig(");
        sb.append("super=").append(super.toString());
        sb.append("methodType=").append(String.valueOf((Object)this.methodType));
        sb.append(", requestHeaders=").append(String.valueOf(this.requestHeaders));
        sb.append(", configValues=").append(String.valueOf((Object)this.configValues));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CancelRestCallConfig)) {
            return false;
        }
        CancelRestCallConfig other = (CancelRestCallConfig)((Object)o);
        return Objects.equals((Object)this.methodType, (Object)other.methodType) && Objects.equals(this.requestHeaders, other.requestHeaders) && Objects.equals((Object)this.configValues, (Object)other.configValues) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.methodType == null ? 43 : this.methodType.hashCode());
        result = result * 59 + (this.requestHeaders == null ? 43 : this.requestHeaders.hashCode());
        result = result * 59 + (this.configValues == null ? 43 : this.configValues.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum MethodType implements BmcEnum
    {
        Get("GET"),
        Post("POST"),
        Patch("PATCH"),
        Delete("DELETE"),
        Put("PUT");

        private final String value;
        private static Map<String, MethodType> map;

        private MethodType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MethodType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid MethodType: " + key);
        }

        static {
            map = new HashMap<String, MethodType>();
            for (MethodType v : MethodType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="methodType")
        private MethodType methodType;
        @JsonProperty(value="requestHeaders")
        private Map<String, String> requestHeaders;
        @JsonProperty(value="configValues")
        private ConfigValues configValues;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder methodType(MethodType methodType) {
            this.methodType = methodType;
            this.__explicitlySet__.add("methodType");
            return this;
        }

        public Builder requestHeaders(Map<String, String> requestHeaders) {
            this.requestHeaders = requestHeaders;
            this.__explicitlySet__.add("requestHeaders");
            return this;
        }

        public Builder configValues(ConfigValues configValues) {
            this.configValues = configValues;
            this.__explicitlySet__.add("configValues");
            return this;
        }

        public CancelRestCallConfig build() {
            CancelRestCallConfig model = new CancelRestCallConfig(this.methodType, this.requestHeaders, this.configValues);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CancelRestCallConfig model) {
            if (model.wasPropertyExplicitlySet("methodType")) {
                this.methodType(model.getMethodType());
            }
            if (model.wasPropertyExplicitlySet("requestHeaders")) {
                this.requestHeaders(model.getRequestHeaders());
            }
            if (model.wasPropertyExplicitlySet("configValues")) {
                this.configValues(model.getConfigValues());
            }
            return this;
        }
    }
}

