/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.Expression;
import com.oracle.bmc.dataintegration.model.FieldMap;
import com.oracle.bmc.dataintegration.model.FlowPortLink;
import com.oracle.bmc.dataintegration.model.OutputLink;
import com.oracle.bmc.dataintegration.model.ParentReference;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class ConditionalInputLink
extends FlowPortLink {
    @JsonProperty(value="fromLink")
    private final OutputLink fromLink;
    @JsonProperty(value="fieldMap")
    private final FieldMap fieldMap;
    @JsonProperty(value="condition")
    private final Expression condition;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ConditionalInputLink(String key, String modelVersion, ParentReference parentRef, Integer objectStatus, String description, String port, OutputLink fromLink, FieldMap fieldMap, Expression condition) {
        super(key, modelVersion, parentRef, objectStatus, description, port);
        this.fromLink = fromLink;
        this.fieldMap = fieldMap;
        this.condition = condition;
    }

    public OutputLink getFromLink() {
        return this.fromLink;
    }

    public FieldMap getFieldMap() {
        return this.fieldMap;
    }

    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConditionalInputLink(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", fromLink=").append(String.valueOf((Object)this.fromLink));
        sb.append(", fieldMap=").append(String.valueOf((Object)this.fieldMap));
        sb.append(", condition=").append(String.valueOf((Object)this.condition));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConditionalInputLink)) {
            return false;
        }
        ConditionalInputLink other = (ConditionalInputLink)((Object)o);
        return Objects.equals((Object)this.fromLink, (Object)other.fromLink) && Objects.equals((Object)this.fieldMap, (Object)other.fieldMap) && Objects.equals((Object)this.condition, (Object)other.condition) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fromLink == null ? 43 : this.fromLink.hashCode());
        result = result * 59 + (this.fieldMap == null ? 43 : this.fieldMap.hashCode());
        result = result * 59 + (this.condition == null ? 43 : this.condition.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="port")
        private String port;
        @JsonProperty(value="fromLink")
        private OutputLink fromLink;
        @JsonProperty(value="fieldMap")
        private FieldMap fieldMap;
        @JsonProperty(value="condition")
        private Expression condition;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder port(String port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder fromLink(OutputLink fromLink) {
            this.fromLink = fromLink;
            this.__explicitlySet__.add("fromLink");
            return this;
        }

        public Builder fieldMap(FieldMap fieldMap) {
            this.fieldMap = fieldMap;
            this.__explicitlySet__.add("fieldMap");
            return this;
        }

        public Builder condition(Expression condition) {
            this.condition = condition;
            this.__explicitlySet__.add("condition");
            return this;
        }

        public ConditionalInputLink build() {
            ConditionalInputLink model = new ConditionalInputLink(this.key, this.modelVersion, this.parentRef, this.objectStatus, this.description, this.port, this.fromLink, this.fieldMap, this.condition);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConditionalInputLink model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("fromLink")) {
                this.fromLink(model.getFromLink());
            }
            if (model.wasPropertyExplicitlySet("fieldMap")) {
                this.fieldMap(model.getFieldMap());
            }
            if (model.wasPropertyExplicitlySet("condition")) {
                this.condition(model.getCondition());
            }
            return this;
        }
    }
}

