/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConnectionDetails;
import com.oracle.bmc.dataintegration.model.ConnectionProperty;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Schema;
import com.oracle.bmc.dataintegration.model.SensitiveAttribute;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class ConnectionFromOAuth2Details
extends ConnectionDetails {
    @JsonProperty(value="accessTokenUrl")
    private final String accessTokenUrl;
    @JsonProperty(value="clientId")
    private final String clientId;
    @JsonProperty(value="clientSecret")
    private final SensitiveAttribute clientSecret;
    @JsonProperty(value="scope")
    private final String scope;
    @JsonProperty(value="grantType")
    private final GrantType grantType;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ConnectionFromOAuth2Details(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, Schema primarySchema, List<ConnectionProperty> connectionProperties, Boolean isDefault, ObjectMetadata metadata, String accessTokenUrl, String clientId, SensitiveAttribute clientSecret, String scope, GrantType grantType) {
        super(key, modelVersion, parentRef, name, description, objectVersion, objectStatus, identifier, primarySchema, connectionProperties, isDefault, metadata);
        this.accessTokenUrl = accessTokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
        this.grantType = grantType;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public SensitiveAttribute getClientSecret() {
        return this.clientSecret;
    }

    public String getScope() {
        return this.scope;
    }

    public GrantType getGrantType() {
        return this.grantType;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionFromOAuth2Details(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", accessTokenUrl=").append(String.valueOf(this.accessTokenUrl));
        sb.append(", clientId=").append(String.valueOf(this.clientId));
        sb.append(", clientSecret=").append(String.valueOf((Object)this.clientSecret));
        sb.append(", scope=").append(String.valueOf(this.scope));
        sb.append(", grantType=").append(String.valueOf((Object)this.grantType));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionFromOAuth2Details)) {
            return false;
        }
        ConnectionFromOAuth2Details other = (ConnectionFromOAuth2Details)((Object)o);
        return Objects.equals(this.accessTokenUrl, other.accessTokenUrl) && Objects.equals(this.clientId, other.clientId) && Objects.equals((Object)this.clientSecret, (Object)other.clientSecret) && Objects.equals(this.scope, other.scope) && Objects.equals((Object)this.grantType, (Object)other.grantType) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.accessTokenUrl == null ? 43 : this.accessTokenUrl.hashCode());
        result = result * 59 + (this.clientId == null ? 43 : this.clientId.hashCode());
        result = result * 59 + (this.clientSecret == null ? 43 : this.clientSecret.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.grantType == null ? 43 : this.grantType.hashCode());
        return result;
    }

    public static enum GrantType implements BmcEnum
    {
        ClientCredentials("CLIENT_CREDENTIALS");

        private final String value;
        private static Map<String, GrantType> map;

        private GrantType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static GrantType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid GrantType: " + key);
        }

        static {
            map = new HashMap<String, GrantType>();
            for (GrantType v : GrantType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="primarySchema")
        private Schema primarySchema;
        @JsonProperty(value="connectionProperties")
        private List<ConnectionProperty> connectionProperties;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="accessTokenUrl")
        private String accessTokenUrl;
        @JsonProperty(value="clientId")
        private String clientId;
        @JsonProperty(value="clientSecret")
        private SensitiveAttribute clientSecret;
        @JsonProperty(value="scope")
        private String scope;
        @JsonProperty(value="grantType")
        private GrantType grantType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder primarySchema(Schema primarySchema) {
            this.primarySchema = primarySchema;
            this.__explicitlySet__.add("primarySchema");
            return this;
        }

        public Builder connectionProperties(List<ConnectionProperty> connectionProperties) {
            this.connectionProperties = connectionProperties;
            this.__explicitlySet__.add("connectionProperties");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder accessTokenUrl(String accessTokenUrl) {
            this.accessTokenUrl = accessTokenUrl;
            this.__explicitlySet__.add("accessTokenUrl");
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            this.__explicitlySet__.add("clientId");
            return this;
        }

        public Builder clientSecret(SensitiveAttribute clientSecret) {
            this.clientSecret = clientSecret;
            this.__explicitlySet__.add("clientSecret");
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            this.__explicitlySet__.add("scope");
            return this;
        }

        public Builder grantType(GrantType grantType) {
            this.grantType = grantType;
            this.__explicitlySet__.add("grantType");
            return this;
        }

        public ConnectionFromOAuth2Details build() {
            ConnectionFromOAuth2Details model = new ConnectionFromOAuth2Details(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.objectStatus, this.identifier, this.primarySchema, this.connectionProperties, this.isDefault, this.metadata, this.accessTokenUrl, this.clientId, this.clientSecret, this.scope, this.grantType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConnectionFromOAuth2Details model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("primarySchema")) {
                this.primarySchema(model.getPrimarySchema());
            }
            if (model.wasPropertyExplicitlySet("connectionProperties")) {
                this.connectionProperties(model.getConnectionProperties());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("accessTokenUrl")) {
                this.accessTokenUrl(model.getAccessTokenUrl());
            }
            if (model.wasPropertyExplicitlySet("clientId")) {
                this.clientId(model.getClientId());
            }
            if (model.wasPropertyExplicitlySet("clientSecret")) {
                this.clientSecret(model.getClientSecret());
            }
            if (model.wasPropertyExplicitlySet("scope")) {
                this.scope(model.getScope());
            }
            if (model.wasPropertyExplicitlySet("grantType")) {
                this.grantType(model.getGrantType());
            }
            return this;
        }
    }
}

