/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConnectionProperty;
import com.oracle.bmc.dataintegration.model.ConnectionSummary;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Schema;
import com.oracle.bmc.dataintegration.model.SensitiveAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class ConnectionSummaryFromAtp
extends ConnectionSummary {
    @JsonProperty(value="tnsAlias")
    private final String tnsAlias;
    @JsonProperty(value="tnsNames")
    private final List<String> tnsNames;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="passwordSecret")
    private final SensitiveAttribute passwordSecret;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ConnectionSummaryFromAtp(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, Schema primarySchema, List<ConnectionProperty> connectionProperties, Boolean isDefault, ObjectMetadata metadata, Map<String, String> keyMap, String tnsAlias, List<String> tnsNames, String username, String password, SensitiveAttribute passwordSecret) {
        super(key, modelVersion, parentRef, name, description, objectVersion, objectStatus, identifier, primarySchema, connectionProperties, isDefault, metadata, keyMap);
        this.tnsAlias = tnsAlias;
        this.tnsNames = tnsNames;
        this.username = username;
        this.password = password;
        this.passwordSecret = passwordSecret;
    }

    public String getTnsAlias() {
        return this.tnsAlias;
    }

    public List<String> getTnsNames() {
        return this.tnsNames;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public SensitiveAttribute getPasswordSecret() {
        return this.passwordSecret;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionSummaryFromAtp(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", tnsAlias=").append(String.valueOf(this.tnsAlias));
        sb.append(", tnsNames=").append(String.valueOf(this.tnsNames));
        sb.append(", username=").append(String.valueOf(this.username));
        sb.append(", password=").append("<redacted>");
        sb.append(", passwordSecret=").append(String.valueOf((Object)this.passwordSecret));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionSummaryFromAtp)) {
            return false;
        }
        ConnectionSummaryFromAtp other = (ConnectionSummaryFromAtp)((Object)o);
        return Objects.equals(this.tnsAlias, other.tnsAlias) && Objects.equals(this.tnsNames, other.tnsNames) && Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && Objects.equals((Object)this.passwordSecret, (Object)other.passwordSecret) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tnsAlias == null ? 43 : this.tnsAlias.hashCode());
        result = result * 59 + (this.tnsNames == null ? 43 : this.tnsNames.hashCode());
        result = result * 59 + (this.username == null ? 43 : this.username.hashCode());
        result = result * 59 + (this.password == null ? 43 : this.password.hashCode());
        result = result * 59 + (this.passwordSecret == null ? 43 : this.passwordSecret.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="primarySchema")
        private Schema primarySchema;
        @JsonProperty(value="connectionProperties")
        private List<ConnectionProperty> connectionProperties;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="keyMap")
        private Map<String, String> keyMap;
        @JsonProperty(value="tnsAlias")
        private String tnsAlias;
        @JsonProperty(value="tnsNames")
        private List<String> tnsNames;
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="passwordSecret")
        private SensitiveAttribute passwordSecret;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder primarySchema(Schema primarySchema) {
            this.primarySchema = primarySchema;
            this.__explicitlySet__.add("primarySchema");
            return this;
        }

        public Builder connectionProperties(List<ConnectionProperty> connectionProperties) {
            this.connectionProperties = connectionProperties;
            this.__explicitlySet__.add("connectionProperties");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder keyMap(Map<String, String> keyMap) {
            this.keyMap = keyMap;
            this.__explicitlySet__.add("keyMap");
            return this;
        }

        public Builder tnsAlias(String tnsAlias) {
            this.tnsAlias = tnsAlias;
            this.__explicitlySet__.add("tnsAlias");
            return this;
        }

        public Builder tnsNames(List<String> tnsNames) {
            this.tnsNames = tnsNames;
            this.__explicitlySet__.add("tnsNames");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder passwordSecret(SensitiveAttribute passwordSecret) {
            this.passwordSecret = passwordSecret;
            this.__explicitlySet__.add("passwordSecret");
            return this;
        }

        public ConnectionSummaryFromAtp build() {
            ConnectionSummaryFromAtp model = new ConnectionSummaryFromAtp(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.objectStatus, this.identifier, this.primarySchema, this.connectionProperties, this.isDefault, this.metadata, this.keyMap, this.tnsAlias, this.tnsNames, this.username, this.password, this.passwordSecret);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConnectionSummaryFromAtp model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("primarySchema")) {
                this.primarySchema(model.getPrimarySchema());
            }
            if (model.wasPropertyExplicitlySet("connectionProperties")) {
                this.connectionProperties(model.getConnectionProperties());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("keyMap")) {
                this.keyMap(model.getKeyMap());
            }
            if (model.wasPropertyExplicitlySet("tnsAlias")) {
                this.tnsAlias(model.getTnsAlias());
            }
            if (model.wasPropertyExplicitlySet("tnsNames")) {
                this.tnsNames(model.getTnsNames());
            }
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("passwordSecret")) {
                this.passwordSecret(model.getPasswordSecret());
            }
            return this;
        }
    }
}

