/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConnectionProperty;
import com.oracle.bmc.dataintegration.model.ConnectionSummary;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Schema;
import com.oracle.bmc.dataintegration.model.SensitiveAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class ConnectionSummaryFromHdfs
extends ConnectionSummary {
    @JsonProperty(value="hdfsPrincipal")
    private final String hdfsPrincipal;
    @JsonProperty(value="dataNodePrincipal")
    private final String dataNodePrincipal;
    @JsonProperty(value="nameNodePrincipal")
    private final String nameNodePrincipal;
    @JsonProperty(value="realm")
    private final String realm;
    @JsonProperty(value="keyDistributionCenter")
    private final String keyDistributionCenter;
    @JsonProperty(value="keyTabContent")
    private final SensitiveAttribute keyTabContent;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ConnectionSummaryFromHdfs(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, Schema primarySchema, List<ConnectionProperty> connectionProperties, Boolean isDefault, ObjectMetadata metadata, Map<String, String> keyMap, String hdfsPrincipal, String dataNodePrincipal, String nameNodePrincipal, String realm, String keyDistributionCenter, SensitiveAttribute keyTabContent) {
        super(key, modelVersion, parentRef, name, description, objectVersion, objectStatus, identifier, primarySchema, connectionProperties, isDefault, metadata, keyMap);
        this.hdfsPrincipal = hdfsPrincipal;
        this.dataNodePrincipal = dataNodePrincipal;
        this.nameNodePrincipal = nameNodePrincipal;
        this.realm = realm;
        this.keyDistributionCenter = keyDistributionCenter;
        this.keyTabContent = keyTabContent;
    }

    public String getHdfsPrincipal() {
        return this.hdfsPrincipal;
    }

    public String getDataNodePrincipal() {
        return this.dataNodePrincipal;
    }

    public String getNameNodePrincipal() {
        return this.nameNodePrincipal;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getKeyDistributionCenter() {
        return this.keyDistributionCenter;
    }

    public SensitiveAttribute getKeyTabContent() {
        return this.keyTabContent;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionSummaryFromHdfs(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", hdfsPrincipal=").append(String.valueOf(this.hdfsPrincipal));
        sb.append(", dataNodePrincipal=").append(String.valueOf(this.dataNodePrincipal));
        sb.append(", nameNodePrincipal=").append(String.valueOf(this.nameNodePrincipal));
        sb.append(", realm=").append(String.valueOf(this.realm));
        sb.append(", keyDistributionCenter=").append(String.valueOf(this.keyDistributionCenter));
        sb.append(", keyTabContent=").append(String.valueOf((Object)this.keyTabContent));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionSummaryFromHdfs)) {
            return false;
        }
        ConnectionSummaryFromHdfs other = (ConnectionSummaryFromHdfs)((Object)o);
        return Objects.equals(this.hdfsPrincipal, other.hdfsPrincipal) && Objects.equals(this.dataNodePrincipal, other.dataNodePrincipal) && Objects.equals(this.nameNodePrincipal, other.nameNodePrincipal) && Objects.equals(this.realm, other.realm) && Objects.equals(this.keyDistributionCenter, other.keyDistributionCenter) && Objects.equals((Object)this.keyTabContent, (Object)other.keyTabContent) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.hdfsPrincipal == null ? 43 : this.hdfsPrincipal.hashCode());
        result = result * 59 + (this.dataNodePrincipal == null ? 43 : this.dataNodePrincipal.hashCode());
        result = result * 59 + (this.nameNodePrincipal == null ? 43 : this.nameNodePrincipal.hashCode());
        result = result * 59 + (this.realm == null ? 43 : this.realm.hashCode());
        result = result * 59 + (this.keyDistributionCenter == null ? 43 : this.keyDistributionCenter.hashCode());
        result = result * 59 + (this.keyTabContent == null ? 43 : this.keyTabContent.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="primarySchema")
        private Schema primarySchema;
        @JsonProperty(value="connectionProperties")
        private List<ConnectionProperty> connectionProperties;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="keyMap")
        private Map<String, String> keyMap;
        @JsonProperty(value="hdfsPrincipal")
        private String hdfsPrincipal;
        @JsonProperty(value="dataNodePrincipal")
        private String dataNodePrincipal;
        @JsonProperty(value="nameNodePrincipal")
        private String nameNodePrincipal;
        @JsonProperty(value="realm")
        private String realm;
        @JsonProperty(value="keyDistributionCenter")
        private String keyDistributionCenter;
        @JsonProperty(value="keyTabContent")
        private SensitiveAttribute keyTabContent;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder primarySchema(Schema primarySchema) {
            this.primarySchema = primarySchema;
            this.__explicitlySet__.add("primarySchema");
            return this;
        }

        public Builder connectionProperties(List<ConnectionProperty> connectionProperties) {
            this.connectionProperties = connectionProperties;
            this.__explicitlySet__.add("connectionProperties");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder keyMap(Map<String, String> keyMap) {
            this.keyMap = keyMap;
            this.__explicitlySet__.add("keyMap");
            return this;
        }

        public Builder hdfsPrincipal(String hdfsPrincipal) {
            this.hdfsPrincipal = hdfsPrincipal;
            this.__explicitlySet__.add("hdfsPrincipal");
            return this;
        }

        public Builder dataNodePrincipal(String dataNodePrincipal) {
            this.dataNodePrincipal = dataNodePrincipal;
            this.__explicitlySet__.add("dataNodePrincipal");
            return this;
        }

        public Builder nameNodePrincipal(String nameNodePrincipal) {
            this.nameNodePrincipal = nameNodePrincipal;
            this.__explicitlySet__.add("nameNodePrincipal");
            return this;
        }

        public Builder realm(String realm) {
            this.realm = realm;
            this.__explicitlySet__.add("realm");
            return this;
        }

        public Builder keyDistributionCenter(String keyDistributionCenter) {
            this.keyDistributionCenter = keyDistributionCenter;
            this.__explicitlySet__.add("keyDistributionCenter");
            return this;
        }

        public Builder keyTabContent(SensitiveAttribute keyTabContent) {
            this.keyTabContent = keyTabContent;
            this.__explicitlySet__.add("keyTabContent");
            return this;
        }

        public ConnectionSummaryFromHdfs build() {
            ConnectionSummaryFromHdfs model = new ConnectionSummaryFromHdfs(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.objectStatus, this.identifier, this.primarySchema, this.connectionProperties, this.isDefault, this.metadata, this.keyMap, this.hdfsPrincipal, this.dataNodePrincipal, this.nameNodePrincipal, this.realm, this.keyDistributionCenter, this.keyTabContent);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConnectionSummaryFromHdfs model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("primarySchema")) {
                this.primarySchema(model.getPrimarySchema());
            }
            if (model.wasPropertyExplicitlySet("connectionProperties")) {
                this.connectionProperties(model.getConnectionProperties());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("keyMap")) {
                this.keyMap(model.getKeyMap());
            }
            if (model.wasPropertyExplicitlySet("hdfsPrincipal")) {
                this.hdfsPrincipal(model.getHdfsPrincipal());
            }
            if (model.wasPropertyExplicitlySet("dataNodePrincipal")) {
                this.dataNodePrincipal(model.getDataNodePrincipal());
            }
            if (model.wasPropertyExplicitlySet("nameNodePrincipal")) {
                this.nameNodePrincipal(model.getNameNodePrincipal());
            }
            if (model.wasPropertyExplicitlySet("realm")) {
                this.realm(model.getRealm());
            }
            if (model.wasPropertyExplicitlySet("keyDistributionCenter")) {
                this.keyDistributionCenter(model.getKeyDistributionCenter());
            }
            if (model.wasPropertyExplicitlySet("keyTabContent")) {
                this.keyTabContent(model.getKeyTabContent());
            }
            return this;
        }
    }
}

