/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CopyConflictResolution
extends ExplicitlySetBmcModel {
    @JsonProperty(value="duplicatePrefix")
    private final String duplicatePrefix;
    @JsonProperty(value="duplicateSuffix")
    private final String duplicateSuffix;
    @JsonProperty(value="requestType")
    private final RequestType requestType;

    @Deprecated
    @ConstructorProperties(value={"duplicatePrefix", "duplicateSuffix", "requestType"})
    public CopyConflictResolution(String duplicatePrefix, String duplicateSuffix, RequestType requestType) {
        this.duplicatePrefix = duplicatePrefix;
        this.duplicateSuffix = duplicateSuffix;
        this.requestType = requestType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDuplicatePrefix() {
        return this.duplicatePrefix;
    }

    public String getDuplicateSuffix() {
        return this.duplicateSuffix;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CopyConflictResolution(");
        sb.append("super=").append(super.toString());
        sb.append("duplicatePrefix=").append(String.valueOf(this.duplicatePrefix));
        sb.append(", duplicateSuffix=").append(String.valueOf(this.duplicateSuffix));
        sb.append(", requestType=").append(String.valueOf((Object)this.requestType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CopyConflictResolution)) {
            return false;
        }
        CopyConflictResolution other = (CopyConflictResolution)((Object)o);
        return Objects.equals(this.duplicatePrefix, other.duplicatePrefix) && Objects.equals(this.duplicateSuffix, other.duplicateSuffix) && Objects.equals((Object)this.requestType, (Object)other.requestType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.duplicatePrefix == null ? 43 : this.duplicatePrefix.hashCode());
        result = result * 59 + (this.duplicateSuffix == null ? 43 : this.duplicateSuffix.hashCode());
        result = result * 59 + (this.requestType == null ? 43 : this.requestType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RequestType implements BmcEnum
    {
        Retain("RETAIN"),
        Duplicate("DUPLICATE"),
        Replace("REPLACE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RequestType> map;

        private RequestType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RequestType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RequestType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RequestType.class);
            map = new HashMap<String, RequestType>();
            for (RequestType v : RequestType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="duplicatePrefix")
        private String duplicatePrefix;
        @JsonProperty(value="duplicateSuffix")
        private String duplicateSuffix;
        @JsonProperty(value="requestType")
        private RequestType requestType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder duplicatePrefix(String duplicatePrefix) {
            this.duplicatePrefix = duplicatePrefix;
            this.__explicitlySet__.add("duplicatePrefix");
            return this;
        }

        public Builder duplicateSuffix(String duplicateSuffix) {
            this.duplicateSuffix = duplicateSuffix;
            this.__explicitlySet__.add("duplicateSuffix");
            return this;
        }

        public Builder requestType(RequestType requestType) {
            this.requestType = requestType;
            this.__explicitlySet__.add("requestType");
            return this;
        }

        public CopyConflictResolution build() {
            CopyConflictResolution model = new CopyConflictResolution(this.duplicatePrefix, this.duplicateSuffix, this.requestType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CopyConflictResolution model) {
            if (model.wasPropertyExplicitlySet("duplicatePrefix")) {
                this.duplicatePrefix(model.getDuplicatePrefix());
            }
            if (model.wasPropertyExplicitlySet("duplicateSuffix")) {
                this.duplicateSuffix(model.getDuplicateSuffix());
            }
            if (model.wasPropertyExplicitlySet("requestType")) {
                this.requestType(model.getRequestType());
            }
            return this;
        }
    }
}

