/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.CopyConflictResolution;
import com.oracle.bmc.dataintegration.model.CopyObjectMetadataSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CopyObjectRequest
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="sourceWorkspaceId")
    private final String sourceWorkspaceId;
    @JsonProperty(value="objectKeys")
    private final List<String> objectKeys;
    @JsonProperty(value="copyConflictResolution")
    private final CopyConflictResolution copyConflictResolution;
    @JsonProperty(value="copyMetadataObjectRequestStatus")
    private final CopyMetadataObjectRequestStatus copyMetadataObjectRequestStatus;
    @JsonProperty(value="createdBy")
    private final String createdBy;
    @JsonProperty(value="createdByName")
    private final String createdByName;
    @JsonProperty(value="totalSourceObjectCount")
    private final Integer totalSourceObjectCount;
    @JsonProperty(value="totalObjectsCopiedIntoTarget")
    private final Integer totalObjectsCopiedIntoTarget;
    @JsonProperty(value="timeStartedInMillis")
    private final Long timeStartedInMillis;
    @JsonProperty(value="timeEndedInMillis")
    private final Long timeEndedInMillis;
    @JsonProperty(value="copiedItems")
    private final List<CopyObjectMetadataSummary> copiedItems;
    @JsonProperty(value="referencedItems")
    private final List<CopyObjectMetadataSummary> referencedItems;
    @JsonProperty(value="name")
    private final String name;

    @Deprecated
    @ConstructorProperties(value={"key", "sourceWorkspaceId", "objectKeys", "copyConflictResolution", "copyMetadataObjectRequestStatus", "createdBy", "createdByName", "totalSourceObjectCount", "totalObjectsCopiedIntoTarget", "timeStartedInMillis", "timeEndedInMillis", "copiedItems", "referencedItems", "name"})
    public CopyObjectRequest(String key, String sourceWorkspaceId, List<String> objectKeys, CopyConflictResolution copyConflictResolution, CopyMetadataObjectRequestStatus copyMetadataObjectRequestStatus, String createdBy, String createdByName, Integer totalSourceObjectCount, Integer totalObjectsCopiedIntoTarget, Long timeStartedInMillis, Long timeEndedInMillis, List<CopyObjectMetadataSummary> copiedItems, List<CopyObjectMetadataSummary> referencedItems, String name) {
        this.key = key;
        this.sourceWorkspaceId = sourceWorkspaceId;
        this.objectKeys = objectKeys;
        this.copyConflictResolution = copyConflictResolution;
        this.copyMetadataObjectRequestStatus = copyMetadataObjectRequestStatus;
        this.createdBy = createdBy;
        this.createdByName = createdByName;
        this.totalSourceObjectCount = totalSourceObjectCount;
        this.totalObjectsCopiedIntoTarget = totalObjectsCopiedIntoTarget;
        this.timeStartedInMillis = timeStartedInMillis;
        this.timeEndedInMillis = timeEndedInMillis;
        this.copiedItems = copiedItems;
        this.referencedItems = referencedItems;
        this.name = name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getSourceWorkspaceId() {
        return this.sourceWorkspaceId;
    }

    public List<String> getObjectKeys() {
        return this.objectKeys;
    }

    public CopyConflictResolution getCopyConflictResolution() {
        return this.copyConflictResolution;
    }

    public CopyMetadataObjectRequestStatus getCopyMetadataObjectRequestStatus() {
        return this.copyMetadataObjectRequestStatus;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getCreatedByName() {
        return this.createdByName;
    }

    public Integer getTotalSourceObjectCount() {
        return this.totalSourceObjectCount;
    }

    public Integer getTotalObjectsCopiedIntoTarget() {
        return this.totalObjectsCopiedIntoTarget;
    }

    public Long getTimeStartedInMillis() {
        return this.timeStartedInMillis;
    }

    public Long getTimeEndedInMillis() {
        return this.timeEndedInMillis;
    }

    public List<CopyObjectMetadataSummary> getCopiedItems() {
        return this.copiedItems;
    }

    public List<CopyObjectMetadataSummary> getReferencedItems() {
        return this.referencedItems;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CopyObjectRequest(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", sourceWorkspaceId=").append(String.valueOf(this.sourceWorkspaceId));
        sb.append(", objectKeys=").append(String.valueOf(this.objectKeys));
        sb.append(", copyConflictResolution=").append(String.valueOf((Object)this.copyConflictResolution));
        sb.append(", copyMetadataObjectRequestStatus=").append(String.valueOf((Object)this.copyMetadataObjectRequestStatus));
        sb.append(", createdBy=").append(String.valueOf(this.createdBy));
        sb.append(", createdByName=").append(String.valueOf(this.createdByName));
        sb.append(", totalSourceObjectCount=").append(String.valueOf(this.totalSourceObjectCount));
        sb.append(", totalObjectsCopiedIntoTarget=").append(String.valueOf(this.totalObjectsCopiedIntoTarget));
        sb.append(", timeStartedInMillis=").append(String.valueOf(this.timeStartedInMillis));
        sb.append(", timeEndedInMillis=").append(String.valueOf(this.timeEndedInMillis));
        sb.append(", copiedItems=").append(String.valueOf(this.copiedItems));
        sb.append(", referencedItems=").append(String.valueOf(this.referencedItems));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CopyObjectRequest)) {
            return false;
        }
        CopyObjectRequest other = (CopyObjectRequest)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.sourceWorkspaceId, other.sourceWorkspaceId) && Objects.equals(this.objectKeys, other.objectKeys) && Objects.equals((Object)this.copyConflictResolution, (Object)other.copyConflictResolution) && Objects.equals((Object)this.copyMetadataObjectRequestStatus, (Object)other.copyMetadataObjectRequestStatus) && Objects.equals(this.createdBy, other.createdBy) && Objects.equals(this.createdByName, other.createdByName) && Objects.equals(this.totalSourceObjectCount, other.totalSourceObjectCount) && Objects.equals(this.totalObjectsCopiedIntoTarget, other.totalObjectsCopiedIntoTarget) && Objects.equals(this.timeStartedInMillis, other.timeStartedInMillis) && Objects.equals(this.timeEndedInMillis, other.timeEndedInMillis) && Objects.equals(this.copiedItems, other.copiedItems) && Objects.equals(this.referencedItems, other.referencedItems) && Objects.equals(this.name, other.name) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.sourceWorkspaceId == null ? 43 : this.sourceWorkspaceId.hashCode());
        result = result * 59 + (this.objectKeys == null ? 43 : this.objectKeys.hashCode());
        result = result * 59 + (this.copyConflictResolution == null ? 43 : this.copyConflictResolution.hashCode());
        result = result * 59 + (this.copyMetadataObjectRequestStatus == null ? 43 : this.copyMetadataObjectRequestStatus.hashCode());
        result = result * 59 + (this.createdBy == null ? 43 : this.createdBy.hashCode());
        result = result * 59 + (this.createdByName == null ? 43 : this.createdByName.hashCode());
        result = result * 59 + (this.totalSourceObjectCount == null ? 43 : this.totalSourceObjectCount.hashCode());
        result = result * 59 + (this.totalObjectsCopiedIntoTarget == null ? 43 : this.totalObjectsCopiedIntoTarget.hashCode());
        result = result * 59 + (this.timeStartedInMillis == null ? 43 : this.timeStartedInMillis.hashCode());
        result = result * 59 + (this.timeEndedInMillis == null ? 43 : this.timeEndedInMillis.hashCode());
        result = result * 59 + (this.copiedItems == null ? 43 : this.copiedItems.hashCode());
        result = result * 59 + (this.referencedItems == null ? 43 : this.referencedItems.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CopyMetadataObjectRequestStatus implements BmcEnum
    {
        Successful("SUCCESSFUL"),
        Failed("FAILED"),
        InProgress("IN_PROGRESS"),
        Queued("QUEUED"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CopyMetadataObjectRequestStatus> map;

        private CopyMetadataObjectRequestStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CopyMetadataObjectRequestStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CopyMetadataObjectRequestStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CopyMetadataObjectRequestStatus.class);
            map = new HashMap<String, CopyMetadataObjectRequestStatus>();
            for (CopyMetadataObjectRequestStatus v : CopyMetadataObjectRequestStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="sourceWorkspaceId")
        private String sourceWorkspaceId;
        @JsonProperty(value="objectKeys")
        private List<String> objectKeys;
        @JsonProperty(value="copyConflictResolution")
        private CopyConflictResolution copyConflictResolution;
        @JsonProperty(value="copyMetadataObjectRequestStatus")
        private CopyMetadataObjectRequestStatus copyMetadataObjectRequestStatus;
        @JsonProperty(value="createdBy")
        private String createdBy;
        @JsonProperty(value="createdByName")
        private String createdByName;
        @JsonProperty(value="totalSourceObjectCount")
        private Integer totalSourceObjectCount;
        @JsonProperty(value="totalObjectsCopiedIntoTarget")
        private Integer totalObjectsCopiedIntoTarget;
        @JsonProperty(value="timeStartedInMillis")
        private Long timeStartedInMillis;
        @JsonProperty(value="timeEndedInMillis")
        private Long timeEndedInMillis;
        @JsonProperty(value="copiedItems")
        private List<CopyObjectMetadataSummary> copiedItems;
        @JsonProperty(value="referencedItems")
        private List<CopyObjectMetadataSummary> referencedItems;
        @JsonProperty(value="name")
        private String name;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder sourceWorkspaceId(String sourceWorkspaceId) {
            this.sourceWorkspaceId = sourceWorkspaceId;
            this.__explicitlySet__.add("sourceWorkspaceId");
            return this;
        }

        public Builder objectKeys(List<String> objectKeys) {
            this.objectKeys = objectKeys;
            this.__explicitlySet__.add("objectKeys");
            return this;
        }

        public Builder copyConflictResolution(CopyConflictResolution copyConflictResolution) {
            this.copyConflictResolution = copyConflictResolution;
            this.__explicitlySet__.add("copyConflictResolution");
            return this;
        }

        public Builder copyMetadataObjectRequestStatus(CopyMetadataObjectRequestStatus copyMetadataObjectRequestStatus) {
            this.copyMetadataObjectRequestStatus = copyMetadataObjectRequestStatus;
            this.__explicitlySet__.add("copyMetadataObjectRequestStatus");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.__explicitlySet__.add("createdBy");
            return this;
        }

        public Builder createdByName(String createdByName) {
            this.createdByName = createdByName;
            this.__explicitlySet__.add("createdByName");
            return this;
        }

        public Builder totalSourceObjectCount(Integer totalSourceObjectCount) {
            this.totalSourceObjectCount = totalSourceObjectCount;
            this.__explicitlySet__.add("totalSourceObjectCount");
            return this;
        }

        public Builder totalObjectsCopiedIntoTarget(Integer totalObjectsCopiedIntoTarget) {
            this.totalObjectsCopiedIntoTarget = totalObjectsCopiedIntoTarget;
            this.__explicitlySet__.add("totalObjectsCopiedIntoTarget");
            return this;
        }

        public Builder timeStartedInMillis(Long timeStartedInMillis) {
            this.timeStartedInMillis = timeStartedInMillis;
            this.__explicitlySet__.add("timeStartedInMillis");
            return this;
        }

        public Builder timeEndedInMillis(Long timeEndedInMillis) {
            this.timeEndedInMillis = timeEndedInMillis;
            this.__explicitlySet__.add("timeEndedInMillis");
            return this;
        }

        public Builder copiedItems(List<CopyObjectMetadataSummary> copiedItems) {
            this.copiedItems = copiedItems;
            this.__explicitlySet__.add("copiedItems");
            return this;
        }

        public Builder referencedItems(List<CopyObjectMetadataSummary> referencedItems) {
            this.referencedItems = referencedItems;
            this.__explicitlySet__.add("referencedItems");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public CopyObjectRequest build() {
            CopyObjectRequest model = new CopyObjectRequest(this.key, this.sourceWorkspaceId, this.objectKeys, this.copyConflictResolution, this.copyMetadataObjectRequestStatus, this.createdBy, this.createdByName, this.totalSourceObjectCount, this.totalObjectsCopiedIntoTarget, this.timeStartedInMillis, this.timeEndedInMillis, this.copiedItems, this.referencedItems, this.name);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CopyObjectRequest model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("sourceWorkspaceId")) {
                this.sourceWorkspaceId(model.getSourceWorkspaceId());
            }
            if (model.wasPropertyExplicitlySet("objectKeys")) {
                this.objectKeys(model.getObjectKeys());
            }
            if (model.wasPropertyExplicitlySet("copyConflictResolution")) {
                this.copyConflictResolution(model.getCopyConflictResolution());
            }
            if (model.wasPropertyExplicitlySet("copyMetadataObjectRequestStatus")) {
                this.copyMetadataObjectRequestStatus(model.getCopyMetadataObjectRequestStatus());
            }
            if (model.wasPropertyExplicitlySet("createdBy")) {
                this.createdBy(model.getCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("createdByName")) {
                this.createdByName(model.getCreatedByName());
            }
            if (model.wasPropertyExplicitlySet("totalSourceObjectCount")) {
                this.totalSourceObjectCount(model.getTotalSourceObjectCount());
            }
            if (model.wasPropertyExplicitlySet("totalObjectsCopiedIntoTarget")) {
                this.totalObjectsCopiedIntoTarget(model.getTotalObjectsCopiedIntoTarget());
            }
            if (model.wasPropertyExplicitlySet("timeStartedInMillis")) {
                this.timeStartedInMillis(model.getTimeStartedInMillis());
            }
            if (model.wasPropertyExplicitlySet("timeEndedInMillis")) {
                this.timeEndedInMillis(model.getTimeEndedInMillis());
            }
            if (model.wasPropertyExplicitlySet("copiedItems")) {
                this.copiedItems(model.getCopiedItems());
            }
            if (model.wasPropertyExplicitlySet("referencedItems")) {
                this.referencedItems(model.getReferencedItems());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            return this;
        }
    }
}

