/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CountStatisticSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="objectType")
    private final ObjectType objectType;
    @JsonProperty(value="objectCount")
    private final Long objectCount;

    @Deprecated
    @ConstructorProperties(value={"objectType", "objectCount"})
    public CountStatisticSummary(ObjectType objectType, Long objectCount) {
        this.objectType = objectType;
        this.objectCount = objectCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public Long getObjectCount() {
        return this.objectCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CountStatisticSummary(");
        sb.append("super=").append(super.toString());
        sb.append("objectType=").append(String.valueOf((Object)this.objectType));
        sb.append(", objectCount=").append(String.valueOf(this.objectCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CountStatisticSummary)) {
            return false;
        }
        CountStatisticSummary other = (CountStatisticSummary)((Object)o);
        return Objects.equals((Object)this.objectType, (Object)other.objectType) && Objects.equals(this.objectCount, other.objectCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.objectType == null ? 43 : this.objectType.hashCode());
        result = result * 59 + (this.objectCount == null ? 43 : this.objectCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ObjectType implements BmcEnum
    {
        Project("PROJECT"),
        Folder("FOLDER"),
        DataFlow("DATA_FLOW"),
        DataAsset("DATA_ASSET"),
        Connection("CONNECTION"),
        Task("TASK"),
        Application("APPLICATION"),
        FunctionLibrary("FUNCTION_LIBRARY"),
        UserDefinedFunction("USER_DEFINED_FUNCTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ObjectType> map;

        private ObjectType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ObjectType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ObjectType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ObjectType.class);
            map = new HashMap<String, ObjectType>();
            for (ObjectType v : ObjectType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="objectType")
        private ObjectType objectType;
        @JsonProperty(value="objectCount")
        private Long objectCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder objectType(ObjectType objectType) {
            this.objectType = objectType;
            this.__explicitlySet__.add("objectType");
            return this;
        }

        public Builder objectCount(Long objectCount) {
            this.objectCount = objectCount;
            this.__explicitlySet__.add("objectCount");
            return this;
        }

        public CountStatisticSummary build() {
            CountStatisticSummary model = new CountStatisticSummary(this.objectType, this.objectCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CountStatisticSummary model) {
            if (model.wasPropertyExplicitlySet("objectType")) {
                this.objectType(model.getObjectType());
            }
            if (model.wasPropertyExplicitlySet("objectCount")) {
                this.objectCount(model.getObjectCount());
            }
            return this;
        }
    }
}

