/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.CopyConflictResolution;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateCopyObjectRequestDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sourceWorkspaceId")
    private final String sourceWorkspaceId;
    @JsonProperty(value="objectKeys")
    private final List<String> objectKeys;
    @JsonProperty(value="copyConflictResolution")
    private final CopyConflictResolution copyConflictResolution;

    @Deprecated
    @ConstructorProperties(value={"sourceWorkspaceId", "objectKeys", "copyConflictResolution"})
    public CreateCopyObjectRequestDetails(String sourceWorkspaceId, List<String> objectKeys, CopyConflictResolution copyConflictResolution) {
        this.sourceWorkspaceId = sourceWorkspaceId;
        this.objectKeys = objectKeys;
        this.copyConflictResolution = copyConflictResolution;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSourceWorkspaceId() {
        return this.sourceWorkspaceId;
    }

    public List<String> getObjectKeys() {
        return this.objectKeys;
    }

    public CopyConflictResolution getCopyConflictResolution() {
        return this.copyConflictResolution;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateCopyObjectRequestDetails(");
        sb.append("super=").append(super.toString());
        sb.append("sourceWorkspaceId=").append(String.valueOf(this.sourceWorkspaceId));
        sb.append(", objectKeys=").append(String.valueOf(this.objectKeys));
        sb.append(", copyConflictResolution=").append(String.valueOf((Object)this.copyConflictResolution));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateCopyObjectRequestDetails)) {
            return false;
        }
        CreateCopyObjectRequestDetails other = (CreateCopyObjectRequestDetails)((Object)o);
        return Objects.equals(this.sourceWorkspaceId, other.sourceWorkspaceId) && Objects.equals(this.objectKeys, other.objectKeys) && Objects.equals((Object)this.copyConflictResolution, (Object)other.copyConflictResolution) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sourceWorkspaceId == null ? 43 : this.sourceWorkspaceId.hashCode());
        result = result * 59 + (this.objectKeys == null ? 43 : this.objectKeys.hashCode());
        result = result * 59 + (this.copyConflictResolution == null ? 43 : this.copyConflictResolution.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sourceWorkspaceId")
        private String sourceWorkspaceId;
        @JsonProperty(value="objectKeys")
        private List<String> objectKeys;
        @JsonProperty(value="copyConflictResolution")
        private CopyConflictResolution copyConflictResolution;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sourceWorkspaceId(String sourceWorkspaceId) {
            this.sourceWorkspaceId = sourceWorkspaceId;
            this.__explicitlySet__.add("sourceWorkspaceId");
            return this;
        }

        public Builder objectKeys(List<String> objectKeys) {
            this.objectKeys = objectKeys;
            this.__explicitlySet__.add("objectKeys");
            return this;
        }

        public Builder copyConflictResolution(CopyConflictResolution copyConflictResolution) {
            this.copyConflictResolution = copyConflictResolution;
            this.__explicitlySet__.add("copyConflictResolution");
            return this;
        }

        public CreateCopyObjectRequestDetails build() {
            CreateCopyObjectRequestDetails model = new CreateCopyObjectRequestDetails(this.sourceWorkspaceId, this.objectKeys, this.copyConflictResolution);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateCopyObjectRequestDetails model) {
            if (model.wasPropertyExplicitlySet("sourceWorkspaceId")) {
                this.sourceWorkspaceId(model.getSourceWorkspaceId());
            }
            if (model.wasPropertyExplicitlySet("objectKeys")) {
                this.objectKeys(model.getObjectKeys());
            }
            if (model.wasPropertyExplicitlySet("copyConflictResolution")) {
                this.copyConflictResolution(model.getCopyConflictResolution());
            }
            return this;
        }
    }
}

