/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.CreateConnectionDetails;
import com.oracle.bmc.dataintegration.model.CreateDataAssetDetails;
import com.oracle.bmc.dataintegration.model.RegistryMetadata;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateDataAssetFromRest
extends CreateDataAssetDetails {
    @JsonProperty(value="baseUrl")
    private final String baseUrl;
    @JsonProperty(value="manifestFileContent")
    private final String manifestFileContent;
    @JsonProperty(value="defaultConnection")
    private final CreateConnectionDetails defaultConnection;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateDataAssetFromRest(String key, String modelVersion, String name, String description, Integer objectStatus, String identifier, String externalKey, Map<String, String> assetProperties, RegistryMetadata registryMetadata, String baseUrl, String manifestFileContent, CreateConnectionDetails defaultConnection) {
        super(key, modelVersion, name, description, objectStatus, identifier, externalKey, assetProperties, registryMetadata);
        this.baseUrl = baseUrl;
        this.manifestFileContent = manifestFileContent;
        this.defaultConnection = defaultConnection;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getManifestFileContent() {
        return this.manifestFileContent;
    }

    public CreateConnectionDetails getDefaultConnection() {
        return this.defaultConnection;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDataAssetFromRest(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", baseUrl=").append(String.valueOf(this.baseUrl));
        sb.append(", manifestFileContent=").append(String.valueOf(this.manifestFileContent));
        sb.append(", defaultConnection=").append(String.valueOf((Object)this.defaultConnection));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDataAssetFromRest)) {
            return false;
        }
        CreateDataAssetFromRest other = (CreateDataAssetFromRest)((Object)o);
        return Objects.equals(this.baseUrl, other.baseUrl) && Objects.equals(this.manifestFileContent, other.manifestFileContent) && Objects.equals((Object)this.defaultConnection, (Object)other.defaultConnection) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.baseUrl == null ? 43 : this.baseUrl.hashCode());
        result = result * 59 + (this.manifestFileContent == null ? 43 : this.manifestFileContent.hashCode());
        result = result * 59 + (this.defaultConnection == null ? 43 : this.defaultConnection.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="externalKey")
        private String externalKey;
        @JsonProperty(value="assetProperties")
        private Map<String, String> assetProperties;
        @JsonProperty(value="registryMetadata")
        private RegistryMetadata registryMetadata;
        @JsonProperty(value="baseUrl")
        private String baseUrl;
        @JsonProperty(value="manifestFileContent")
        private String manifestFileContent;
        @JsonProperty(value="defaultConnection")
        private CreateConnectionDetails defaultConnection;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder externalKey(String externalKey) {
            this.externalKey = externalKey;
            this.__explicitlySet__.add("externalKey");
            return this;
        }

        public Builder assetProperties(Map<String, String> assetProperties) {
            this.assetProperties = assetProperties;
            this.__explicitlySet__.add("assetProperties");
            return this;
        }

        public Builder registryMetadata(RegistryMetadata registryMetadata) {
            this.registryMetadata = registryMetadata;
            this.__explicitlySet__.add("registryMetadata");
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            this.__explicitlySet__.add("baseUrl");
            return this;
        }

        public Builder manifestFileContent(String manifestFileContent) {
            this.manifestFileContent = manifestFileContent;
            this.__explicitlySet__.add("manifestFileContent");
            return this;
        }

        public Builder defaultConnection(CreateConnectionDetails defaultConnection) {
            this.defaultConnection = defaultConnection;
            this.__explicitlySet__.add("defaultConnection");
            return this;
        }

        public CreateDataAssetFromRest build() {
            CreateDataAssetFromRest model = new CreateDataAssetFromRest(this.key, this.modelVersion, this.name, this.description, this.objectStatus, this.identifier, this.externalKey, this.assetProperties, this.registryMetadata, this.baseUrl, this.manifestFileContent, this.defaultConnection);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDataAssetFromRest model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("externalKey")) {
                this.externalKey(model.getExternalKey());
            }
            if (model.wasPropertyExplicitlySet("assetProperties")) {
                this.assetProperties(model.getAssetProperties());
            }
            if (model.wasPropertyExplicitlySet("registryMetadata")) {
                this.registryMetadata(model.getRegistryMetadata());
            }
            if (model.wasPropertyExplicitlySet("baseUrl")) {
                this.baseUrl(model.getBaseUrl());
            }
            if (model.wasPropertyExplicitlySet("manifestFileContent")) {
                this.manifestFileContent(model.getManifestFileContent());
            }
            if (model.wasPropertyExplicitlySet("defaultConnection")) {
                this.defaultConnection(model.getDefaultConnection());
            }
            return this;
        }
    }
}

