/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.FlowNode;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.RegistryMetadata;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateDataFlowDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="nodes")
    private final List<FlowNode> nodes;
    @JsonProperty(value="parameters")
    private final List<Parameter> parameters;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="flowConfigValues")
    private final ConfigValues flowConfigValues;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="registryMetadata")
    private final RegistryMetadata registryMetadata;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "name", "identifier", "nodes", "parameters", "description", "flowConfigValues", "objectStatus", "registryMetadata"})
    public CreateDataFlowDetails(String key, String modelVersion, ParentReference parentRef, String name, String identifier, List<FlowNode> nodes, List<Parameter> parameters, String description, ConfigValues flowConfigValues, Integer objectStatus, RegistryMetadata registryMetadata) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.identifier = identifier;
        this.nodes = nodes;
        this.parameters = parameters;
        this.description = description;
        this.flowConfigValues = flowConfigValues;
        this.objectStatus = objectStatus;
        this.registryMetadata = registryMetadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<FlowNode> getNodes() {
        return this.nodes;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public String getDescription() {
        return this.description;
    }

    public ConfigValues getFlowConfigValues() {
        return this.flowConfigValues;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public RegistryMetadata getRegistryMetadata() {
        return this.registryMetadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDataFlowDetails(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", nodes=").append(String.valueOf(this.nodes));
        sb.append(", parameters=").append(String.valueOf(this.parameters));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", flowConfigValues=").append(String.valueOf((Object)this.flowConfigValues));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", registryMetadata=").append(String.valueOf((Object)this.registryMetadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDataFlowDetails)) {
            return false;
        }
        CreateDataFlowDetails other = (CreateDataFlowDetails)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.nodes, other.nodes) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.flowConfigValues, (Object)other.flowConfigValues) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals((Object)this.registryMetadata, (Object)other.registryMetadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.nodes == null ? 43 : this.nodes.hashCode());
        result = result * 59 + (this.parameters == null ? 43 : this.parameters.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.flowConfigValues == null ? 43 : this.flowConfigValues.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.registryMetadata == null ? 43 : this.registryMetadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="nodes")
        private List<FlowNode> nodes;
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="flowConfigValues")
        private ConfigValues flowConfigValues;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="registryMetadata")
        private RegistryMetadata registryMetadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder nodes(List<FlowNode> nodes) {
            this.nodes = nodes;
            this.__explicitlySet__.add("nodes");
            return this;
        }

        public Builder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder flowConfigValues(ConfigValues flowConfigValues) {
            this.flowConfigValues = flowConfigValues;
            this.__explicitlySet__.add("flowConfigValues");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder registryMetadata(RegistryMetadata registryMetadata) {
            this.registryMetadata = registryMetadata;
            this.__explicitlySet__.add("registryMetadata");
            return this;
        }

        public CreateDataFlowDetails build() {
            CreateDataFlowDetails model = new CreateDataFlowDetails(this.key, this.modelVersion, this.parentRef, this.name, this.identifier, this.nodes, this.parameters, this.description, this.flowConfigValues, this.objectStatus, this.registryMetadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDataFlowDetails model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("nodes")) {
                this.nodes(model.getNodes());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("flowConfigValues")) {
                this.flowConfigValues(model.getFlowConfigValues());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("registryMetadata")) {
                this.registryMetadata(model.getRegistryMetadata());
            }
            return this;
        }
    }
}

