/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.CreateEntityShapeDetails;
import com.oracle.bmc.dataintegration.model.DataFormat;
import com.oracle.bmc.dataintegration.model.ForeignKey;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Shape;
import com.oracle.bmc.dataintegration.model.UniqueKey;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateEntityShapeFromObject
extends CreateEntityShapeDetails {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="externalKey")
    private final String externalKey;
    @JsonProperty(value="shape")
    private final Shape shape;
    @JsonProperty(value="shapeId")
    private final String shapeId;
    @JsonProperty(value="entityType")
    private final EntityType entityType;
    @JsonProperty(value="otherTypeLabel")
    private final String otherTypeLabel;
    @JsonProperty(value="uniqueKeys")
    private final List<UniqueKey> uniqueKeys;
    @JsonProperty(value="foreignKeys")
    private final List<ForeignKey> foreignKeys;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="dataFormat")
    private final DataFormat dataFormat;
    @JsonProperty(value="identifier")
    private final String identifier;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateEntityShapeFromObject(String key, ParentReference parentRef, String name, String description, String externalKey, Shape shape, String shapeId, EntityType entityType, String otherTypeLabel, List<UniqueKey> uniqueKeys, List<ForeignKey> foreignKeys, String resourceName, DataFormat dataFormat, String identifier) {
        this.key = key;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.externalKey = externalKey;
        this.shape = shape;
        this.shapeId = shapeId;
        this.entityType = entityType;
        this.otherTypeLabel = otherTypeLabel;
        this.uniqueKeys = uniqueKeys;
        this.foreignKeys = foreignKeys;
        this.resourceName = resourceName;
        this.dataFormat = dataFormat;
        this.identifier = identifier;
    }

    public String getKey() {
        return this.key;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public Shape getShape() {
        return this.shape;
    }

    public String getShapeId() {
        return this.shapeId;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public String getOtherTypeLabel() {
        return this.otherTypeLabel;
    }

    public List<UniqueKey> getUniqueKeys() {
        return this.uniqueKeys;
    }

    public List<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateEntityShapeFromObject(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", externalKey=").append(String.valueOf(this.externalKey));
        sb.append(", shape=").append(String.valueOf((Object)this.shape));
        sb.append(", shapeId=").append(String.valueOf(this.shapeId));
        sb.append(", entityType=").append(String.valueOf((Object)this.entityType));
        sb.append(", otherTypeLabel=").append(String.valueOf(this.otherTypeLabel));
        sb.append(", uniqueKeys=").append(String.valueOf(this.uniqueKeys));
        sb.append(", foreignKeys=").append(String.valueOf(this.foreignKeys));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", dataFormat=").append(String.valueOf((Object)this.dataFormat));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateEntityShapeFromObject)) {
            return false;
        }
        CreateEntityShapeFromObject other = (CreateEntityShapeFromObject)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.externalKey, other.externalKey) && Objects.equals((Object)this.shape, (Object)other.shape) && Objects.equals(this.shapeId, other.shapeId) && Objects.equals((Object)this.entityType, (Object)other.entityType) && Objects.equals(this.otherTypeLabel, other.otherTypeLabel) && Objects.equals(this.uniqueKeys, other.uniqueKeys) && Objects.equals(this.foreignKeys, other.foreignKeys) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals((Object)this.dataFormat, (Object)other.dataFormat) && Objects.equals(this.identifier, other.identifier) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.externalKey == null ? 43 : this.externalKey.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.shapeId == null ? 43 : this.shapeId.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.otherTypeLabel == null ? 43 : this.otherTypeLabel.hashCode());
        result = result * 59 + (this.uniqueKeys == null ? 43 : this.uniqueKeys.hashCode());
        result = result * 59 + (this.foreignKeys == null ? 43 : this.foreignKeys.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.dataFormat == null ? 43 : this.dataFormat.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        return result;
    }

    public static enum EntityType implements BmcEnum
    {
        Table("TABLE"),
        View("VIEW"),
        File("FILE"),
        Sql("SQL"),
        Object("OBJECT");

        private final String value;
        private static Map<String, EntityType> map;

        private EntityType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EntityType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid EntityType: " + key);
        }

        static {
            map = new HashMap<String, EntityType>();
            for (EntityType v : EntityType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="externalKey")
        private String externalKey;
        @JsonProperty(value="shape")
        private Shape shape;
        @JsonProperty(value="shapeId")
        private String shapeId;
        @JsonProperty(value="entityType")
        private EntityType entityType;
        @JsonProperty(value="otherTypeLabel")
        private String otherTypeLabel;
        @JsonProperty(value="uniqueKeys")
        private List<UniqueKey> uniqueKeys;
        @JsonProperty(value="foreignKeys")
        private List<ForeignKey> foreignKeys;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="dataFormat")
        private DataFormat dataFormat;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder externalKey(String externalKey) {
            this.externalKey = externalKey;
            this.__explicitlySet__.add("externalKey");
            return this;
        }

        public Builder shape(Shape shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder shapeId(String shapeId) {
            this.shapeId = shapeId;
            this.__explicitlySet__.add("shapeId");
            return this;
        }

        public Builder entityType(EntityType entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder otherTypeLabel(String otherTypeLabel) {
            this.otherTypeLabel = otherTypeLabel;
            this.__explicitlySet__.add("otherTypeLabel");
            return this;
        }

        public Builder uniqueKeys(List<UniqueKey> uniqueKeys) {
            this.uniqueKeys = uniqueKeys;
            this.__explicitlySet__.add("uniqueKeys");
            return this;
        }

        public Builder foreignKeys(List<ForeignKey> foreignKeys) {
            this.foreignKeys = foreignKeys;
            this.__explicitlySet__.add("foreignKeys");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            this.__explicitlySet__.add("dataFormat");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public CreateEntityShapeFromObject build() {
            CreateEntityShapeFromObject model = new CreateEntityShapeFromObject(this.key, this.parentRef, this.name, this.description, this.externalKey, this.shape, this.shapeId, this.entityType, this.otherTypeLabel, this.uniqueKeys, this.foreignKeys, this.resourceName, this.dataFormat, this.identifier);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateEntityShapeFromObject model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("externalKey")) {
                this.externalKey(model.getExternalKey());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("shapeId")) {
                this.shapeId(model.getShapeId());
            }
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            if (model.wasPropertyExplicitlySet("otherTypeLabel")) {
                this.otherTypeLabel(model.getOtherTypeLabel());
            }
            if (model.wasPropertyExplicitlySet("uniqueKeys")) {
                this.uniqueKeys(model.getUniqueKeys());
            }
            if (model.wasPropertyExplicitlySet("foreignKeys")) {
                this.foreignKeys(model.getForeignKeys());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("dataFormat")) {
                this.dataFormat(model.getDataFormat());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            return this;
        }
    }
}

