/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.AbstractFrequencyDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class CustomFrequencyDetails
extends AbstractFrequencyDetails {
    @JsonProperty(value="customExpression")
    private final String customExpression;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CustomFrequencyDetails(AbstractFrequencyDetails.Frequency frequency, String customExpression) {
        super(frequency);
        this.customExpression = customExpression;
    }

    public String getCustomExpression() {
        return this.customExpression;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CustomFrequencyDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", customExpression=").append(String.valueOf(this.customExpression));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomFrequencyDetails)) {
            return false;
        }
        CustomFrequencyDetails other = (CustomFrequencyDetails)((Object)o);
        return Objects.equals(this.customExpression, other.customExpression) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.customExpression == null ? 43 : this.customExpression.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="frequency")
        private AbstractFrequencyDetails.Frequency frequency;
        @JsonProperty(value="customExpression")
        private String customExpression;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder frequency(AbstractFrequencyDetails.Frequency frequency) {
            this.frequency = frequency;
            this.__explicitlySet__.add("frequency");
            return this;
        }

        public Builder customExpression(String customExpression) {
            this.customExpression = customExpression;
            this.__explicitlySet__.add("customExpression");
            return this;
        }

        public CustomFrequencyDetails build() {
            CustomFrequencyDetails model = new CustomFrequencyDetails(this.frequency, this.customExpression);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CustomFrequencyDetails model) {
            if (model.wasPropertyExplicitlySet("frequency")) {
                this.frequency(model.getFrequency());
            }
            if (model.wasPropertyExplicitlySet("customExpression")) {
                this.customExpression(model.getCustomExpression());
            }
            return this;
        }
    }
}

