/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromAdwc;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromAmazonS3;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromAtp;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromFusionApp;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromHdfs;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromJdbc;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromLake;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromMySQL;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromMySqlHeatWave;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromObjectStorage;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromOracle;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromOracleEbs;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromOraclePeopleSoft;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromOracleSiebel;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromRest;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.TypeSystem;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=DataAssetSummary.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataAssetSummaryFromOracleSiebel.class, name="ORACLE_SIEBEL_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetSummaryFromMySqlHeatWave.class, name="MYSQL_HEATWAVE_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetSummaryFromMySQL.class, name="MYSQL_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetSummaryFromHdfs.class, name="HDFS_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetSummaryFromAmazonS3.class, name="AMAZON_S3_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetSummaryFromOraclePeopleSoft.class, name="ORACLE_PEOPLESOFT_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetSummaryFromObjectStorage.class, name="ORACLE_OBJECT_STORAGE_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetSummaryFromLake.class, name="LAKE_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetSummaryFromRest.class, name="REST_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetSummaryFromOracle.class, name="ORACLE_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetSummaryFromAtp.class, name="ORACLE_ATP_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetSummaryFromAdwc.class, name="ORACLE_ADWC_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetSummaryFromJdbc.class, name="GENERIC_JDBC_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetSummaryFromOracleEbs.class, name="ORACLE_EBS_DATA_ASSET"), @JsonSubTypes.Type(value=DataAssetSummaryFromFusionApp.class, name="FUSION_APP_DATA_ASSET")})
@JsonFilter(value="explicitlySetFilter")
public class DataAssetSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="externalKey")
    private final String externalKey;
    @JsonProperty(value="assetProperties")
    private final Map<String, String> assetProperties;
    @JsonProperty(value="nativeTypeSystem")
    private final TypeSystem nativeTypeSystem;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "name", "description", "objectStatus", "identifier", "externalKey", "assetProperties", "nativeTypeSystem", "objectVersion", "parentRef", "metadata"})
    protected DataAssetSummary(String key, String modelVersion, String name, String description, Integer objectStatus, String identifier, String externalKey, Map<String, String> assetProperties, TypeSystem nativeTypeSystem, Integer objectVersion, ParentReference parentRef, ObjectMetadata metadata) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.name = name;
        this.description = description;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.externalKey = externalKey;
        this.assetProperties = assetProperties;
        this.nativeTypeSystem = nativeTypeSystem;
        this.objectVersion = objectVersion;
        this.parentRef = parentRef;
        this.metadata = metadata;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public Map<String, String> getAssetProperties() {
        return this.assetProperties;
    }

    public TypeSystem getNativeTypeSystem() {
        return this.nativeTypeSystem;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataAssetSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", externalKey=").append(String.valueOf(this.externalKey));
        sb.append(", assetProperties=").append(String.valueOf(this.assetProperties));
        sb.append(", nativeTypeSystem=").append(String.valueOf((Object)this.nativeTypeSystem));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataAssetSummary)) {
            return false;
        }
        DataAssetSummary other = (DataAssetSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.externalKey, other.externalKey) && Objects.equals(this.assetProperties, other.assetProperties) && Objects.equals((Object)this.nativeTypeSystem, (Object)other.nativeTypeSystem) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals((Object)this.metadata, (Object)other.metadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.externalKey == null ? 43 : this.externalKey.hashCode());
        result = result * 59 + (this.assetProperties == null ? 43 : this.assetProperties.hashCode());
        result = result * 59 + (this.nativeTypeSystem == null ? 43 : this.nativeTypeSystem.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ModelType implements BmcEnum
    {
        OracleDataAsset("ORACLE_DATA_ASSET"),
        OracleObjectStorageDataAsset("ORACLE_OBJECT_STORAGE_DATA_ASSET"),
        OracleAtpDataAsset("ORACLE_ATP_DATA_ASSET"),
        OracleAdwcDataAsset("ORACLE_ADWC_DATA_ASSET"),
        MysqlDataAsset("MYSQL_DATA_ASSET"),
        GenericJdbcDataAsset("GENERIC_JDBC_DATA_ASSET"),
        FusionAppDataAsset("FUSION_APP_DATA_ASSET"),
        AmazonS3DataAsset("AMAZON_S3_DATA_ASSET"),
        LakeDataAsset("LAKE_DATA_ASSET"),
        OraclePeoplesoftDataAsset("ORACLE_PEOPLESOFT_DATA_ASSET"),
        OracleSiebelDataAsset("ORACLE_SIEBEL_DATA_ASSET"),
        OracleEbsDataAsset("ORACLE_EBS_DATA_ASSET"),
        HdfsDataAsset("HDFS_DATA_ASSET"),
        MysqlHeatwaveDataAsset("MYSQL_HEATWAVE_DATA_ASSET"),
        RestDataAsset("REST_DATA_ASSET"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

