/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ExportObjectMetadataSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExportRequestSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="objectKeys")
    private final List<String> objectKeys;
    @JsonProperty(value="bucketName")
    private final String bucketName;
    @JsonProperty(value="fileName")
    private final String fileName;
    @JsonProperty(value="objectStorageTenancyId")
    private final String objectStorageTenancyId;
    @JsonProperty(value="objectStorageRegion")
    private final String objectStorageRegion;
    @JsonProperty(value="areReferencesIncluded")
    private final Boolean areReferencesIncluded;
    @JsonProperty(value="isObjectOverwriteEnabled")
    private final Boolean isObjectOverwriteEnabled;
    @JsonProperty(value="filters")
    private final List<String> filters;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="createdBy")
    private final String createdBy;
    @JsonProperty(value="totalExportedObjectCount")
    private final Integer totalExportedObjectCount;
    @JsonProperty(value="timeStartedInMillis")
    private final Long timeStartedInMillis;
    @JsonProperty(value="timeEndedInMillis")
    private final Long timeEndedInMillis;
    @JsonProperty(value="errorMessages")
    private final Map<String, String> errorMessages;
    @JsonProperty(value="exportedItems")
    private final List<ExportObjectMetadataSummary> exportedItems;
    @JsonProperty(value="referencedItems")
    private final String referencedItems;
    @JsonProperty(value="name")
    private final String name;

    @Deprecated
    @ConstructorProperties(value={"key", "objectKeys", "bucketName", "fileName", "objectStorageTenancyId", "objectStorageRegion", "areReferencesIncluded", "isObjectOverwriteEnabled", "filters", "status", "createdBy", "totalExportedObjectCount", "timeStartedInMillis", "timeEndedInMillis", "errorMessages", "exportedItems", "referencedItems", "name"})
    public ExportRequestSummary(String key, List<String> objectKeys, String bucketName, String fileName, String objectStorageTenancyId, String objectStorageRegion, Boolean areReferencesIncluded, Boolean isObjectOverwriteEnabled, List<String> filters, Status status, String createdBy, Integer totalExportedObjectCount, Long timeStartedInMillis, Long timeEndedInMillis, Map<String, String> errorMessages, List<ExportObjectMetadataSummary> exportedItems, String referencedItems, String name) {
        this.key = key;
        this.objectKeys = objectKeys;
        this.bucketName = bucketName;
        this.fileName = fileName;
        this.objectStorageTenancyId = objectStorageTenancyId;
        this.objectStorageRegion = objectStorageRegion;
        this.areReferencesIncluded = areReferencesIncluded;
        this.isObjectOverwriteEnabled = isObjectOverwriteEnabled;
        this.filters = filters;
        this.status = status;
        this.createdBy = createdBy;
        this.totalExportedObjectCount = totalExportedObjectCount;
        this.timeStartedInMillis = timeStartedInMillis;
        this.timeEndedInMillis = timeEndedInMillis;
        this.errorMessages = errorMessages;
        this.exportedItems = exportedItems;
        this.referencedItems = referencedItems;
        this.name = name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public List<String> getObjectKeys() {
        return this.objectKeys;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getObjectStorageTenancyId() {
        return this.objectStorageTenancyId;
    }

    public String getObjectStorageRegion() {
        return this.objectStorageRegion;
    }

    public Boolean getAreReferencesIncluded() {
        return this.areReferencesIncluded;
    }

    public Boolean getIsObjectOverwriteEnabled() {
        return this.isObjectOverwriteEnabled;
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Integer getTotalExportedObjectCount() {
        return this.totalExportedObjectCount;
    }

    public Long getTimeStartedInMillis() {
        return this.timeStartedInMillis;
    }

    public Long getTimeEndedInMillis() {
        return this.timeEndedInMillis;
    }

    public Map<String, String> getErrorMessages() {
        return this.errorMessages;
    }

    public List<ExportObjectMetadataSummary> getExportedItems() {
        return this.exportedItems;
    }

    public String getReferencedItems() {
        return this.referencedItems;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExportRequestSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", objectKeys=").append(String.valueOf(this.objectKeys));
        sb.append(", bucketName=").append(String.valueOf(this.bucketName));
        sb.append(", fileName=").append(String.valueOf(this.fileName));
        sb.append(", objectStorageTenancyId=").append(String.valueOf(this.objectStorageTenancyId));
        sb.append(", objectStorageRegion=").append(String.valueOf(this.objectStorageRegion));
        sb.append(", areReferencesIncluded=").append(String.valueOf(this.areReferencesIncluded));
        sb.append(", isObjectOverwriteEnabled=").append(String.valueOf(this.isObjectOverwriteEnabled));
        sb.append(", filters=").append(String.valueOf(this.filters));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", createdBy=").append(String.valueOf(this.createdBy));
        sb.append(", totalExportedObjectCount=").append(String.valueOf(this.totalExportedObjectCount));
        sb.append(", timeStartedInMillis=").append(String.valueOf(this.timeStartedInMillis));
        sb.append(", timeEndedInMillis=").append(String.valueOf(this.timeEndedInMillis));
        sb.append(", errorMessages=").append(String.valueOf(this.errorMessages));
        sb.append(", exportedItems=").append(String.valueOf(this.exportedItems));
        sb.append(", referencedItems=").append(String.valueOf(this.referencedItems));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportRequestSummary)) {
            return false;
        }
        ExportRequestSummary other = (ExportRequestSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.objectKeys, other.objectKeys) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.fileName, other.fileName) && Objects.equals(this.objectStorageTenancyId, other.objectStorageTenancyId) && Objects.equals(this.objectStorageRegion, other.objectStorageRegion) && Objects.equals(this.areReferencesIncluded, other.areReferencesIncluded) && Objects.equals(this.isObjectOverwriteEnabled, other.isObjectOverwriteEnabled) && Objects.equals(this.filters, other.filters) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.createdBy, other.createdBy) && Objects.equals(this.totalExportedObjectCount, other.totalExportedObjectCount) && Objects.equals(this.timeStartedInMillis, other.timeStartedInMillis) && Objects.equals(this.timeEndedInMillis, other.timeEndedInMillis) && Objects.equals(this.errorMessages, other.errorMessages) && Objects.equals(this.exportedItems, other.exportedItems) && Objects.equals(this.referencedItems, other.referencedItems) && Objects.equals(this.name, other.name) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.objectKeys == null ? 43 : this.objectKeys.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.fileName == null ? 43 : this.fileName.hashCode());
        result = result * 59 + (this.objectStorageTenancyId == null ? 43 : this.objectStorageTenancyId.hashCode());
        result = result * 59 + (this.objectStorageRegion == null ? 43 : this.objectStorageRegion.hashCode());
        result = result * 59 + (this.areReferencesIncluded == null ? 43 : this.areReferencesIncluded.hashCode());
        result = result * 59 + (this.isObjectOverwriteEnabled == null ? 43 : this.isObjectOverwriteEnabled.hashCode());
        result = result * 59 + (this.filters == null ? 43 : this.filters.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.createdBy == null ? 43 : this.createdBy.hashCode());
        result = result * 59 + (this.totalExportedObjectCount == null ? 43 : this.totalExportedObjectCount.hashCode());
        result = result * 59 + (this.timeStartedInMillis == null ? 43 : this.timeStartedInMillis.hashCode());
        result = result * 59 + (this.timeEndedInMillis == null ? 43 : this.timeEndedInMillis.hashCode());
        result = result * 59 + (this.errorMessages == null ? 43 : this.errorMessages.hashCode());
        result = result * 59 + (this.exportedItems == null ? 43 : this.exportedItems.hashCode());
        result = result * 59 + (this.referencedItems == null ? 43 : this.referencedItems.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Successful("SUCCESSFUL"),
        Failed("FAILED"),
        InProgress("IN_PROGRESS"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Queued("QUEUED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="objectKeys")
        private List<String> objectKeys;
        @JsonProperty(value="bucketName")
        private String bucketName;
        @JsonProperty(value="fileName")
        private String fileName;
        @JsonProperty(value="objectStorageTenancyId")
        private String objectStorageTenancyId;
        @JsonProperty(value="objectStorageRegion")
        private String objectStorageRegion;
        @JsonProperty(value="areReferencesIncluded")
        private Boolean areReferencesIncluded;
        @JsonProperty(value="isObjectOverwriteEnabled")
        private Boolean isObjectOverwriteEnabled;
        @JsonProperty(value="filters")
        private List<String> filters;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="createdBy")
        private String createdBy;
        @JsonProperty(value="totalExportedObjectCount")
        private Integer totalExportedObjectCount;
        @JsonProperty(value="timeStartedInMillis")
        private Long timeStartedInMillis;
        @JsonProperty(value="timeEndedInMillis")
        private Long timeEndedInMillis;
        @JsonProperty(value="errorMessages")
        private Map<String, String> errorMessages;
        @JsonProperty(value="exportedItems")
        private List<ExportObjectMetadataSummary> exportedItems;
        @JsonProperty(value="referencedItems")
        private String referencedItems;
        @JsonProperty(value="name")
        private String name;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder objectKeys(List<String> objectKeys) {
            this.objectKeys = objectKeys;
            this.__explicitlySet__.add("objectKeys");
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            this.__explicitlySet__.add("bucketName");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.__explicitlySet__.add("fileName");
            return this;
        }

        public Builder objectStorageTenancyId(String objectStorageTenancyId) {
            this.objectStorageTenancyId = objectStorageTenancyId;
            this.__explicitlySet__.add("objectStorageTenancyId");
            return this;
        }

        public Builder objectStorageRegion(String objectStorageRegion) {
            this.objectStorageRegion = objectStorageRegion;
            this.__explicitlySet__.add("objectStorageRegion");
            return this;
        }

        public Builder areReferencesIncluded(Boolean areReferencesIncluded) {
            this.areReferencesIncluded = areReferencesIncluded;
            this.__explicitlySet__.add("areReferencesIncluded");
            return this;
        }

        public Builder isObjectOverwriteEnabled(Boolean isObjectOverwriteEnabled) {
            this.isObjectOverwriteEnabled = isObjectOverwriteEnabled;
            this.__explicitlySet__.add("isObjectOverwriteEnabled");
            return this;
        }

        public Builder filters(List<String> filters) {
            this.filters = filters;
            this.__explicitlySet__.add("filters");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.__explicitlySet__.add("createdBy");
            return this;
        }

        public Builder totalExportedObjectCount(Integer totalExportedObjectCount) {
            this.totalExportedObjectCount = totalExportedObjectCount;
            this.__explicitlySet__.add("totalExportedObjectCount");
            return this;
        }

        public Builder timeStartedInMillis(Long timeStartedInMillis) {
            this.timeStartedInMillis = timeStartedInMillis;
            this.__explicitlySet__.add("timeStartedInMillis");
            return this;
        }

        public Builder timeEndedInMillis(Long timeEndedInMillis) {
            this.timeEndedInMillis = timeEndedInMillis;
            this.__explicitlySet__.add("timeEndedInMillis");
            return this;
        }

        public Builder errorMessages(Map<String, String> errorMessages) {
            this.errorMessages = errorMessages;
            this.__explicitlySet__.add("errorMessages");
            return this;
        }

        public Builder exportedItems(List<ExportObjectMetadataSummary> exportedItems) {
            this.exportedItems = exportedItems;
            this.__explicitlySet__.add("exportedItems");
            return this;
        }

        public Builder referencedItems(String referencedItems) {
            this.referencedItems = referencedItems;
            this.__explicitlySet__.add("referencedItems");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public ExportRequestSummary build() {
            ExportRequestSummary model = new ExportRequestSummary(this.key, this.objectKeys, this.bucketName, this.fileName, this.objectStorageTenancyId, this.objectStorageRegion, this.areReferencesIncluded, this.isObjectOverwriteEnabled, this.filters, this.status, this.createdBy, this.totalExportedObjectCount, this.timeStartedInMillis, this.timeEndedInMillis, this.errorMessages, this.exportedItems, this.referencedItems, this.name);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExportRequestSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("objectKeys")) {
                this.objectKeys(model.getObjectKeys());
            }
            if (model.wasPropertyExplicitlySet("bucketName")) {
                this.bucketName(model.getBucketName());
            }
            if (model.wasPropertyExplicitlySet("fileName")) {
                this.fileName(model.getFileName());
            }
            if (model.wasPropertyExplicitlySet("objectStorageTenancyId")) {
                this.objectStorageTenancyId(model.getObjectStorageTenancyId());
            }
            if (model.wasPropertyExplicitlySet("objectStorageRegion")) {
                this.objectStorageRegion(model.getObjectStorageRegion());
            }
            if (model.wasPropertyExplicitlySet("areReferencesIncluded")) {
                this.areReferencesIncluded(model.getAreReferencesIncluded());
            }
            if (model.wasPropertyExplicitlySet("isObjectOverwriteEnabled")) {
                this.isObjectOverwriteEnabled(model.getIsObjectOverwriteEnabled());
            }
            if (model.wasPropertyExplicitlySet("filters")) {
                this.filters(model.getFilters());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("createdBy")) {
                this.createdBy(model.getCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("totalExportedObjectCount")) {
                this.totalExportedObjectCount(model.getTotalExportedObjectCount());
            }
            if (model.wasPropertyExplicitlySet("timeStartedInMillis")) {
                this.timeStartedInMillis(model.getTimeStartedInMillis());
            }
            if (model.wasPropertyExplicitlySet("timeEndedInMillis")) {
                this.timeEndedInMillis(model.getTimeEndedInMillis());
            }
            if (model.wasPropertyExplicitlySet("errorMessages")) {
                this.errorMessages(model.getErrorMessages());
            }
            if (model.wasPropertyExplicitlySet("exportedItems")) {
                this.exportedItems(model.getExportedItems());
            }
            if (model.wasPropertyExplicitlySet("referencedItems")) {
                this.referencedItems(model.getReferencedItems());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            return this;
        }
    }
}

