/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.DynamicTypeHandler;
import com.oracle.bmc.dataintegration.model.ParentReference;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class FlattenTypeHandler
extends DynamicTypeHandler {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="scope")
    private final String scope;
    @JsonProperty(value="flattenDetails")
    private final String flattenDetails;
    @JsonProperty(value="configValues")
    private final ConfigValues configValues;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public FlattenTypeHandler(String key, String modelVersion, ParentReference parentRef, String scope, String flattenDetails, ConfigValues configValues, Integer objectStatus) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.scope = scope;
        this.flattenDetails = flattenDetails;
        this.configValues = configValues;
        this.objectStatus = objectStatus;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFlattenDetails() {
        return this.flattenDetails;
    }

    public ConfigValues getConfigValues() {
        return this.configValues;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FlattenTypeHandler(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", scope=").append(String.valueOf(this.scope));
        sb.append(", flattenDetails=").append(String.valueOf(this.flattenDetails));
        sb.append(", configValues=").append(String.valueOf((Object)this.configValues));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlattenTypeHandler)) {
            return false;
        }
        FlattenTypeHandler other = (FlattenTypeHandler)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.scope, other.scope) && Objects.equals(this.flattenDetails, other.flattenDetails) && Objects.equals((Object)this.configValues, (Object)other.configValues) && Objects.equals(this.objectStatus, other.objectStatus) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.flattenDetails == null ? 43 : this.flattenDetails.hashCode());
        result = result * 59 + (this.configValues == null ? 43 : this.configValues.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="scope")
        private String scope;
        @JsonProperty(value="flattenDetails")
        private String flattenDetails;
        @JsonProperty(value="configValues")
        private ConfigValues configValues;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            this.__explicitlySet__.add("scope");
            return this;
        }

        public Builder flattenDetails(String flattenDetails) {
            this.flattenDetails = flattenDetails;
            this.__explicitlySet__.add("flattenDetails");
            return this;
        }

        public Builder configValues(ConfigValues configValues) {
            this.configValues = configValues;
            this.__explicitlySet__.add("configValues");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public FlattenTypeHandler build() {
            FlattenTypeHandler model = new FlattenTypeHandler(this.key, this.modelVersion, this.parentRef, this.scope, this.flattenDetails, this.configValues, this.objectStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FlattenTypeHandler model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("scope")) {
                this.scope(model.getScope());
            }
            if (model.wasPropertyExplicitlySet("flattenDetails")) {
                this.flattenDetails(model.getFlattenDetails());
            }
            if (model.wasPropertyExplicitlySet("configValues")) {
                this.configValues(model.getConfigValues());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            return this;
        }
    }
}

