/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.ProjectionRule;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class GroupedNamePatternRule
extends ProjectionRule {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="isSkipRemainingRulesOnMatch")
    private final Boolean isSkipRemainingRulesOnMatch;
    @JsonProperty(value="scope")
    private final Object scope;
    @JsonProperty(value="isCascade")
    private final Boolean isCascade;
    @JsonProperty(value="matchingStrategy")
    private final MatchingStrategy matchingStrategy;
    @JsonProperty(value="isCaseSensitive")
    private final Boolean isCaseSensitive;
    @JsonProperty(value="ruleType")
    private final RuleType ruleType;
    @JsonProperty(value="pattern")
    private final String pattern;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public GroupedNamePatternRule(String key, String modelVersion, ParentReference parentRef, Boolean isJavaRegexSyntax, ConfigValues configValues, Integer objectStatus, String description, String name, Boolean isSkipRemainingRulesOnMatch, Object scope, Boolean isCascade, MatchingStrategy matchingStrategy, Boolean isCaseSensitive, RuleType ruleType, String pattern) {
        super(key, modelVersion, parentRef, isJavaRegexSyntax, configValues, objectStatus, description);
        this.name = name;
        this.isSkipRemainingRulesOnMatch = isSkipRemainingRulesOnMatch;
        this.scope = scope;
        this.isCascade = isCascade;
        this.matchingStrategy = matchingStrategy;
        this.isCaseSensitive = isCaseSensitive;
        this.ruleType = ruleType;
        this.pattern = pattern;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIsSkipRemainingRulesOnMatch() {
        return this.isSkipRemainingRulesOnMatch;
    }

    public Object getScope() {
        return this.scope;
    }

    public Boolean getIsCascade() {
        return this.isCascade;
    }

    public MatchingStrategy getMatchingStrategy() {
        return this.matchingStrategy;
    }

    public Boolean getIsCaseSensitive() {
        return this.isCaseSensitive;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GroupedNamePatternRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", isSkipRemainingRulesOnMatch=").append(String.valueOf(this.isSkipRemainingRulesOnMatch));
        sb.append(", scope=").append(String.valueOf(this.scope));
        sb.append(", isCascade=").append(String.valueOf(this.isCascade));
        sb.append(", matchingStrategy=").append(String.valueOf((Object)this.matchingStrategy));
        sb.append(", isCaseSensitive=").append(String.valueOf(this.isCaseSensitive));
        sb.append(", ruleType=").append(String.valueOf((Object)this.ruleType));
        sb.append(", pattern=").append(String.valueOf(this.pattern));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupedNamePatternRule)) {
            return false;
        }
        GroupedNamePatternRule other = (GroupedNamePatternRule)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.isSkipRemainingRulesOnMatch, other.isSkipRemainingRulesOnMatch) && Objects.equals(this.scope, other.scope) && Objects.equals(this.isCascade, other.isCascade) && Objects.equals((Object)this.matchingStrategy, (Object)other.matchingStrategy) && Objects.equals(this.isCaseSensitive, other.isCaseSensitive) && Objects.equals((Object)this.ruleType, (Object)other.ruleType) && Objects.equals(this.pattern, other.pattern) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.isSkipRemainingRulesOnMatch == null ? 43 : this.isSkipRemainingRulesOnMatch.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.isCascade == null ? 43 : this.isCascade.hashCode());
        result = result * 59 + (this.matchingStrategy == null ? 43 : this.matchingStrategy.hashCode());
        result = result * 59 + (this.isCaseSensitive == null ? 43 : this.isCaseSensitive.hashCode());
        result = result * 59 + (this.ruleType == null ? 43 : this.ruleType.hashCode());
        result = result * 59 + (this.pattern == null ? 43 : this.pattern.hashCode());
        return result;
    }

    public static enum RuleType implements BmcEnum
    {
        Include("INCLUDE"),
        Exclude("EXCLUDE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RuleType> map;

        private RuleType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RuleType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RuleType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RuleType.class);
            map = new HashMap<String, RuleType>();
            for (RuleType v : RuleType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MatchingStrategy implements BmcEnum
    {
        NameOrTags("NAME_OR_TAGS"),
        TagsOnly("TAGS_ONLY"),
        NameOnly("NAME_ONLY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MatchingStrategy> map;

        private MatchingStrategy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MatchingStrategy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MatchingStrategy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MatchingStrategy.class);
            map = new HashMap<String, MatchingStrategy>();
            for (MatchingStrategy v : MatchingStrategy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="isJavaRegexSyntax")
        private Boolean isJavaRegexSyntax;
        @JsonProperty(value="configValues")
        private ConfigValues configValues;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="isSkipRemainingRulesOnMatch")
        private Boolean isSkipRemainingRulesOnMatch;
        @JsonProperty(value="scope")
        private Object scope;
        @JsonProperty(value="isCascade")
        private Boolean isCascade;
        @JsonProperty(value="matchingStrategy")
        private MatchingStrategy matchingStrategy;
        @JsonProperty(value="isCaseSensitive")
        private Boolean isCaseSensitive;
        @JsonProperty(value="ruleType")
        private RuleType ruleType;
        @JsonProperty(value="pattern")
        private String pattern;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder isJavaRegexSyntax(Boolean isJavaRegexSyntax) {
            this.isJavaRegexSyntax = isJavaRegexSyntax;
            this.__explicitlySet__.add("isJavaRegexSyntax");
            return this;
        }

        public Builder configValues(ConfigValues configValues) {
            this.configValues = configValues;
            this.__explicitlySet__.add("configValues");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder isSkipRemainingRulesOnMatch(Boolean isSkipRemainingRulesOnMatch) {
            this.isSkipRemainingRulesOnMatch = isSkipRemainingRulesOnMatch;
            this.__explicitlySet__.add("isSkipRemainingRulesOnMatch");
            return this;
        }

        public Builder scope(Object scope) {
            this.scope = scope;
            this.__explicitlySet__.add("scope");
            return this;
        }

        public Builder isCascade(Boolean isCascade) {
            this.isCascade = isCascade;
            this.__explicitlySet__.add("isCascade");
            return this;
        }

        public Builder matchingStrategy(MatchingStrategy matchingStrategy) {
            this.matchingStrategy = matchingStrategy;
            this.__explicitlySet__.add("matchingStrategy");
            return this;
        }

        public Builder isCaseSensitive(Boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
            this.__explicitlySet__.add("isCaseSensitive");
            return this;
        }

        public Builder ruleType(RuleType ruleType) {
            this.ruleType = ruleType;
            this.__explicitlySet__.add("ruleType");
            return this;
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            this.__explicitlySet__.add("pattern");
            return this;
        }

        public GroupedNamePatternRule build() {
            GroupedNamePatternRule model = new GroupedNamePatternRule(this.key, this.modelVersion, this.parentRef, this.isJavaRegexSyntax, this.configValues, this.objectStatus, this.description, this.name, this.isSkipRemainingRulesOnMatch, this.scope, this.isCascade, this.matchingStrategy, this.isCaseSensitive, this.ruleType, this.pattern);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GroupedNamePatternRule model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("isJavaRegexSyntax")) {
                this.isJavaRegexSyntax(model.getIsJavaRegexSyntax());
            }
            if (model.wasPropertyExplicitlySet("configValues")) {
                this.configValues(model.getConfigValues());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("isSkipRemainingRulesOnMatch")) {
                this.isSkipRemainingRulesOnMatch(model.getIsSkipRemainingRulesOnMatch());
            }
            if (model.wasPropertyExplicitlySet("scope")) {
                this.scope(model.getScope());
            }
            if (model.wasPropertyExplicitlySet("isCascade")) {
                this.isCascade(model.getIsCascade());
            }
            if (model.wasPropertyExplicitlySet("matchingStrategy")) {
                this.matchingStrategy(model.getMatchingStrategy());
            }
            if (model.wasPropertyExplicitlySet("isCaseSensitive")) {
                this.isCaseSensitive(model.getIsCaseSensitive());
            }
            if (model.wasPropertyExplicitlySet("ruleType")) {
                this.ruleType(model.getRuleType());
            }
            if (model.wasPropertyExplicitlySet("pattern")) {
                this.pattern(model.getPattern());
            }
            return this;
        }
    }
}

