/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IncrementalDataEntityClause
extends ExplicitlySetBmcModel {
    @JsonProperty(value="incrementalDataEntityName")
    private final String incrementalDataEntityName;
    @JsonProperty(value="incrementalDataEntityValue")
    private final Map<String, String> incrementalDataEntityValue;
    @JsonProperty(value="incrementalComparator")
    private final IncrementalComparator incrementalComparator;

    @Deprecated
    @ConstructorProperties(value={"incrementalDataEntityName", "incrementalDataEntityValue", "incrementalComparator"})
    public IncrementalDataEntityClause(String incrementalDataEntityName, Map<String, String> incrementalDataEntityValue, IncrementalComparator incrementalComparator) {
        this.incrementalDataEntityName = incrementalDataEntityName;
        this.incrementalDataEntityValue = incrementalDataEntityValue;
        this.incrementalComparator = incrementalComparator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getIncrementalDataEntityName() {
        return this.incrementalDataEntityName;
    }

    public Map<String, String> getIncrementalDataEntityValue() {
        return this.incrementalDataEntityValue;
    }

    public IncrementalComparator getIncrementalComparator() {
        return this.incrementalComparator;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IncrementalDataEntityClause(");
        sb.append("super=").append(super.toString());
        sb.append("incrementalDataEntityName=").append(String.valueOf(this.incrementalDataEntityName));
        sb.append(", incrementalDataEntityValue=").append(String.valueOf(this.incrementalDataEntityValue));
        sb.append(", incrementalComparator=").append(String.valueOf((Object)this.incrementalComparator));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IncrementalDataEntityClause)) {
            return false;
        }
        IncrementalDataEntityClause other = (IncrementalDataEntityClause)((Object)o);
        return Objects.equals(this.incrementalDataEntityName, other.incrementalDataEntityName) && Objects.equals(this.incrementalDataEntityValue, other.incrementalDataEntityValue) && Objects.equals((Object)this.incrementalComparator, (Object)other.incrementalComparator) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.incrementalDataEntityName == null ? 43 : this.incrementalDataEntityName.hashCode());
        result = result * 59 + (this.incrementalDataEntityValue == null ? 43 : this.incrementalDataEntityValue.hashCode());
        result = result * 59 + (this.incrementalComparator == null ? 43 : this.incrementalComparator.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum IncrementalComparator implements BmcEnum
    {
        Lessthan("LESSTHAN"),
        Greaterthan("GREATERTHAN"),
        Equals("EQUALS"),
        Lessthanequals("LESSTHANEQUALS"),
        Greaterthanequals("GREATERTHANEQUALS"),
        Startswith("STARTSWITH"),
        Contains("CONTAINS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, IncrementalComparator> map;

        private IncrementalComparator(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IncrementalComparator create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'IncrementalComparator', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(IncrementalComparator.class);
            map = new HashMap<String, IncrementalComparator>();
            for (IncrementalComparator v : IncrementalComparator.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="incrementalDataEntityName")
        private String incrementalDataEntityName;
        @JsonProperty(value="incrementalDataEntityValue")
        private Map<String, String> incrementalDataEntityValue;
        @JsonProperty(value="incrementalComparator")
        private IncrementalComparator incrementalComparator;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder incrementalDataEntityName(String incrementalDataEntityName) {
            this.incrementalDataEntityName = incrementalDataEntityName;
            this.__explicitlySet__.add("incrementalDataEntityName");
            return this;
        }

        public Builder incrementalDataEntityValue(Map<String, String> incrementalDataEntityValue) {
            this.incrementalDataEntityValue = incrementalDataEntityValue;
            this.__explicitlySet__.add("incrementalDataEntityValue");
            return this;
        }

        public Builder incrementalComparator(IncrementalComparator incrementalComparator) {
            this.incrementalComparator = incrementalComparator;
            this.__explicitlySet__.add("incrementalComparator");
            return this;
        }

        public IncrementalDataEntityClause build() {
            IncrementalDataEntityClause model = new IncrementalDataEntityClause(this.incrementalDataEntityName, this.incrementalDataEntityValue, this.incrementalComparator);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IncrementalDataEntityClause model) {
            if (model.wasPropertyExplicitlySet("incrementalDataEntityName")) {
                this.incrementalDataEntityName(model.getIncrementalDataEntityName());
            }
            if (model.wasPropertyExplicitlySet("incrementalDataEntityValue")) {
                this.incrementalDataEntityValue(model.getIncrementalDataEntityValue());
            }
            if (model.wasPropertyExplicitlySet("incrementalComparator")) {
                this.incrementalComparator(model.getIncrementalComparator());
            }
            return this;
        }
    }
}

