/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NativeShapeField
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="type")
    private final Object type;
    @JsonProperty(value="configValues")
    private final ConfigValues configValues;
    @JsonProperty(value="position")
    private final Integer position;
    @JsonProperty(value="defaultValueString")
    private final String defaultValueString;
    @JsonProperty(value="isMandatory")
    private final Boolean isMandatory;

    @Deprecated
    @ConstructorProperties(value={"name", "modelType", "type", "configValues", "position", "defaultValueString", "isMandatory"})
    public NativeShapeField(String name, String modelType, Object type, ConfigValues configValues, Integer position, String defaultValueString, Boolean isMandatory) {
        this.name = name;
        this.modelType = modelType;
        this.type = type;
        this.configValues = configValues;
        this.position = position;
        this.defaultValueString = defaultValueString;
        this.isMandatory = isMandatory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getModelType() {
        return this.modelType;
    }

    public Object getType() {
        return this.type;
    }

    public ConfigValues getConfigValues() {
        return this.configValues;
    }

    public Integer getPosition() {
        return this.position;
    }

    public String getDefaultValueString() {
        return this.defaultValueString;
    }

    public Boolean getIsMandatory() {
        return this.isMandatory;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NativeShapeField(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", configValues=").append(String.valueOf((Object)this.configValues));
        sb.append(", position=").append(String.valueOf(this.position));
        sb.append(", defaultValueString=").append(String.valueOf(this.defaultValueString));
        sb.append(", isMandatory=").append(String.valueOf(this.isMandatory));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NativeShapeField)) {
            return false;
        }
        NativeShapeField other = (NativeShapeField)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.modelType, other.modelType) && Objects.equals(this.type, other.type) && Objects.equals((Object)this.configValues, (Object)other.configValues) && Objects.equals(this.position, other.position) && Objects.equals(this.defaultValueString, other.defaultValueString) && Objects.equals(this.isMandatory, other.isMandatory) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.configValues == null ? 43 : this.configValues.hashCode());
        result = result * 59 + (this.position == null ? 43 : this.position.hashCode());
        result = result * 59 + (this.defaultValueString == null ? 43 : this.defaultValueString.hashCode());
        result = result * 59 + (this.isMandatory == null ? 43 : this.isMandatory.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="type")
        private Object type;
        @JsonProperty(value="configValues")
        private ConfigValues configValues;
        @JsonProperty(value="position")
        private Integer position;
        @JsonProperty(value="defaultValueString")
        private String defaultValueString;
        @JsonProperty(value="isMandatory")
        private Boolean isMandatory;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder type(Object type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder configValues(ConfigValues configValues) {
            this.configValues = configValues;
            this.__explicitlySet__.add("configValues");
            return this;
        }

        public Builder position(Integer position) {
            this.position = position;
            this.__explicitlySet__.add("position");
            return this;
        }

        public Builder defaultValueString(String defaultValueString) {
            this.defaultValueString = defaultValueString;
            this.__explicitlySet__.add("defaultValueString");
            return this;
        }

        public Builder isMandatory(Boolean isMandatory) {
            this.isMandatory = isMandatory;
            this.__explicitlySet__.add("isMandatory");
            return this;
        }

        public NativeShapeField build() {
            NativeShapeField model = new NativeShapeField(this.name, this.modelType, this.type, this.configValues, this.position, this.defaultValueString, this.isMandatory);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NativeShapeField model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("configValues")) {
                this.configValues(model.getConfigValues());
            }
            if (model.wasPropertyExplicitlySet("position")) {
                this.position(model.getPosition());
            }
            if (model.wasPropertyExplicitlySet("defaultValueString")) {
                this.defaultValueString(model.getDefaultValueString());
            }
            if (model.wasPropertyExplicitlySet("isMandatory")) {
                this.isMandatory(model.getIsMandatory());
            }
            return this;
        }
    }
}

