/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.TypedObject;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class Parameter
extends TypedObject {
    @JsonProperty(value="type")
    private final Object type;
    @JsonProperty(value="defaultValue")
    private final Object defaultValue;
    @JsonProperty(value="rootObjectDefaultValue")
    private final Object rootObjectDefaultValue;
    @JsonProperty(value="isInput")
    private final Boolean isInput;
    @JsonProperty(value="isOutput")
    private final Boolean isOutput;
    @JsonProperty(value="outputAggregationType")
    private final OutputAggregationType outputAggregationType;
    @JsonProperty(value="typeName")
    private final String typeName;
    @JsonProperty(value="usedFor")
    private final String usedFor;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public Parameter(String key, String modelVersion, ParentReference parentRef, ConfigValues configValues, Integer objectStatus, String name, String description, Object type, Object defaultValue, Object rootObjectDefaultValue, Boolean isInput, Boolean isOutput, OutputAggregationType outputAggregationType, String typeName, String usedFor) {
        super(key, modelVersion, parentRef, configValues, objectStatus, name, description);
        this.type = type;
        this.defaultValue = defaultValue;
        this.rootObjectDefaultValue = rootObjectDefaultValue;
        this.isInput = isInput;
        this.isOutput = isOutput;
        this.outputAggregationType = outputAggregationType;
        this.typeName = typeName;
        this.usedFor = usedFor;
    }

    public Object getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object getRootObjectDefaultValue() {
        return this.rootObjectDefaultValue;
    }

    public Boolean getIsInput() {
        return this.isInput;
    }

    public Boolean getIsOutput() {
        return this.isOutput;
    }

    public OutputAggregationType getOutputAggregationType() {
        return this.outputAggregationType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getUsedFor() {
        return this.usedFor;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Parameter(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", defaultValue=").append(String.valueOf(this.defaultValue));
        sb.append(", rootObjectDefaultValue=").append(String.valueOf(this.rootObjectDefaultValue));
        sb.append(", isInput=").append(String.valueOf(this.isInput));
        sb.append(", isOutput=").append(String.valueOf(this.isOutput));
        sb.append(", outputAggregationType=").append(String.valueOf((Object)this.outputAggregationType));
        sb.append(", typeName=").append(String.valueOf(this.typeName));
        sb.append(", usedFor=").append(String.valueOf(this.usedFor));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)((Object)o);
        return Objects.equals(this.type, other.type) && Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals(this.rootObjectDefaultValue, other.rootObjectDefaultValue) && Objects.equals(this.isInput, other.isInput) && Objects.equals(this.isOutput, other.isOutput) && Objects.equals((Object)this.outputAggregationType, (Object)other.outputAggregationType) && Objects.equals(this.typeName, other.typeName) && Objects.equals(this.usedFor, other.usedFor) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.defaultValue == null ? 43 : this.defaultValue.hashCode());
        result = result * 59 + (this.rootObjectDefaultValue == null ? 43 : this.rootObjectDefaultValue.hashCode());
        result = result * 59 + (this.isInput == null ? 43 : this.isInput.hashCode());
        result = result * 59 + (this.isOutput == null ? 43 : this.isOutput.hashCode());
        result = result * 59 + (this.outputAggregationType == null ? 43 : this.outputAggregationType.hashCode());
        result = result * 59 + (this.typeName == null ? 43 : this.typeName.hashCode());
        result = result * 59 + (this.usedFor == null ? 43 : this.usedFor.hashCode());
        return result;
    }

    public static enum OutputAggregationType implements BmcEnum
    {
        Min("MIN"),
        Max("MAX"),
        Count("COUNT"),
        Sum("SUM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OutputAggregationType> map;

        private OutputAggregationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OutputAggregationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OutputAggregationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OutputAggregationType.class);
            map = new HashMap<String, OutputAggregationType>();
            for (OutputAggregationType v : OutputAggregationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="configValues")
        private ConfigValues configValues;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="type")
        private Object type;
        @JsonProperty(value="defaultValue")
        private Object defaultValue;
        @JsonProperty(value="rootObjectDefaultValue")
        private Object rootObjectDefaultValue;
        @JsonProperty(value="isInput")
        private Boolean isInput;
        @JsonProperty(value="isOutput")
        private Boolean isOutput;
        @JsonProperty(value="outputAggregationType")
        private OutputAggregationType outputAggregationType;
        @JsonProperty(value="typeName")
        private String typeName;
        @JsonProperty(value="usedFor")
        private String usedFor;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder configValues(ConfigValues configValues) {
            this.configValues = configValues;
            this.__explicitlySet__.add("configValues");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder type(Object type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            this.__explicitlySet__.add("defaultValue");
            return this;
        }

        public Builder rootObjectDefaultValue(Object rootObjectDefaultValue) {
            this.rootObjectDefaultValue = rootObjectDefaultValue;
            this.__explicitlySet__.add("rootObjectDefaultValue");
            return this;
        }

        public Builder isInput(Boolean isInput) {
            this.isInput = isInput;
            this.__explicitlySet__.add("isInput");
            return this;
        }

        public Builder isOutput(Boolean isOutput) {
            this.isOutput = isOutput;
            this.__explicitlySet__.add("isOutput");
            return this;
        }

        public Builder outputAggregationType(OutputAggregationType outputAggregationType) {
            this.outputAggregationType = outputAggregationType;
            this.__explicitlySet__.add("outputAggregationType");
            return this;
        }

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            this.__explicitlySet__.add("typeName");
            return this;
        }

        public Builder usedFor(String usedFor) {
            this.usedFor = usedFor;
            this.__explicitlySet__.add("usedFor");
            return this;
        }

        public Parameter build() {
            Parameter model = new Parameter(this.key, this.modelVersion, this.parentRef, this.configValues, this.objectStatus, this.name, this.description, this.type, this.defaultValue, this.rootObjectDefaultValue, this.isInput, this.isOutput, this.outputAggregationType, this.typeName, this.usedFor);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Parameter model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("configValues")) {
                this.configValues(model.getConfigValues());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("defaultValue")) {
                this.defaultValue(model.getDefaultValue());
            }
            if (model.wasPropertyExplicitlySet("rootObjectDefaultValue")) {
                this.rootObjectDefaultValue(model.getRootObjectDefaultValue());
            }
            if (model.wasPropertyExplicitlySet("isInput")) {
                this.isInput(model.getIsInput());
            }
            if (model.wasPropertyExplicitlySet("isOutput")) {
                this.isOutput(model.getIsOutput());
            }
            if (model.wasPropertyExplicitlySet("outputAggregationType")) {
                this.outputAggregationType(model.getOutputAggregationType());
            }
            if (model.wasPropertyExplicitlySet("typeName")) {
                this.typeName(model.getTypeName());
            }
            if (model.wasPropertyExplicitlySet("usedFor")) {
                this.usedFor(model.getUsedFor());
            }
            return this;
        }
    }
}

