/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.BaseType;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.ConfiguredType;
import com.oracle.bmc.dataintegration.model.Expression;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.TypedObject;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class PivotField
extends TypedObject {
    @JsonProperty(value="expr")
    private final Expression expr;
    @JsonProperty(value="useType")
    private final ConfiguredType useType;
    @JsonProperty(value="type")
    private final BaseType type;
    @JsonProperty(value="columnNamePattern")
    private final String columnNamePattern;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PivotField(String key, String modelVersion, ParentReference parentRef, ConfigValues configValues, Integer objectStatus, String name, String description, Expression expr, ConfiguredType useType, BaseType type, String columnNamePattern) {
        super(key, modelVersion, parentRef, configValues, objectStatus, name, description);
        this.expr = expr;
        this.useType = useType;
        this.type = type;
        this.columnNamePattern = columnNamePattern;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public ConfiguredType getUseType() {
        return this.useType;
    }

    public BaseType getType() {
        return this.type;
    }

    public String getColumnNamePattern() {
        return this.columnNamePattern;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PivotField(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", expr=").append(String.valueOf((Object)this.expr));
        sb.append(", useType=").append(String.valueOf((Object)this.useType));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", columnNamePattern=").append(String.valueOf(this.columnNamePattern));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PivotField)) {
            return false;
        }
        PivotField other = (PivotField)((Object)o);
        return Objects.equals((Object)this.expr, (Object)other.expr) && Objects.equals((Object)this.useType, (Object)other.useType) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.columnNamePattern, other.columnNamePattern) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.expr == null ? 43 : this.expr.hashCode());
        result = result * 59 + (this.useType == null ? 43 : this.useType.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.columnNamePattern == null ? 43 : this.columnNamePattern.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="configValues")
        private ConfigValues configValues;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="expr")
        private Expression expr;
        @JsonProperty(value="useType")
        private ConfiguredType useType;
        @JsonProperty(value="type")
        private BaseType type;
        @JsonProperty(value="columnNamePattern")
        private String columnNamePattern;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder configValues(ConfigValues configValues) {
            this.configValues = configValues;
            this.__explicitlySet__.add("configValues");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder expr(Expression expr) {
            this.expr = expr;
            this.__explicitlySet__.add("expr");
            return this;
        }

        public Builder useType(ConfiguredType useType) {
            this.useType = useType;
            this.__explicitlySet__.add("useType");
            return this;
        }

        public Builder type(BaseType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder columnNamePattern(String columnNamePattern) {
            this.columnNamePattern = columnNamePattern;
            this.__explicitlySet__.add("columnNamePattern");
            return this;
        }

        public PivotField build() {
            PivotField model = new PivotField(this.key, this.modelVersion, this.parentRef, this.configValues, this.objectStatus, this.name, this.description, this.expr, this.useType, this.type, this.columnNamePattern);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PivotField model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("configValues")) {
                this.configValues(model.getConfigValues());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("expr")) {
                this.expr(model.getExpr());
            }
            if (model.wasPropertyExplicitlySet("useType")) {
                this.useType(model.getUseType());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("columnNamePattern")) {
                this.columnNamePattern(model.getColumnNamePattern());
            }
            return this;
        }
    }
}

