/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.GroupedNamePatternRule;
import com.oracle.bmc.dataintegration.model.NameListRule;
import com.oracle.bmc.dataintegration.model.NamePatternRule;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.RenameRule;
import com.oracle.bmc.dataintegration.model.TypeListRule;
import com.oracle.bmc.dataintegration.model.TypedNamePatternRule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=ProjectionRule.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=RenameRule.class, name="RENAME_RULE"), @JsonSubTypes.Type(value=TypeListRule.class, name="TYPE_LIST_RULE"), @JsonSubTypes.Type(value=TypedNamePatternRule.class, name="TYPED_NAME_PATTERN_RULE"), @JsonSubTypes.Type(value=NamePatternRule.class, name="NAME_PATTERN_RULE"), @JsonSubTypes.Type(value=GroupedNamePatternRule.class, name="GROUPED_NAME_PATTERN_RULE"), @JsonSubTypes.Type(value=NameListRule.class, name="NAME_LIST_RULE")})
@JsonFilter(value="explicitlySetFilter")
public class ProjectionRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="isJavaRegexSyntax")
    private final Boolean isJavaRegexSyntax;
    @JsonProperty(value="configValues")
    private final ConfigValues configValues;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="description")
    private final String description;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "isJavaRegexSyntax", "configValues", "objectStatus", "description"})
    protected ProjectionRule(String key, String modelVersion, ParentReference parentRef, Boolean isJavaRegexSyntax, ConfigValues configValues, Integer objectStatus, String description) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.isJavaRegexSyntax = isJavaRegexSyntax;
        this.configValues = configValues;
        this.objectStatus = objectStatus;
        this.description = description;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public Boolean getIsJavaRegexSyntax() {
        return this.isJavaRegexSyntax;
    }

    public ConfigValues getConfigValues() {
        return this.configValues;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProjectionRule(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", isJavaRegexSyntax=").append(String.valueOf(this.isJavaRegexSyntax));
        sb.append(", configValues=").append(String.valueOf((Object)this.configValues));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectionRule)) {
            return false;
        }
        ProjectionRule other = (ProjectionRule)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.isJavaRegexSyntax, other.isJavaRegexSyntax) && Objects.equals((Object)this.configValues, (Object)other.configValues) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.description, other.description) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.isJavaRegexSyntax == null ? 43 : this.isJavaRegexSyntax.hashCode());
        result = result * 59 + (this.configValues == null ? 43 : this.configValues.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ModelType implements BmcEnum
    {
        NamePatternRule("NAME_PATTERN_RULE"),
        TypeListRule("TYPE_LIST_RULE"),
        NameListRule("NAME_LIST_RULE"),
        TypedNamePatternRule("TYPED_NAME_PATTERN_RULE"),
        RenameRule("RENAME_RULE"),
        GroupedNamePatternRule("GROUPED_NAME_PATTERN_RULE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

