/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.AbstractDataOperationConfig;
import com.oracle.bmc.dataintegration.model.AbstractReadAttribute;
import com.oracle.bmc.dataintegration.model.BipCallAttribute;
import com.oracle.bmc.dataintegration.model.DataFormat;
import com.oracle.bmc.dataintegration.model.IncrementalReadConfig;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.PartitionConfig;
import com.oracle.bmc.dataintegration.model.PushDownOperation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class ReadOperationConfig
extends AbstractDataOperationConfig {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="operations")
    private final List<PushDownOperation> operations;
    @JsonProperty(value="dataFormat")
    private final DataFormat dataFormat;
    @JsonProperty(value="partitionConfig")
    private final PartitionConfig partitionConfig;
    @JsonProperty(value="readAttribute")
    private final AbstractReadAttribute readAttribute;
    @JsonProperty(value="incrementalReadConfig")
    private final IncrementalReadConfig incrementalReadConfig;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ReadOperationConfig(Map<String, String> metadataConfigProperties, Map<String, String> derivedAttributes, BipCallAttribute callAttribute, String key, String modelVersion, ParentReference parentRef, List<PushDownOperation> operations, DataFormat dataFormat, PartitionConfig partitionConfig, AbstractReadAttribute readAttribute, IncrementalReadConfig incrementalReadConfig, Integer objectStatus) {
        super(metadataConfigProperties, derivedAttributes, callAttribute);
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.operations = operations;
        this.dataFormat = dataFormat;
        this.partitionConfig = partitionConfig;
        this.readAttribute = readAttribute;
        this.incrementalReadConfig = incrementalReadConfig;
        this.objectStatus = objectStatus;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public List<PushDownOperation> getOperations() {
        return this.operations;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public PartitionConfig getPartitionConfig() {
        return this.partitionConfig;
    }

    public AbstractReadAttribute getReadAttribute() {
        return this.readAttribute;
    }

    public IncrementalReadConfig getIncrementalReadConfig() {
        return this.incrementalReadConfig;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ReadOperationConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", operations=").append(String.valueOf(this.operations));
        sb.append(", dataFormat=").append(String.valueOf((Object)this.dataFormat));
        sb.append(", partitionConfig=").append(String.valueOf((Object)this.partitionConfig));
        sb.append(", readAttribute=").append(String.valueOf((Object)this.readAttribute));
        sb.append(", incrementalReadConfig=").append(String.valueOf((Object)this.incrementalReadConfig));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReadOperationConfig)) {
            return false;
        }
        ReadOperationConfig other = (ReadOperationConfig)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.operations, other.operations) && Objects.equals((Object)this.dataFormat, (Object)other.dataFormat) && Objects.equals((Object)this.partitionConfig, (Object)other.partitionConfig) && Objects.equals((Object)this.readAttribute, (Object)other.readAttribute) && Objects.equals((Object)this.incrementalReadConfig, (Object)other.incrementalReadConfig) && Objects.equals(this.objectStatus, other.objectStatus) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.operations == null ? 43 : this.operations.hashCode());
        result = result * 59 + (this.dataFormat == null ? 43 : this.dataFormat.hashCode());
        result = result * 59 + (this.partitionConfig == null ? 43 : this.partitionConfig.hashCode());
        result = result * 59 + (this.readAttribute == null ? 43 : this.readAttribute.hashCode());
        result = result * 59 + (this.incrementalReadConfig == null ? 43 : this.incrementalReadConfig.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metadataConfigProperties")
        private Map<String, String> metadataConfigProperties;
        @JsonProperty(value="derivedAttributes")
        private Map<String, String> derivedAttributes;
        @JsonProperty(value="callAttribute")
        private BipCallAttribute callAttribute;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="operations")
        private List<PushDownOperation> operations;
        @JsonProperty(value="dataFormat")
        private DataFormat dataFormat;
        @JsonProperty(value="partitionConfig")
        private PartitionConfig partitionConfig;
        @JsonProperty(value="readAttribute")
        private AbstractReadAttribute readAttribute;
        @JsonProperty(value="incrementalReadConfig")
        private IncrementalReadConfig incrementalReadConfig;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metadataConfigProperties(Map<String, String> metadataConfigProperties) {
            this.metadataConfigProperties = metadataConfigProperties;
            this.__explicitlySet__.add("metadataConfigProperties");
            return this;
        }

        public Builder derivedAttributes(Map<String, String> derivedAttributes) {
            this.derivedAttributes = derivedAttributes;
            this.__explicitlySet__.add("derivedAttributes");
            return this;
        }

        public Builder callAttribute(BipCallAttribute callAttribute) {
            this.callAttribute = callAttribute;
            this.__explicitlySet__.add("callAttribute");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder operations(List<PushDownOperation> operations) {
            this.operations = operations;
            this.__explicitlySet__.add("operations");
            return this;
        }

        public Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            this.__explicitlySet__.add("dataFormat");
            return this;
        }

        public Builder partitionConfig(PartitionConfig partitionConfig) {
            this.partitionConfig = partitionConfig;
            this.__explicitlySet__.add("partitionConfig");
            return this;
        }

        public Builder readAttribute(AbstractReadAttribute readAttribute) {
            this.readAttribute = readAttribute;
            this.__explicitlySet__.add("readAttribute");
            return this;
        }

        public Builder incrementalReadConfig(IncrementalReadConfig incrementalReadConfig) {
            this.incrementalReadConfig = incrementalReadConfig;
            this.__explicitlySet__.add("incrementalReadConfig");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public ReadOperationConfig build() {
            ReadOperationConfig model = new ReadOperationConfig(this.metadataConfigProperties, this.derivedAttributes, this.callAttribute, this.key, this.modelVersion, this.parentRef, this.operations, this.dataFormat, this.partitionConfig, this.readAttribute, this.incrementalReadConfig, this.objectStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ReadOperationConfig model) {
            if (model.wasPropertyExplicitlySet("metadataConfigProperties")) {
                this.metadataConfigProperties(model.getMetadataConfigProperties());
            }
            if (model.wasPropertyExplicitlySet("derivedAttributes")) {
                this.derivedAttributes(model.getDerivedAttributes());
            }
            if (model.wasPropertyExplicitlySet("callAttribute")) {
                this.callAttribute(model.getCallAttribute());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("operations")) {
                this.operations(model.getOperations());
            }
            if (model.wasPropertyExplicitlySet("dataFormat")) {
                this.dataFormat(model.getDataFormat());
            }
            if (model.wasPropertyExplicitlySet("partitionConfig")) {
                this.partitionConfig(model.getPartitionConfig());
            }
            if (model.wasPropertyExplicitlySet("readAttribute")) {
                this.readAttribute(model.getReadAttribute());
            }
            if (model.wasPropertyExplicitlySet("incrementalReadConfig")) {
                this.incrementalReadConfig(model.getIncrementalReadConfig());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            return this;
        }
    }
}

