/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ChildReference;
import com.oracle.bmc.dataintegration.model.ReferenceUsedBy;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Reference
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="identifierPath")
    private final String identifierPath;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="targetObject")
    private final Object targetObject;
    @JsonProperty(value="applicationKey")
    private final String applicationKey;
    @JsonProperty(value="usedBy")
    private final List<ReferenceUsedBy> usedBy;
    @JsonProperty(value="childReferences")
    private final List<ChildReference> childReferences;

    @Deprecated
    @ConstructorProperties(value={"key", "name", "identifier", "identifierPath", "description", "type", "targetObject", "applicationKey", "usedBy", "childReferences"})
    public Reference(String key, String name, String identifier, String identifierPath, String description, Type type, Object targetObject, String applicationKey, List<ReferenceUsedBy> usedBy, List<ChildReference> childReferences) {
        this.key = key;
        this.name = name;
        this.identifier = identifier;
        this.identifierPath = identifierPath;
        this.description = description;
        this.type = type;
        this.targetObject = targetObject;
        this.applicationKey = applicationKey;
        this.usedBy = usedBy;
        this.childReferences = childReferences;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getIdentifierPath() {
        return this.identifierPath;
    }

    public String getDescription() {
        return this.description;
    }

    public Type getType() {
        return this.type;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public List<ReferenceUsedBy> getUsedBy() {
        return this.usedBy;
    }

    public List<ChildReference> getChildReferences() {
        return this.childReferences;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Reference(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", identifierPath=").append(String.valueOf(this.identifierPath));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", targetObject=").append(String.valueOf(this.targetObject));
        sb.append(", applicationKey=").append(String.valueOf(this.applicationKey));
        sb.append(", usedBy=").append(String.valueOf(this.usedBy));
        sb.append(", childReferences=").append(String.valueOf(this.childReferences));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Reference)) {
            return false;
        }
        Reference other = (Reference)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.name, other.name) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.identifierPath, other.identifierPath) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.targetObject, other.targetObject) && Objects.equals(this.applicationKey, other.applicationKey) && Objects.equals(this.usedBy, other.usedBy) && Objects.equals(this.childReferences, other.childReferences) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.identifierPath == null ? 43 : this.identifierPath.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.targetObject == null ? 43 : this.targetObject.hashCode());
        result = result * 59 + (this.applicationKey == null ? 43 : this.applicationKey.hashCode());
        result = result * 59 + (this.usedBy == null ? 43 : this.usedBy.hashCode());
        result = result * 59 + (this.childReferences == null ? 43 : this.childReferences.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        OracleDataAsset("ORACLE_DATA_ASSET"),
        OracleObjectStorageDataAsset("ORACLE_OBJECT_STORAGE_DATA_ASSET"),
        OracleAtpDataAsset("ORACLE_ATP_DATA_ASSET"),
        OracleAdwcDataAsset("ORACLE_ADWC_DATA_ASSET"),
        MysqlDataAsset("MYSQL_DATA_ASSET"),
        GenericJdbcDataAsset("GENERIC_JDBC_DATA_ASSET"),
        FusionAppDataAsset("FUSION_APP_DATA_ASSET"),
        AmazonS3DataAsset("AMAZON_S3_DATA_ASSET"),
        Schema("SCHEMA"),
        IntegrationTask("INTEGRATION_TASK"),
        DataLoaderTask("DATA_LOADER_TASK"),
        SqlTask("SQL_TASK"),
        OciDataflowTask("OCI_DATAFLOW_TASK"),
        PipelineTask("PIPELINE_TASK"),
        RestTask("REST_TASK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="identifierPath")
        private String identifierPath;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="targetObject")
        private Object targetObject;
        @JsonProperty(value="applicationKey")
        private String applicationKey;
        @JsonProperty(value="usedBy")
        private List<ReferenceUsedBy> usedBy;
        @JsonProperty(value="childReferences")
        private List<ChildReference> childReferences;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder identifierPath(String identifierPath) {
            this.identifierPath = identifierPath;
            this.__explicitlySet__.add("identifierPath");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder targetObject(Object targetObject) {
            this.targetObject = targetObject;
            this.__explicitlySet__.add("targetObject");
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            this.__explicitlySet__.add("applicationKey");
            return this;
        }

        public Builder usedBy(List<ReferenceUsedBy> usedBy) {
            this.usedBy = usedBy;
            this.__explicitlySet__.add("usedBy");
            return this;
        }

        public Builder childReferences(List<ChildReference> childReferences) {
            this.childReferences = childReferences;
            this.__explicitlySet__.add("childReferences");
            return this;
        }

        public Reference build() {
            Reference model = new Reference(this.key, this.name, this.identifier, this.identifierPath, this.description, this.type, this.targetObject, this.applicationKey, this.usedBy, this.childReferences);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Reference model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("identifierPath")) {
                this.identifierPath(model.getIdentifierPath());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("targetObject")) {
                this.targetObject(model.getTargetObject());
            }
            if (model.wasPropertyExplicitlySet("applicationKey")) {
                this.applicationKey(model.getApplicationKey());
            }
            if (model.wasPropertyExplicitlySet("usedBy")) {
                this.usedBy(model.getUsedBy());
            }
            if (model.wasPropertyExplicitlySet("childReferences")) {
                this.childReferences(model.getChildReferences());
            }
            return this;
        }
    }
}

