/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.DynamicTypeHandler;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.ProjectionRule;
import com.oracle.bmc.dataintegration.model.ScopeReference;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class RuleTypeConfig
extends DynamicTypeHandler {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="scope")
    private final Object scope;
    @JsonProperty(value="scopeReference")
    private final ScopeReference scopeReference;
    @JsonProperty(value="isOrderByRule")
    private final Boolean isOrderByRule;
    @JsonProperty(value="projectionRules")
    private final List<ProjectionRule> projectionRules;
    @JsonProperty(value="configValues")
    private final ConfigValues configValues;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public RuleTypeConfig(String key, String modelVersion, ParentReference parentRef, Object scope, ScopeReference scopeReference, Boolean isOrderByRule, List<ProjectionRule> projectionRules, ConfigValues configValues, Integer objectStatus) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.scope = scope;
        this.scopeReference = scopeReference;
        this.isOrderByRule = isOrderByRule;
        this.projectionRules = projectionRules;
        this.configValues = configValues;
        this.objectStatus = objectStatus;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public Object getScope() {
        return this.scope;
    }

    public ScopeReference getScopeReference() {
        return this.scopeReference;
    }

    public Boolean getIsOrderByRule() {
        return this.isOrderByRule;
    }

    public List<ProjectionRule> getProjectionRules() {
        return this.projectionRules;
    }

    public ConfigValues getConfigValues() {
        return this.configValues;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RuleTypeConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", scope=").append(String.valueOf(this.scope));
        sb.append(", scopeReference=").append(String.valueOf((Object)this.scopeReference));
        sb.append(", isOrderByRule=").append(String.valueOf(this.isOrderByRule));
        sb.append(", projectionRules=").append(String.valueOf(this.projectionRules));
        sb.append(", configValues=").append(String.valueOf((Object)this.configValues));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuleTypeConfig)) {
            return false;
        }
        RuleTypeConfig other = (RuleTypeConfig)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.scope, other.scope) && Objects.equals((Object)this.scopeReference, (Object)other.scopeReference) && Objects.equals(this.isOrderByRule, other.isOrderByRule) && Objects.equals(this.projectionRules, other.projectionRules) && Objects.equals((Object)this.configValues, (Object)other.configValues) && Objects.equals(this.objectStatus, other.objectStatus) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.scopeReference == null ? 43 : this.scopeReference.hashCode());
        result = result * 59 + (this.isOrderByRule == null ? 43 : this.isOrderByRule.hashCode());
        result = result * 59 + (this.projectionRules == null ? 43 : this.projectionRules.hashCode());
        result = result * 59 + (this.configValues == null ? 43 : this.configValues.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="scope")
        private Object scope;
        @JsonProperty(value="scopeReference")
        private ScopeReference scopeReference;
        @JsonProperty(value="isOrderByRule")
        private Boolean isOrderByRule;
        @JsonProperty(value="projectionRules")
        private List<ProjectionRule> projectionRules;
        @JsonProperty(value="configValues")
        private ConfigValues configValues;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder scope(Object scope) {
            this.scope = scope;
            this.__explicitlySet__.add("scope");
            return this;
        }

        public Builder scopeReference(ScopeReference scopeReference) {
            this.scopeReference = scopeReference;
            this.__explicitlySet__.add("scopeReference");
            return this;
        }

        public Builder isOrderByRule(Boolean isOrderByRule) {
            this.isOrderByRule = isOrderByRule;
            this.__explicitlySet__.add("isOrderByRule");
            return this;
        }

        public Builder projectionRules(List<ProjectionRule> projectionRules) {
            this.projectionRules = projectionRules;
            this.__explicitlySet__.add("projectionRules");
            return this;
        }

        public Builder configValues(ConfigValues configValues) {
            this.configValues = configValues;
            this.__explicitlySet__.add("configValues");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public RuleTypeConfig build() {
            RuleTypeConfig model = new RuleTypeConfig(this.key, this.modelVersion, this.parentRef, this.scope, this.scopeReference, this.isOrderByRule, this.projectionRules, this.configValues, this.objectStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RuleTypeConfig model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("scope")) {
                this.scope(model.getScope());
            }
            if (model.wasPropertyExplicitlySet("scopeReference")) {
                this.scopeReference(model.getScopeReference());
            }
            if (model.wasPropertyExplicitlySet("isOrderByRule")) {
                this.isOrderByRule(model.getIsOrderByRule());
            }
            if (model.wasPropertyExplicitlySet("projectionRules")) {
                this.projectionRules(model.getProjectionRules());
            }
            if (model.wasPropertyExplicitlySet("configValues")) {
                this.configValues(model.getConfigValues());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            return this;
        }
    }
}

