/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ScopeReference
extends ExplicitlySetBmcModel {
    @JsonProperty(value="referenceObject")
    private final String referenceObject;
    @JsonProperty(value="referenceType")
    private final ReferenceType referenceType;
    @JsonProperty(value="refObjectName")
    private final String refObjectName;

    @Deprecated
    @ConstructorProperties(value={"referenceObject", "referenceType", "refObjectName"})
    public ScopeReference(String referenceObject, ReferenceType referenceType, String refObjectName) {
        this.referenceObject = referenceObject;
        this.referenceType = referenceType;
        this.refObjectName = refObjectName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getReferenceObject() {
        return this.referenceObject;
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public String getRefObjectName() {
        return this.refObjectName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScopeReference(");
        sb.append("super=").append(super.toString());
        sb.append("referenceObject=").append(String.valueOf(this.referenceObject));
        sb.append(", referenceType=").append(String.valueOf((Object)this.referenceType));
        sb.append(", refObjectName=").append(String.valueOf(this.refObjectName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScopeReference)) {
            return false;
        }
        ScopeReference other = (ScopeReference)((Object)o);
        return Objects.equals(this.referenceObject, other.referenceObject) && Objects.equals((Object)this.referenceType, (Object)other.referenceType) && Objects.equals(this.refObjectName, other.refObjectName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.referenceObject == null ? 43 : this.referenceObject.hashCode());
        result = result * 59 + (this.referenceType == null ? 43 : this.referenceType.hashCode());
        result = result * 59 + (this.refObjectName == null ? 43 : this.refObjectName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ReferenceType implements BmcEnum
    {
        DirectRef("DIRECT_REF"),
        BoundEntityShape("BOUND_ENTITY_SHAPE"),
        BoundEntityShapeField("BOUND_ENTITY_SHAPE_FIELD"),
        OciFunctionInputShape("OCI_FUNCTION_INPUT_SHAPE"),
        OciFunctionOutputShape("OCI_FUNCTION_OUTPUT_SHAPE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ReferenceType> map;

        private ReferenceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReferenceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ReferenceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ReferenceType.class);
            map = new HashMap<String, ReferenceType>();
            for (ReferenceType v : ReferenceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="referenceObject")
        private String referenceObject;
        @JsonProperty(value="referenceType")
        private ReferenceType referenceType;
        @JsonProperty(value="refObjectName")
        private String refObjectName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder referenceObject(String referenceObject) {
            this.referenceObject = referenceObject;
            this.__explicitlySet__.add("referenceObject");
            return this;
        }

        public Builder referenceType(ReferenceType referenceType) {
            this.referenceType = referenceType;
            this.__explicitlySet__.add("referenceType");
            return this;
        }

        public Builder refObjectName(String refObjectName) {
            this.refObjectName = refObjectName;
            this.__explicitlySet__.add("refObjectName");
            return this;
        }

        public ScopeReference build() {
            ScopeReference model = new ScopeReference(this.referenceObject, this.referenceType, this.refObjectName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScopeReference model) {
            if (model.wasPropertyExplicitlySet("referenceObject")) {
                this.referenceObject(model.getReferenceObject());
            }
            if (model.wasPropertyExplicitlySet("referenceType")) {
                this.referenceType(model.getReferenceType());
            }
            if (model.wasPropertyExplicitlySet("refObjectName")) {
                this.refObjectName(model.getRefObjectName());
            }
            return this;
        }
    }
}

