/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.DataEntity;
import com.oracle.bmc.dataintegration.model.InputPort;
import com.oracle.bmc.dataintegration.model.Operator;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.ReadOperationConfig;
import com.oracle.bmc.dataintegration.model.SchemaDriftConfig;
import com.oracle.bmc.dataintegration.model.Shape;
import com.oracle.bmc.dataintegration.model.TypedObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class Source
extends Operator {
    @JsonProperty(value="entity")
    private final DataEntity entity;
    @JsonProperty(value="isReadAccess")
    private final Boolean isReadAccess;
    @JsonProperty(value="isCopyFields")
    private final Boolean isCopyFields;
    @JsonProperty(value="isPredefinedShape")
    private final Boolean isPredefinedShape;
    @JsonProperty(value="schemaDriftConfig")
    private final SchemaDriftConfig schemaDriftConfig;
    @JsonProperty(value="fixedDataShape")
    private final Shape fixedDataShape;
    @JsonProperty(value="readOperationConfig")
    private final ReadOperationConfig readOperationConfig;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public Source(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, List<InputPort> inputPorts, List<TypedObject> outputPorts, Integer objectStatus, String identifier, List<Parameter> parameters, ConfigValues opConfigValues, DataEntity entity, Boolean isReadAccess, Boolean isCopyFields, Boolean isPredefinedShape, SchemaDriftConfig schemaDriftConfig, Shape fixedDataShape, ReadOperationConfig readOperationConfig) {
        super(key, modelVersion, parentRef, name, description, objectVersion, inputPorts, outputPorts, objectStatus, identifier, parameters, opConfigValues);
        this.entity = entity;
        this.isReadAccess = isReadAccess;
        this.isCopyFields = isCopyFields;
        this.isPredefinedShape = isPredefinedShape;
        this.schemaDriftConfig = schemaDriftConfig;
        this.fixedDataShape = fixedDataShape;
        this.readOperationConfig = readOperationConfig;
    }

    public DataEntity getEntity() {
        return this.entity;
    }

    public Boolean getIsReadAccess() {
        return this.isReadAccess;
    }

    public Boolean getIsCopyFields() {
        return this.isCopyFields;
    }

    public Boolean getIsPredefinedShape() {
        return this.isPredefinedShape;
    }

    public SchemaDriftConfig getSchemaDriftConfig() {
        return this.schemaDriftConfig;
    }

    public Shape getFixedDataShape() {
        return this.fixedDataShape;
    }

    public ReadOperationConfig getReadOperationConfig() {
        return this.readOperationConfig;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Source(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", entity=").append(String.valueOf((Object)this.entity));
        sb.append(", isReadAccess=").append(String.valueOf(this.isReadAccess));
        sb.append(", isCopyFields=").append(String.valueOf(this.isCopyFields));
        sb.append(", isPredefinedShape=").append(String.valueOf(this.isPredefinedShape));
        sb.append(", schemaDriftConfig=").append(String.valueOf((Object)this.schemaDriftConfig));
        sb.append(", fixedDataShape=").append(String.valueOf((Object)this.fixedDataShape));
        sb.append(", readOperationConfig=").append(String.valueOf((Object)this.readOperationConfig));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Source)) {
            return false;
        }
        Source other = (Source)((Object)o);
        return Objects.equals((Object)this.entity, (Object)other.entity) && Objects.equals(this.isReadAccess, other.isReadAccess) && Objects.equals(this.isCopyFields, other.isCopyFields) && Objects.equals(this.isPredefinedShape, other.isPredefinedShape) && Objects.equals((Object)this.schemaDriftConfig, (Object)other.schemaDriftConfig) && Objects.equals((Object)this.fixedDataShape, (Object)other.fixedDataShape) && Objects.equals((Object)this.readOperationConfig, (Object)other.readOperationConfig) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.entity == null ? 43 : this.entity.hashCode());
        result = result * 59 + (this.isReadAccess == null ? 43 : this.isReadAccess.hashCode());
        result = result * 59 + (this.isCopyFields == null ? 43 : this.isCopyFields.hashCode());
        result = result * 59 + (this.isPredefinedShape == null ? 43 : this.isPredefinedShape.hashCode());
        result = result * 59 + (this.schemaDriftConfig == null ? 43 : this.schemaDriftConfig.hashCode());
        result = result * 59 + (this.fixedDataShape == null ? 43 : this.fixedDataShape.hashCode());
        result = result * 59 + (this.readOperationConfig == null ? 43 : this.readOperationConfig.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="inputPorts")
        private List<InputPort> inputPorts;
        @JsonProperty(value="outputPorts")
        private List<TypedObject> outputPorts;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
        @JsonProperty(value="opConfigValues")
        private ConfigValues opConfigValues;
        @JsonProperty(value="entity")
        private DataEntity entity;
        @JsonProperty(value="isReadAccess")
        private Boolean isReadAccess;
        @JsonProperty(value="isCopyFields")
        private Boolean isCopyFields;
        @JsonProperty(value="isPredefinedShape")
        private Boolean isPredefinedShape;
        @JsonProperty(value="schemaDriftConfig")
        private SchemaDriftConfig schemaDriftConfig;
        @JsonProperty(value="fixedDataShape")
        private Shape fixedDataShape;
        @JsonProperty(value="readOperationConfig")
        private ReadOperationConfig readOperationConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder inputPorts(List<InputPort> inputPorts) {
            this.inputPorts = inputPorts;
            this.__explicitlySet__.add("inputPorts");
            return this;
        }

        public Builder outputPorts(List<TypedObject> outputPorts) {
            this.outputPorts = outputPorts;
            this.__explicitlySet__.add("outputPorts");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder opConfigValues(ConfigValues opConfigValues) {
            this.opConfigValues = opConfigValues;
            this.__explicitlySet__.add("opConfigValues");
            return this;
        }

        public Builder entity(DataEntity entity) {
            this.entity = entity;
            this.__explicitlySet__.add("entity");
            return this;
        }

        public Builder isReadAccess(Boolean isReadAccess) {
            this.isReadAccess = isReadAccess;
            this.__explicitlySet__.add("isReadAccess");
            return this;
        }

        public Builder isCopyFields(Boolean isCopyFields) {
            this.isCopyFields = isCopyFields;
            this.__explicitlySet__.add("isCopyFields");
            return this;
        }

        public Builder isPredefinedShape(Boolean isPredefinedShape) {
            this.isPredefinedShape = isPredefinedShape;
            this.__explicitlySet__.add("isPredefinedShape");
            return this;
        }

        public Builder schemaDriftConfig(SchemaDriftConfig schemaDriftConfig) {
            this.schemaDriftConfig = schemaDriftConfig;
            this.__explicitlySet__.add("schemaDriftConfig");
            return this;
        }

        public Builder fixedDataShape(Shape fixedDataShape) {
            this.fixedDataShape = fixedDataShape;
            this.__explicitlySet__.add("fixedDataShape");
            return this;
        }

        public Builder readOperationConfig(ReadOperationConfig readOperationConfig) {
            this.readOperationConfig = readOperationConfig;
            this.__explicitlySet__.add("readOperationConfig");
            return this;
        }

        public Source build() {
            Source model = new Source(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.inputPorts, this.outputPorts, this.objectStatus, this.identifier, this.parameters, this.opConfigValues, this.entity, this.isReadAccess, this.isCopyFields, this.isPredefinedShape, this.schemaDriftConfig, this.fixedDataShape, this.readOperationConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Source model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("inputPorts")) {
                this.inputPorts(model.getInputPorts());
            }
            if (model.wasPropertyExplicitlySet("outputPorts")) {
                this.outputPorts(model.getOutputPorts());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("opConfigValues")) {
                this.opConfigValues(model.getOpConfigValues());
            }
            if (model.wasPropertyExplicitlySet("entity")) {
                this.entity(model.getEntity());
            }
            if (model.wasPropertyExplicitlySet("isReadAccess")) {
                this.isReadAccess(model.getIsReadAccess());
            }
            if (model.wasPropertyExplicitlySet("isCopyFields")) {
                this.isCopyFields(model.getIsCopyFields());
            }
            if (model.wasPropertyExplicitlySet("isPredefinedShape")) {
                this.isPredefinedShape(model.getIsPredefinedShape());
            }
            if (model.wasPropertyExplicitlySet("schemaDriftConfig")) {
                this.schemaDriftConfig(model.getSchemaDriftConfig());
            }
            if (model.wasPropertyExplicitlySet("fixedDataShape")) {
                this.fixedDataShape(model.getFixedDataShape());
            }
            if (model.wasPropertyExplicitlySet("readOperationConfig")) {
                this.readOperationConfig(model.getReadOperationConfig());
            }
            return this;
        }
    }
}

