/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.ConfigProvider;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.InputPort;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.OutputPort;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.RegistryMetadata;
import com.oracle.bmc.dataintegration.model.TaskFromDataLoaderTaskDetails;
import com.oracle.bmc.dataintegration.model.TaskFromIntegrationTaskDetails;
import com.oracle.bmc.dataintegration.model.TaskFromOCIDataflowTaskDetails;
import com.oracle.bmc.dataintegration.model.TaskFromPipelineTaskDetails;
import com.oracle.bmc.dataintegration.model.TaskFromRestTaskDetails;
import com.oracle.bmc.dataintegration.model.TaskFromSQLTaskDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=Task.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=TaskFromPipelineTaskDetails.class, name="PIPELINE_TASK"), @JsonSubTypes.Type(value=TaskFromIntegrationTaskDetails.class, name="INTEGRATION_TASK"), @JsonSubTypes.Type(value=TaskFromSQLTaskDetails.class, name="SQL_TASK"), @JsonSubTypes.Type(value=TaskFromRestTaskDetails.class, name="REST_TASK"), @JsonSubTypes.Type(value=TaskFromOCIDataflowTaskDetails.class, name="OCI_DATAFLOW_TASK"), @JsonSubTypes.Type(value=TaskFromDataLoaderTaskDetails.class, name="DATA_LOADER_TASK")})
@JsonFilter(value="explicitlySetFilter")
public class Task
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="inputPorts")
    private final List<InputPort> inputPorts;
    @JsonProperty(value="outputPorts")
    private final List<OutputPort> outputPorts;
    @JsonProperty(value="parameters")
    private final List<Parameter> parameters;
    @JsonProperty(value="opConfigValues")
    private final ConfigValues opConfigValues;
    @JsonProperty(value="configProviderDelegate")
    private final ConfigProvider configProviderDelegate;
    @JsonProperty(value="isConcurrentAllowed")
    private final Boolean isConcurrentAllowed;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;
    @JsonProperty(value="keyMap")
    private final Map<String, String> keyMap;
    @JsonProperty(value="registryMetadata")
    private final RegistryMetadata registryMetadata;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "name", "description", "objectVersion", "objectStatus", "identifier", "inputPorts", "outputPorts", "parameters", "opConfigValues", "configProviderDelegate", "isConcurrentAllowed", "metadata", "keyMap", "registryMetadata"})
    protected Task(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, List<InputPort> inputPorts, List<OutputPort> outputPorts, List<Parameter> parameters, ConfigValues opConfigValues, ConfigProvider configProviderDelegate, Boolean isConcurrentAllowed, ObjectMetadata metadata, Map<String, String> keyMap, RegistryMetadata registryMetadata) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.inputPorts = inputPorts;
        this.outputPorts = outputPorts;
        this.parameters = parameters;
        this.opConfigValues = opConfigValues;
        this.configProviderDelegate = configProviderDelegate;
        this.isConcurrentAllowed = isConcurrentAllowed;
        this.metadata = metadata;
        this.keyMap = keyMap;
        this.registryMetadata = registryMetadata;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<InputPort> getInputPorts() {
        return this.inputPorts;
    }

    public List<OutputPort> getOutputPorts() {
        return this.outputPorts;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public ConfigValues getOpConfigValues() {
        return this.opConfigValues;
    }

    public ConfigProvider getConfigProviderDelegate() {
        return this.configProviderDelegate;
    }

    public Boolean getIsConcurrentAllowed() {
        return this.isConcurrentAllowed;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getKeyMap() {
        return this.keyMap;
    }

    public RegistryMetadata getRegistryMetadata() {
        return this.registryMetadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Task(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", inputPorts=").append(String.valueOf(this.inputPorts));
        sb.append(", outputPorts=").append(String.valueOf(this.outputPorts));
        sb.append(", parameters=").append(String.valueOf(this.parameters));
        sb.append(", opConfigValues=").append(String.valueOf((Object)this.opConfigValues));
        sb.append(", configProviderDelegate=").append(String.valueOf((Object)this.configProviderDelegate));
        sb.append(", isConcurrentAllowed=").append(String.valueOf(this.isConcurrentAllowed));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(", keyMap=").append(String.valueOf(this.keyMap));
        sb.append(", registryMetadata=").append(String.valueOf((Object)this.registryMetadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.inputPorts, other.inputPorts) && Objects.equals(this.outputPorts, other.outputPorts) && Objects.equals(this.parameters, other.parameters) && Objects.equals((Object)this.opConfigValues, (Object)other.opConfigValues) && Objects.equals((Object)this.configProviderDelegate, (Object)other.configProviderDelegate) && Objects.equals(this.isConcurrentAllowed, other.isConcurrentAllowed) && Objects.equals((Object)this.metadata, (Object)other.metadata) && Objects.equals(this.keyMap, other.keyMap) && Objects.equals((Object)this.registryMetadata, (Object)other.registryMetadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.inputPorts == null ? 43 : this.inputPorts.hashCode());
        result = result * 59 + (this.outputPorts == null ? 43 : this.outputPorts.hashCode());
        result = result * 59 + (this.parameters == null ? 43 : this.parameters.hashCode());
        result = result * 59 + (this.opConfigValues == null ? 43 : this.opConfigValues.hashCode());
        result = result * 59 + (this.configProviderDelegate == null ? 43 : this.configProviderDelegate.hashCode());
        result = result * 59 + (this.isConcurrentAllowed == null ? 43 : this.isConcurrentAllowed.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.keyMap == null ? 43 : this.keyMap.hashCode());
        result = result * 59 + (this.registryMetadata == null ? 43 : this.registryMetadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ModelType implements BmcEnum
    {
        IntegrationTask("INTEGRATION_TASK"),
        DataLoaderTask("DATA_LOADER_TASK"),
        PipelineTask("PIPELINE_TASK"),
        SqlTask("SQL_TASK"),
        OciDataflowTask("OCI_DATAFLOW_TASK"),
        RestTask("REST_TASK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

