/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigProvider;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParameterValue;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.TaskSchedule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TaskRun
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="configProvider")
    private final ConfigProvider configProvider;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="startTimeMillis")
    private final Long startTimeMillis;
    @JsonProperty(value="endTimeMillis")
    private final Long endTimeMillis;
    @JsonProperty(value="lastUpdated")
    private final Long lastUpdated;
    @JsonProperty(value="recordsWritten")
    private final Long recordsWritten;
    @JsonProperty(value="bytesProcessed")
    private final Long bytesProcessed;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="expectedDuration")
    private final Double expectedDuration;
    @JsonProperty(value="expectedDurationUnit")
    private final ExpectedDurationUnit expectedDurationUnit;
    @JsonProperty(value="taskKey")
    private final String taskKey;
    @JsonProperty(value="externalId")
    private final String externalId;
    @JsonProperty(value="retryAttempt")
    private final Integer retryAttempt;
    @JsonProperty(value="taskSchedule")
    private final TaskSchedule taskSchedule;
    @JsonProperty(value="metrics")
    private final Map<String, Float> metrics;
    @JsonProperty(value="outputs")
    private final Map<String, ParameterValue> outputs;
    @JsonProperty(value="executionErrors")
    private final List<String> executionErrors;
    @JsonProperty(value="terminationErrors")
    private final List<String> terminationErrors;
    @JsonProperty(value="authMode")
    private final AuthMode authMode;
    @JsonProperty(value="opcRequestId")
    private final String opcRequestId;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="taskType")
    private final TaskType taskType;
    @JsonProperty(value="isLogProcessingInProgress")
    private final Boolean isLogProcessingInProgress;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;
    @JsonProperty(value="keyMap")
    private final Map<String, String> keyMap;

    @Deprecated
    @ConstructorProperties(value={"key", "modelType", "modelVersion", "parentRef", "name", "description", "objectVersion", "configProvider", "status", "startTimeMillis", "endTimeMillis", "lastUpdated", "recordsWritten", "bytesProcessed", "errorMessage", "expectedDuration", "expectedDurationUnit", "taskKey", "externalId", "retryAttempt", "taskSchedule", "metrics", "outputs", "executionErrors", "terminationErrors", "authMode", "opcRequestId", "objectStatus", "taskType", "isLogProcessingInProgress", "identifier", "metadata", "keyMap"})
    public TaskRun(String key, String modelType, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, ConfigProvider configProvider, Status status, Long startTimeMillis, Long endTimeMillis, Long lastUpdated, Long recordsWritten, Long bytesProcessed, String errorMessage, Double expectedDuration, ExpectedDurationUnit expectedDurationUnit, String taskKey, String externalId, Integer retryAttempt, TaskSchedule taskSchedule, Map<String, Float> metrics, Map<String, ParameterValue> outputs, List<String> executionErrors, List<String> terminationErrors, AuthMode authMode, String opcRequestId, Integer objectStatus, TaskType taskType, Boolean isLogProcessingInProgress, String identifier, ObjectMetadata metadata, Map<String, String> keyMap) {
        this.key = key;
        this.modelType = modelType;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.configProvider = configProvider;
        this.status = status;
        this.startTimeMillis = startTimeMillis;
        this.endTimeMillis = endTimeMillis;
        this.lastUpdated = lastUpdated;
        this.recordsWritten = recordsWritten;
        this.bytesProcessed = bytesProcessed;
        this.errorMessage = errorMessage;
        this.expectedDuration = expectedDuration;
        this.expectedDurationUnit = expectedDurationUnit;
        this.taskKey = taskKey;
        this.externalId = externalId;
        this.retryAttempt = retryAttempt;
        this.taskSchedule = taskSchedule;
        this.metrics = metrics;
        this.outputs = outputs;
        this.executionErrors = executionErrors;
        this.terminationErrors = terminationErrors;
        this.authMode = authMode;
        this.opcRequestId = opcRequestId;
        this.objectStatus = objectStatus;
        this.taskType = taskType;
        this.isLogProcessingInProgress = isLogProcessingInProgress;
        this.identifier = identifier;
        this.metadata = metadata;
        this.keyMap = keyMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public ConfigProvider getConfigProvider() {
        return this.configProvider;
    }

    public Status getStatus() {
        return this.status;
    }

    public Long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public Long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public Long getLastUpdated() {
        return this.lastUpdated;
    }

    public Long getRecordsWritten() {
        return this.recordsWritten;
    }

    public Long getBytesProcessed() {
        return this.bytesProcessed;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Double getExpectedDuration() {
        return this.expectedDuration;
    }

    public ExpectedDurationUnit getExpectedDurationUnit() {
        return this.expectedDurationUnit;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public Integer getRetryAttempt() {
        return this.retryAttempt;
    }

    public TaskSchedule getTaskSchedule() {
        return this.taskSchedule;
    }

    public Map<String, Float> getMetrics() {
        return this.metrics;
    }

    public Map<String, ParameterValue> getOutputs() {
        return this.outputs;
    }

    public List<String> getExecutionErrors() {
        return this.executionErrors;
    }

    public List<String> getTerminationErrors() {
        return this.terminationErrors;
    }

    public AuthMode getAuthMode() {
        return this.authMode;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public Boolean getIsLogProcessingInProgress() {
        return this.isLogProcessingInProgress;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getKeyMap() {
        return this.keyMap;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TaskRun(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", configProvider=").append(String.valueOf((Object)this.configProvider));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", startTimeMillis=").append(String.valueOf(this.startTimeMillis));
        sb.append(", endTimeMillis=").append(String.valueOf(this.endTimeMillis));
        sb.append(", lastUpdated=").append(String.valueOf(this.lastUpdated));
        sb.append(", recordsWritten=").append(String.valueOf(this.recordsWritten));
        sb.append(", bytesProcessed=").append(String.valueOf(this.bytesProcessed));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", expectedDuration=").append(String.valueOf(this.expectedDuration));
        sb.append(", expectedDurationUnit=").append(String.valueOf((Object)this.expectedDurationUnit));
        sb.append(", taskKey=").append(String.valueOf(this.taskKey));
        sb.append(", externalId=").append(String.valueOf(this.externalId));
        sb.append(", retryAttempt=").append(String.valueOf(this.retryAttempt));
        sb.append(", taskSchedule=").append(String.valueOf((Object)this.taskSchedule));
        sb.append(", metrics=").append(String.valueOf(this.metrics));
        sb.append(", outputs=").append(String.valueOf(this.outputs));
        sb.append(", executionErrors=").append(String.valueOf(this.executionErrors));
        sb.append(", terminationErrors=").append(String.valueOf(this.terminationErrors));
        sb.append(", authMode=").append(String.valueOf((Object)this.authMode));
        sb.append(", opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", taskType=").append(String.valueOf((Object)this.taskType));
        sb.append(", isLogProcessingInProgress=").append(String.valueOf(this.isLogProcessingInProgress));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(", keyMap=").append(String.valueOf(this.keyMap));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskRun)) {
            return false;
        }
        TaskRun other = (TaskRun)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelType, other.modelType) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals((Object)this.configProvider, (Object)other.configProvider) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.startTimeMillis, other.startTimeMillis) && Objects.equals(this.endTimeMillis, other.endTimeMillis) && Objects.equals(this.lastUpdated, other.lastUpdated) && Objects.equals(this.recordsWritten, other.recordsWritten) && Objects.equals(this.bytesProcessed, other.bytesProcessed) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.expectedDuration, other.expectedDuration) && Objects.equals((Object)this.expectedDurationUnit, (Object)other.expectedDurationUnit) && Objects.equals(this.taskKey, other.taskKey) && Objects.equals(this.externalId, other.externalId) && Objects.equals(this.retryAttempt, other.retryAttempt) && Objects.equals((Object)this.taskSchedule, (Object)other.taskSchedule) && Objects.equals(this.metrics, other.metrics) && Objects.equals(this.outputs, other.outputs) && Objects.equals(this.executionErrors, other.executionErrors) && Objects.equals(this.terminationErrors, other.terminationErrors) && Objects.equals((Object)this.authMode, (Object)other.authMode) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals((Object)this.taskType, (Object)other.taskType) && Objects.equals(this.isLogProcessingInProgress, other.isLogProcessingInProgress) && Objects.equals(this.identifier, other.identifier) && Objects.equals((Object)this.metadata, (Object)other.metadata) && Objects.equals(this.keyMap, other.keyMap) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.configProvider == null ? 43 : this.configProvider.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.startTimeMillis == null ? 43 : this.startTimeMillis.hashCode());
        result = result * 59 + (this.endTimeMillis == null ? 43 : this.endTimeMillis.hashCode());
        result = result * 59 + (this.lastUpdated == null ? 43 : this.lastUpdated.hashCode());
        result = result * 59 + (this.recordsWritten == null ? 43 : this.recordsWritten.hashCode());
        result = result * 59 + (this.bytesProcessed == null ? 43 : this.bytesProcessed.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.expectedDuration == null ? 43 : this.expectedDuration.hashCode());
        result = result * 59 + (this.expectedDurationUnit == null ? 43 : this.expectedDurationUnit.hashCode());
        result = result * 59 + (this.taskKey == null ? 43 : this.taskKey.hashCode());
        result = result * 59 + (this.externalId == null ? 43 : this.externalId.hashCode());
        result = result * 59 + (this.retryAttempt == null ? 43 : this.retryAttempt.hashCode());
        result = result * 59 + (this.taskSchedule == null ? 43 : this.taskSchedule.hashCode());
        result = result * 59 + (this.metrics == null ? 43 : this.metrics.hashCode());
        result = result * 59 + (this.outputs == null ? 43 : this.outputs.hashCode());
        result = result * 59 + (this.executionErrors == null ? 43 : this.executionErrors.hashCode());
        result = result * 59 + (this.terminationErrors == null ? 43 : this.terminationErrors.hashCode());
        result = result * 59 + (this.authMode == null ? 43 : this.authMode.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.taskType == null ? 43 : this.taskType.hashCode());
        result = result * 59 + (this.isLogProcessingInProgress == null ? 43 : this.isLogProcessingInProgress.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.keyMap == null ? 43 : this.keyMap.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TaskType implements BmcEnum
    {
        IntegrationTask("INTEGRATION_TASK"),
        DataLoaderTask("DATA_LOADER_TASK"),
        PipelineTask("PIPELINE_TASK"),
        SqlTask("SQL_TASK"),
        OciDataflowTask("OCI_DATAFLOW_TASK"),
        RestTask("REST_TASK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TaskType> map;

        private TaskType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TaskType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TaskType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TaskType.class);
            map = new HashMap<String, TaskType>();
            for (TaskType v : TaskType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AuthMode implements BmcEnum
    {
        Obo("OBO"),
        ResourcePrincipal("RESOURCE_PRINCIPAL"),
        UserCertificate("USER_CERTIFICATE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AuthMode> map;

        private AuthMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AuthMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AuthMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AuthMode.class);
            map = new HashMap<String, AuthMode>();
            for (AuthMode v : AuthMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ExpectedDurationUnit implements BmcEnum
    {
        Seconds("SECONDS"),
        Minutes("MINUTES"),
        Hours("HOURS"),
        Days("DAYS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExpectedDurationUnit> map;

        private ExpectedDurationUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExpectedDurationUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExpectedDurationUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExpectedDurationUnit.class);
            map = new HashMap<String, ExpectedDurationUnit>();
            for (ExpectedDurationUnit v : ExpectedDurationUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        NotStarted("NOT_STARTED"),
        Queued("QUEUED"),
        Running("RUNNING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Success("SUCCESS"),
        Error("ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="configProvider")
        private ConfigProvider configProvider;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="startTimeMillis")
        private Long startTimeMillis;
        @JsonProperty(value="endTimeMillis")
        private Long endTimeMillis;
        @JsonProperty(value="lastUpdated")
        private Long lastUpdated;
        @JsonProperty(value="recordsWritten")
        private Long recordsWritten;
        @JsonProperty(value="bytesProcessed")
        private Long bytesProcessed;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="expectedDuration")
        private Double expectedDuration;
        @JsonProperty(value="expectedDurationUnit")
        private ExpectedDurationUnit expectedDurationUnit;
        @JsonProperty(value="taskKey")
        private String taskKey;
        @JsonProperty(value="externalId")
        private String externalId;
        @JsonProperty(value="retryAttempt")
        private Integer retryAttempt;
        @JsonProperty(value="taskSchedule")
        private TaskSchedule taskSchedule;
        @JsonProperty(value="metrics")
        private Map<String, Float> metrics;
        @JsonProperty(value="outputs")
        private Map<String, ParameterValue> outputs;
        @JsonProperty(value="executionErrors")
        private List<String> executionErrors;
        @JsonProperty(value="terminationErrors")
        private List<String> terminationErrors;
        @JsonProperty(value="authMode")
        private AuthMode authMode;
        @JsonProperty(value="opcRequestId")
        private String opcRequestId;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="taskType")
        private TaskType taskType;
        @JsonProperty(value="isLogProcessingInProgress")
        private Boolean isLogProcessingInProgress;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonProperty(value="keyMap")
        private Map<String, String> keyMap;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder configProvider(ConfigProvider configProvider) {
            this.configProvider = configProvider;
            this.__explicitlySet__.add("configProvider");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder startTimeMillis(Long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
            this.__explicitlySet__.add("startTimeMillis");
            return this;
        }

        public Builder endTimeMillis(Long endTimeMillis) {
            this.endTimeMillis = endTimeMillis;
            this.__explicitlySet__.add("endTimeMillis");
            return this;
        }

        public Builder lastUpdated(Long lastUpdated) {
            this.lastUpdated = lastUpdated;
            this.__explicitlySet__.add("lastUpdated");
            return this;
        }

        public Builder recordsWritten(Long recordsWritten) {
            this.recordsWritten = recordsWritten;
            this.__explicitlySet__.add("recordsWritten");
            return this;
        }

        public Builder bytesProcessed(Long bytesProcessed) {
            this.bytesProcessed = bytesProcessed;
            this.__explicitlySet__.add("bytesProcessed");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder expectedDuration(Double expectedDuration) {
            this.expectedDuration = expectedDuration;
            this.__explicitlySet__.add("expectedDuration");
            return this;
        }

        public Builder expectedDurationUnit(ExpectedDurationUnit expectedDurationUnit) {
            this.expectedDurationUnit = expectedDurationUnit;
            this.__explicitlySet__.add("expectedDurationUnit");
            return this;
        }

        public Builder taskKey(String taskKey) {
            this.taskKey = taskKey;
            this.__explicitlySet__.add("taskKey");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.__explicitlySet__.add("externalId");
            return this;
        }

        public Builder retryAttempt(Integer retryAttempt) {
            this.retryAttempt = retryAttempt;
            this.__explicitlySet__.add("retryAttempt");
            return this;
        }

        public Builder taskSchedule(TaskSchedule taskSchedule) {
            this.taskSchedule = taskSchedule;
            this.__explicitlySet__.add("taskSchedule");
            return this;
        }

        public Builder metrics(Map<String, Float> metrics) {
            this.metrics = metrics;
            this.__explicitlySet__.add("metrics");
            return this;
        }

        public Builder outputs(Map<String, ParameterValue> outputs) {
            this.outputs = outputs;
            this.__explicitlySet__.add("outputs");
            return this;
        }

        public Builder executionErrors(List<String> executionErrors) {
            this.executionErrors = executionErrors;
            this.__explicitlySet__.add("executionErrors");
            return this;
        }

        public Builder terminationErrors(List<String> terminationErrors) {
            this.terminationErrors = terminationErrors;
            this.__explicitlySet__.add("terminationErrors");
            return this;
        }

        public Builder authMode(AuthMode authMode) {
            this.authMode = authMode;
            this.__explicitlySet__.add("authMode");
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            this.__explicitlySet__.add("opcRequestId");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder taskType(TaskType taskType) {
            this.taskType = taskType;
            this.__explicitlySet__.add("taskType");
            return this;
        }

        public Builder isLogProcessingInProgress(Boolean isLogProcessingInProgress) {
            this.isLogProcessingInProgress = isLogProcessingInProgress;
            this.__explicitlySet__.add("isLogProcessingInProgress");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder keyMap(Map<String, String> keyMap) {
            this.keyMap = keyMap;
            this.__explicitlySet__.add("keyMap");
            return this;
        }

        public TaskRun build() {
            TaskRun model = new TaskRun(this.key, this.modelType, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.configProvider, this.status, this.startTimeMillis, this.endTimeMillis, this.lastUpdated, this.recordsWritten, this.bytesProcessed, this.errorMessage, this.expectedDuration, this.expectedDurationUnit, this.taskKey, this.externalId, this.retryAttempt, this.taskSchedule, this.metrics, this.outputs, this.executionErrors, this.terminationErrors, this.authMode, this.opcRequestId, this.objectStatus, this.taskType, this.isLogProcessingInProgress, this.identifier, this.metadata, this.keyMap);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TaskRun model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("configProvider")) {
                this.configProvider(model.getConfigProvider());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("startTimeMillis")) {
                this.startTimeMillis(model.getStartTimeMillis());
            }
            if (model.wasPropertyExplicitlySet("endTimeMillis")) {
                this.endTimeMillis(model.getEndTimeMillis());
            }
            if (model.wasPropertyExplicitlySet("lastUpdated")) {
                this.lastUpdated(model.getLastUpdated());
            }
            if (model.wasPropertyExplicitlySet("recordsWritten")) {
                this.recordsWritten(model.getRecordsWritten());
            }
            if (model.wasPropertyExplicitlySet("bytesProcessed")) {
                this.bytesProcessed(model.getBytesProcessed());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("expectedDuration")) {
                this.expectedDuration(model.getExpectedDuration());
            }
            if (model.wasPropertyExplicitlySet("expectedDurationUnit")) {
                this.expectedDurationUnit(model.getExpectedDurationUnit());
            }
            if (model.wasPropertyExplicitlySet("taskKey")) {
                this.taskKey(model.getTaskKey());
            }
            if (model.wasPropertyExplicitlySet("externalId")) {
                this.externalId(model.getExternalId());
            }
            if (model.wasPropertyExplicitlySet("retryAttempt")) {
                this.retryAttempt(model.getRetryAttempt());
            }
            if (model.wasPropertyExplicitlySet("taskSchedule")) {
                this.taskSchedule(model.getTaskSchedule());
            }
            if (model.wasPropertyExplicitlySet("metrics")) {
                this.metrics(model.getMetrics());
            }
            if (model.wasPropertyExplicitlySet("outputs")) {
                this.outputs(model.getOutputs());
            }
            if (model.wasPropertyExplicitlySet("executionErrors")) {
                this.executionErrors(model.getExecutionErrors());
            }
            if (model.wasPropertyExplicitlySet("terminationErrors")) {
                this.terminationErrors(model.getTerminationErrors());
            }
            if (model.wasPropertyExplicitlySet("authMode")) {
                this.authMode(model.getAuthMode());
            }
            if (model.wasPropertyExplicitlySet("opcRequestId")) {
                this.opcRequestId(model.getOpcRequestId());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("taskType")) {
                this.taskType(model.getTaskType());
            }
            if (model.wasPropertyExplicitlySet("isLogProcessingInProgress")) {
                this.isLogProcessingInProgress(model.getIsLogProcessingInProgress());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("keyMap")) {
                this.keyMap(model.getKeyMap());
            }
            return this;
        }
    }
}

