/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParameterValue;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TaskRunSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="startTimeMillis")
    private final Long startTimeMillis;
    @JsonProperty(value="endTimeMillis")
    private final Long endTimeMillis;
    @JsonProperty(value="lastUpdated")
    private final Long lastUpdated;
    @JsonProperty(value="recordsWritten")
    private final Long recordsWritten;
    @JsonProperty(value="bytesProcessed")
    private final Long bytesProcessed;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="taskType")
    private final TaskType taskType;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="refTaskRunId")
    private final String refTaskRunId;
    @JsonProperty(value="reRunType")
    private final ReRunType reRunType;
    @JsonProperty(value="stepId")
    private final String stepId;
    @JsonProperty(value="inputs")
    private final Map<String, ParameterValue> inputs;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;

    @Deprecated
    @ConstructorProperties(value={"key", "modelType", "modelVersion", "parentRef", "name", "description", "objectVersion", "status", "startTimeMillis", "endTimeMillis", "lastUpdated", "recordsWritten", "bytesProcessed", "objectStatus", "taskType", "identifier", "refTaskRunId", "reRunType", "stepId", "inputs", "metadata"})
    public TaskRunSummary(String key, String modelType, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, Status status, Long startTimeMillis, Long endTimeMillis, Long lastUpdated, Long recordsWritten, Long bytesProcessed, Integer objectStatus, TaskType taskType, String identifier, String refTaskRunId, ReRunType reRunType, String stepId, Map<String, ParameterValue> inputs, ObjectMetadata metadata) {
        this.key = key;
        this.modelType = modelType;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.status = status;
        this.startTimeMillis = startTimeMillis;
        this.endTimeMillis = endTimeMillis;
        this.lastUpdated = lastUpdated;
        this.recordsWritten = recordsWritten;
        this.bytesProcessed = bytesProcessed;
        this.objectStatus = objectStatus;
        this.taskType = taskType;
        this.identifier = identifier;
        this.refTaskRunId = refTaskRunId;
        this.reRunType = reRunType;
        this.stepId = stepId;
        this.inputs = inputs;
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public Status getStatus() {
        return this.status;
    }

    public Long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public Long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public Long getLastUpdated() {
        return this.lastUpdated;
    }

    public Long getRecordsWritten() {
        return this.recordsWritten;
    }

    public Long getBytesProcessed() {
        return this.bytesProcessed;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getRefTaskRunId() {
        return this.refTaskRunId;
    }

    public ReRunType getReRunType() {
        return this.reRunType;
    }

    public String getStepId() {
        return this.stepId;
    }

    public Map<String, ParameterValue> getInputs() {
        return this.inputs;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TaskRunSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", startTimeMillis=").append(String.valueOf(this.startTimeMillis));
        sb.append(", endTimeMillis=").append(String.valueOf(this.endTimeMillis));
        sb.append(", lastUpdated=").append(String.valueOf(this.lastUpdated));
        sb.append(", recordsWritten=").append(String.valueOf(this.recordsWritten));
        sb.append(", bytesProcessed=").append(String.valueOf(this.bytesProcessed));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", taskType=").append(String.valueOf((Object)this.taskType));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", refTaskRunId=").append(String.valueOf(this.refTaskRunId));
        sb.append(", reRunType=").append(String.valueOf((Object)this.reRunType));
        sb.append(", stepId=").append(String.valueOf(this.stepId));
        sb.append(", inputs=").append(String.valueOf(this.inputs));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskRunSummary)) {
            return false;
        }
        TaskRunSummary other = (TaskRunSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelType, other.modelType) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.startTimeMillis, other.startTimeMillis) && Objects.equals(this.endTimeMillis, other.endTimeMillis) && Objects.equals(this.lastUpdated, other.lastUpdated) && Objects.equals(this.recordsWritten, other.recordsWritten) && Objects.equals(this.bytesProcessed, other.bytesProcessed) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals((Object)this.taskType, (Object)other.taskType) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.refTaskRunId, other.refTaskRunId) && Objects.equals((Object)this.reRunType, (Object)other.reRunType) && Objects.equals(this.stepId, other.stepId) && Objects.equals(this.inputs, other.inputs) && Objects.equals((Object)this.metadata, (Object)other.metadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.startTimeMillis == null ? 43 : this.startTimeMillis.hashCode());
        result = result * 59 + (this.endTimeMillis == null ? 43 : this.endTimeMillis.hashCode());
        result = result * 59 + (this.lastUpdated == null ? 43 : this.lastUpdated.hashCode());
        result = result * 59 + (this.recordsWritten == null ? 43 : this.recordsWritten.hashCode());
        result = result * 59 + (this.bytesProcessed == null ? 43 : this.bytesProcessed.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.taskType == null ? 43 : this.taskType.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.refTaskRunId == null ? 43 : this.refTaskRunId.hashCode());
        result = result * 59 + (this.reRunType == null ? 43 : this.reRunType.hashCode());
        result = result * 59 + (this.stepId == null ? 43 : this.stepId.hashCode());
        result = result * 59 + (this.inputs == null ? 43 : this.inputs.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ReRunType implements BmcEnum
    {
        Beginning("BEGINNING"),
        Failed("FAILED"),
        Step("STEP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ReRunType> map;

        private ReRunType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReRunType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ReRunType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ReRunType.class);
            map = new HashMap<String, ReRunType>();
            for (ReRunType v : ReRunType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TaskType implements BmcEnum
    {
        IntegrationTask("INTEGRATION_TASK"),
        DataLoaderTask("DATA_LOADER_TASK"),
        PipelineTask("PIPELINE_TASK"),
        SqlTask("SQL_TASK"),
        OciDataflowTask("OCI_DATAFLOW_TASK"),
        RestTask("REST_TASK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TaskType> map;

        private TaskType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TaskType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TaskType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TaskType.class);
            map = new HashMap<String, TaskType>();
            for (TaskType v : TaskType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        NotStarted("NOT_STARTED"),
        Queued("QUEUED"),
        Running("RUNNING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Success("SUCCESS"),
        Error("ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="startTimeMillis")
        private Long startTimeMillis;
        @JsonProperty(value="endTimeMillis")
        private Long endTimeMillis;
        @JsonProperty(value="lastUpdated")
        private Long lastUpdated;
        @JsonProperty(value="recordsWritten")
        private Long recordsWritten;
        @JsonProperty(value="bytesProcessed")
        private Long bytesProcessed;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="taskType")
        private TaskType taskType;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="refTaskRunId")
        private String refTaskRunId;
        @JsonProperty(value="reRunType")
        private ReRunType reRunType;
        @JsonProperty(value="stepId")
        private String stepId;
        @JsonProperty(value="inputs")
        private Map<String, ParameterValue> inputs;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder startTimeMillis(Long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
            this.__explicitlySet__.add("startTimeMillis");
            return this;
        }

        public Builder endTimeMillis(Long endTimeMillis) {
            this.endTimeMillis = endTimeMillis;
            this.__explicitlySet__.add("endTimeMillis");
            return this;
        }

        public Builder lastUpdated(Long lastUpdated) {
            this.lastUpdated = lastUpdated;
            this.__explicitlySet__.add("lastUpdated");
            return this;
        }

        public Builder recordsWritten(Long recordsWritten) {
            this.recordsWritten = recordsWritten;
            this.__explicitlySet__.add("recordsWritten");
            return this;
        }

        public Builder bytesProcessed(Long bytesProcessed) {
            this.bytesProcessed = bytesProcessed;
            this.__explicitlySet__.add("bytesProcessed");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder taskType(TaskType taskType) {
            this.taskType = taskType;
            this.__explicitlySet__.add("taskType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder refTaskRunId(String refTaskRunId) {
            this.refTaskRunId = refTaskRunId;
            this.__explicitlySet__.add("refTaskRunId");
            return this;
        }

        public Builder reRunType(ReRunType reRunType) {
            this.reRunType = reRunType;
            this.__explicitlySet__.add("reRunType");
            return this;
        }

        public Builder stepId(String stepId) {
            this.stepId = stepId;
            this.__explicitlySet__.add("stepId");
            return this;
        }

        public Builder inputs(Map<String, ParameterValue> inputs) {
            this.inputs = inputs;
            this.__explicitlySet__.add("inputs");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public TaskRunSummary build() {
            TaskRunSummary model = new TaskRunSummary(this.key, this.modelType, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.status, this.startTimeMillis, this.endTimeMillis, this.lastUpdated, this.recordsWritten, this.bytesProcessed, this.objectStatus, this.taskType, this.identifier, this.refTaskRunId, this.reRunType, this.stepId, this.inputs, this.metadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TaskRunSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("startTimeMillis")) {
                this.startTimeMillis(model.getStartTimeMillis());
            }
            if (model.wasPropertyExplicitlySet("endTimeMillis")) {
                this.endTimeMillis(model.getEndTimeMillis());
            }
            if (model.wasPropertyExplicitlySet("lastUpdated")) {
                this.lastUpdated(model.getLastUpdated());
            }
            if (model.wasPropertyExplicitlySet("recordsWritten")) {
                this.recordsWritten(model.getRecordsWritten());
            }
            if (model.wasPropertyExplicitlySet("bytesProcessed")) {
                this.bytesProcessed(model.getBytesProcessed());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("taskType")) {
                this.taskType(model.getTaskType());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("refTaskRunId")) {
                this.refTaskRunId(model.getRefTaskRunId());
            }
            if (model.wasPropertyExplicitlySet("reRunType")) {
                this.reRunType(model.getReRunType());
            }
            if (model.wasPropertyExplicitlySet("stepId")) {
                this.stepId(model.getStepId());
            }
            if (model.wasPropertyExplicitlySet("inputs")) {
                this.inputs(model.getInputs());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            return this;
        }
    }
}

