/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigProvider;
import com.oracle.bmc.dataintegration.model.LastRunDetails;
import com.oracle.bmc.dataintegration.model.ObjectMetadata;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Schedule;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TaskScheduleSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="scheduleRef")
    private final Schedule scheduleRef;
    @JsonProperty(value="configProviderDelegate")
    private final ConfigProvider configProviderDelegate;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="numberOfRetries")
    private final Integer numberOfRetries;
    @JsonProperty(value="retryDelay")
    private final Double retryDelay;
    @JsonProperty(value="retryDelayUnit")
    private final RetryDelayUnit retryDelayUnit;
    @JsonProperty(value="startTimeMillis")
    private final Long startTimeMillis;
    @JsonProperty(value="endTimeMillis")
    private final Long endTimeMillis;
    @JsonProperty(value="isConcurrentAllowed")
    private final Boolean isConcurrentAllowed;
    @JsonProperty(value="isBackfillEnabled")
    private final Boolean isBackfillEnabled;
    @JsonProperty(value="authMode")
    private final AuthMode authMode;
    @JsonProperty(value="expectedDuration")
    private final Double expectedDuration;
    @JsonProperty(value="expectedDurationUnit")
    private final ExpectedDurationUnit expectedDurationUnit;
    @JsonProperty(value="nextRunTimeMillis")
    private final Long nextRunTimeMillis;
    @JsonProperty(value="lastRunDetails")
    private final LastRunDetails lastRunDetails;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "modelType", "parentRef", "name", "description", "objectVersion", "objectStatus", "identifier", "scheduleRef", "configProviderDelegate", "isEnabled", "numberOfRetries", "retryDelay", "retryDelayUnit", "startTimeMillis", "endTimeMillis", "isConcurrentAllowed", "isBackfillEnabled", "authMode", "expectedDuration", "expectedDurationUnit", "nextRunTimeMillis", "lastRunDetails", "metadata"})
    public TaskScheduleSummary(String key, String modelVersion, String modelType, ParentReference parentRef, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, Schedule scheduleRef, ConfigProvider configProviderDelegate, Boolean isEnabled, Integer numberOfRetries, Double retryDelay, RetryDelayUnit retryDelayUnit, Long startTimeMillis, Long endTimeMillis, Boolean isConcurrentAllowed, Boolean isBackfillEnabled, AuthMode authMode, Double expectedDuration, ExpectedDurationUnit expectedDurationUnit, Long nextRunTimeMillis, LastRunDetails lastRunDetails, ObjectMetadata metadata) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.modelType = modelType;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.scheduleRef = scheduleRef;
        this.configProviderDelegate = configProviderDelegate;
        this.isEnabled = isEnabled;
        this.numberOfRetries = numberOfRetries;
        this.retryDelay = retryDelay;
        this.retryDelayUnit = retryDelayUnit;
        this.startTimeMillis = startTimeMillis;
        this.endTimeMillis = endTimeMillis;
        this.isConcurrentAllowed = isConcurrentAllowed;
        this.isBackfillEnabled = isBackfillEnabled;
        this.authMode = authMode;
        this.expectedDuration = expectedDuration;
        this.expectedDurationUnit = expectedDurationUnit;
        this.nextRunTimeMillis = nextRunTimeMillis;
        this.lastRunDetails = lastRunDetails;
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getModelType() {
        return this.modelType;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Schedule getScheduleRef() {
        return this.scheduleRef;
    }

    public ConfigProvider getConfigProviderDelegate() {
        return this.configProviderDelegate;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Integer getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public Double getRetryDelay() {
        return this.retryDelay;
    }

    public RetryDelayUnit getRetryDelayUnit() {
        return this.retryDelayUnit;
    }

    public Long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public Long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public Boolean getIsConcurrentAllowed() {
        return this.isConcurrentAllowed;
    }

    public Boolean getIsBackfillEnabled() {
        return this.isBackfillEnabled;
    }

    public AuthMode getAuthMode() {
        return this.authMode;
    }

    public Double getExpectedDuration() {
        return this.expectedDuration;
    }

    public ExpectedDurationUnit getExpectedDurationUnit() {
        return this.expectedDurationUnit;
    }

    public Long getNextRunTimeMillis() {
        return this.nextRunTimeMillis;
    }

    public LastRunDetails getLastRunDetails() {
        return this.lastRunDetails;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TaskScheduleSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", scheduleRef=").append(String.valueOf((Object)this.scheduleRef));
        sb.append(", configProviderDelegate=").append(String.valueOf((Object)this.configProviderDelegate));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", numberOfRetries=").append(String.valueOf(this.numberOfRetries));
        sb.append(", retryDelay=").append(String.valueOf(this.retryDelay));
        sb.append(", retryDelayUnit=").append(String.valueOf((Object)this.retryDelayUnit));
        sb.append(", startTimeMillis=").append(String.valueOf(this.startTimeMillis));
        sb.append(", endTimeMillis=").append(String.valueOf(this.endTimeMillis));
        sb.append(", isConcurrentAllowed=").append(String.valueOf(this.isConcurrentAllowed));
        sb.append(", isBackfillEnabled=").append(String.valueOf(this.isBackfillEnabled));
        sb.append(", authMode=").append(String.valueOf((Object)this.authMode));
        sb.append(", expectedDuration=").append(String.valueOf(this.expectedDuration));
        sb.append(", expectedDurationUnit=").append(String.valueOf((Object)this.expectedDurationUnit));
        sb.append(", nextRunTimeMillis=").append(String.valueOf(this.nextRunTimeMillis));
        sb.append(", lastRunDetails=").append(String.valueOf((Object)this.lastRunDetails));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskScheduleSummary)) {
            return false;
        }
        TaskScheduleSummary other = (TaskScheduleSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals(this.modelType, other.modelType) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.identifier, other.identifier) && Objects.equals((Object)this.scheduleRef, (Object)other.scheduleRef) && Objects.equals((Object)this.configProviderDelegate, (Object)other.configProviderDelegate) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.numberOfRetries, other.numberOfRetries) && Objects.equals(this.retryDelay, other.retryDelay) && Objects.equals((Object)this.retryDelayUnit, (Object)other.retryDelayUnit) && Objects.equals(this.startTimeMillis, other.startTimeMillis) && Objects.equals(this.endTimeMillis, other.endTimeMillis) && Objects.equals(this.isConcurrentAllowed, other.isConcurrentAllowed) && Objects.equals(this.isBackfillEnabled, other.isBackfillEnabled) && Objects.equals((Object)this.authMode, (Object)other.authMode) && Objects.equals(this.expectedDuration, other.expectedDuration) && Objects.equals((Object)this.expectedDurationUnit, (Object)other.expectedDurationUnit) && Objects.equals(this.nextRunTimeMillis, other.nextRunTimeMillis) && Objects.equals((Object)this.lastRunDetails, (Object)other.lastRunDetails) && Objects.equals((Object)this.metadata, (Object)other.metadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.scheduleRef == null ? 43 : this.scheduleRef.hashCode());
        result = result * 59 + (this.configProviderDelegate == null ? 43 : this.configProviderDelegate.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.numberOfRetries == null ? 43 : this.numberOfRetries.hashCode());
        result = result * 59 + (this.retryDelay == null ? 43 : this.retryDelay.hashCode());
        result = result * 59 + (this.retryDelayUnit == null ? 43 : this.retryDelayUnit.hashCode());
        result = result * 59 + (this.startTimeMillis == null ? 43 : this.startTimeMillis.hashCode());
        result = result * 59 + (this.endTimeMillis == null ? 43 : this.endTimeMillis.hashCode());
        result = result * 59 + (this.isConcurrentAllowed == null ? 43 : this.isConcurrentAllowed.hashCode());
        result = result * 59 + (this.isBackfillEnabled == null ? 43 : this.isBackfillEnabled.hashCode());
        result = result * 59 + (this.authMode == null ? 43 : this.authMode.hashCode());
        result = result * 59 + (this.expectedDuration == null ? 43 : this.expectedDuration.hashCode());
        result = result * 59 + (this.expectedDurationUnit == null ? 43 : this.expectedDurationUnit.hashCode());
        result = result * 59 + (this.nextRunTimeMillis == null ? 43 : this.nextRunTimeMillis.hashCode());
        result = result * 59 + (this.lastRunDetails == null ? 43 : this.lastRunDetails.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ExpectedDurationUnit implements BmcEnum
    {
        Seconds("SECONDS"),
        Minutes("MINUTES"),
        Hours("HOURS"),
        Days("DAYS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExpectedDurationUnit> map;

        private ExpectedDurationUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExpectedDurationUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExpectedDurationUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExpectedDurationUnit.class);
            map = new HashMap<String, ExpectedDurationUnit>();
            for (ExpectedDurationUnit v : ExpectedDurationUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AuthMode implements BmcEnum
    {
        Obo("OBO"),
        ResourcePrincipal("RESOURCE_PRINCIPAL"),
        UserCertificate("USER_CERTIFICATE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AuthMode> map;

        private AuthMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AuthMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AuthMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AuthMode.class);
            map = new HashMap<String, AuthMode>();
            for (AuthMode v : AuthMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RetryDelayUnit implements BmcEnum
    {
        Seconds("SECONDS"),
        Minutes("MINUTES"),
        Hours("HOURS"),
        Days("DAYS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RetryDelayUnit> map;

        private RetryDelayUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RetryDelayUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RetryDelayUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RetryDelayUnit.class);
            map = new HashMap<String, RetryDelayUnit>();
            for (RetryDelayUnit v : RetryDelayUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="scheduleRef")
        private Schedule scheduleRef;
        @JsonProperty(value="configProviderDelegate")
        private ConfigProvider configProviderDelegate;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="numberOfRetries")
        private Integer numberOfRetries;
        @JsonProperty(value="retryDelay")
        private Double retryDelay;
        @JsonProperty(value="retryDelayUnit")
        private RetryDelayUnit retryDelayUnit;
        @JsonProperty(value="startTimeMillis")
        private Long startTimeMillis;
        @JsonProperty(value="endTimeMillis")
        private Long endTimeMillis;
        @JsonProperty(value="isConcurrentAllowed")
        private Boolean isConcurrentAllowed;
        @JsonProperty(value="isBackfillEnabled")
        private Boolean isBackfillEnabled;
        @JsonProperty(value="authMode")
        private AuthMode authMode;
        @JsonProperty(value="expectedDuration")
        private Double expectedDuration;
        @JsonProperty(value="expectedDurationUnit")
        private ExpectedDurationUnit expectedDurationUnit;
        @JsonProperty(value="nextRunTimeMillis")
        private Long nextRunTimeMillis;
        @JsonProperty(value="lastRunDetails")
        private LastRunDetails lastRunDetails;
        @JsonProperty(value="metadata")
        private ObjectMetadata metadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder scheduleRef(Schedule scheduleRef) {
            this.scheduleRef = scheduleRef;
            this.__explicitlySet__.add("scheduleRef");
            return this;
        }

        public Builder configProviderDelegate(ConfigProvider configProviderDelegate) {
            this.configProviderDelegate = configProviderDelegate;
            this.__explicitlySet__.add("configProviderDelegate");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder numberOfRetries(Integer numberOfRetries) {
            this.numberOfRetries = numberOfRetries;
            this.__explicitlySet__.add("numberOfRetries");
            return this;
        }

        public Builder retryDelay(Double retryDelay) {
            this.retryDelay = retryDelay;
            this.__explicitlySet__.add("retryDelay");
            return this;
        }

        public Builder retryDelayUnit(RetryDelayUnit retryDelayUnit) {
            this.retryDelayUnit = retryDelayUnit;
            this.__explicitlySet__.add("retryDelayUnit");
            return this;
        }

        public Builder startTimeMillis(Long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
            this.__explicitlySet__.add("startTimeMillis");
            return this;
        }

        public Builder endTimeMillis(Long endTimeMillis) {
            this.endTimeMillis = endTimeMillis;
            this.__explicitlySet__.add("endTimeMillis");
            return this;
        }

        public Builder isConcurrentAllowed(Boolean isConcurrentAllowed) {
            this.isConcurrentAllowed = isConcurrentAllowed;
            this.__explicitlySet__.add("isConcurrentAllowed");
            return this;
        }

        public Builder isBackfillEnabled(Boolean isBackfillEnabled) {
            this.isBackfillEnabled = isBackfillEnabled;
            this.__explicitlySet__.add("isBackfillEnabled");
            return this;
        }

        public Builder authMode(AuthMode authMode) {
            this.authMode = authMode;
            this.__explicitlySet__.add("authMode");
            return this;
        }

        public Builder expectedDuration(Double expectedDuration) {
            this.expectedDuration = expectedDuration;
            this.__explicitlySet__.add("expectedDuration");
            return this;
        }

        public Builder expectedDurationUnit(ExpectedDurationUnit expectedDurationUnit) {
            this.expectedDurationUnit = expectedDurationUnit;
            this.__explicitlySet__.add("expectedDurationUnit");
            return this;
        }

        public Builder nextRunTimeMillis(Long nextRunTimeMillis) {
            this.nextRunTimeMillis = nextRunTimeMillis;
            this.__explicitlySet__.add("nextRunTimeMillis");
            return this;
        }

        public Builder lastRunDetails(LastRunDetails lastRunDetails) {
            this.lastRunDetails = lastRunDetails;
            this.__explicitlySet__.add("lastRunDetails");
            return this;
        }

        public Builder metadata(ObjectMetadata metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public TaskScheduleSummary build() {
            TaskScheduleSummary model = new TaskScheduleSummary(this.key, this.modelVersion, this.modelType, this.parentRef, this.name, this.description, this.objectVersion, this.objectStatus, this.identifier, this.scheduleRef, this.configProviderDelegate, this.isEnabled, this.numberOfRetries, this.retryDelay, this.retryDelayUnit, this.startTimeMillis, this.endTimeMillis, this.isConcurrentAllowed, this.isBackfillEnabled, this.authMode, this.expectedDuration, this.expectedDurationUnit, this.nextRunTimeMillis, this.lastRunDetails, this.metadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TaskScheduleSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("scheduleRef")) {
                this.scheduleRef(model.getScheduleRef());
            }
            if (model.wasPropertyExplicitlySet("configProviderDelegate")) {
                this.configProviderDelegate(model.getConfigProviderDelegate());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("numberOfRetries")) {
                this.numberOfRetries(model.getNumberOfRetries());
            }
            if (model.wasPropertyExplicitlySet("retryDelay")) {
                this.retryDelay(model.getRetryDelay());
            }
            if (model.wasPropertyExplicitlySet("retryDelayUnit")) {
                this.retryDelayUnit(model.getRetryDelayUnit());
            }
            if (model.wasPropertyExplicitlySet("startTimeMillis")) {
                this.startTimeMillis(model.getStartTimeMillis());
            }
            if (model.wasPropertyExplicitlySet("endTimeMillis")) {
                this.endTimeMillis(model.getEndTimeMillis());
            }
            if (model.wasPropertyExplicitlySet("isConcurrentAllowed")) {
                this.isConcurrentAllowed(model.getIsConcurrentAllowed());
            }
            if (model.wasPropertyExplicitlySet("isBackfillEnabled")) {
                this.isBackfillEnabled(model.getIsBackfillEnabled());
            }
            if (model.wasPropertyExplicitlySet("authMode")) {
                this.authMode(model.getAuthMode());
            }
            if (model.wasPropertyExplicitlySet("expectedDuration")) {
                this.expectedDuration(model.getExpectedDuration());
            }
            if (model.wasPropertyExplicitlySet("expectedDurationUnit")) {
                this.expectedDurationUnit(model.getExpectedDurationUnit());
            }
            if (model.wasPropertyExplicitlySet("nextRunTimeMillis")) {
                this.nextRunTimeMillis(model.getNextRunTimeMillis());
            }
            if (model.wasPropertyExplicitlySet("lastRunDetails")) {
                this.lastRunDetails(model.getLastRunDetails());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            return this;
        }
    }
}

