/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.CreateDataFlowValidationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateDataFlowValidationRequest
extends BmcRequest<CreateDataFlowValidationDetails> {
    private String workspaceId;
    private CreateDataFlowValidationDetails createDataFlowValidationDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public CreateDataFlowValidationDetails getCreateDataFlowValidationDetails() {
        return this.createDataFlowValidationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateDataFlowValidationDetails getBody$() {
        return this.createDataFlowValidationDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).createDataFlowValidationDetails(this.createDataFlowValidationDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",createDataFlowValidationDetails=").append(String.valueOf((Object)this.createDataFlowValidationDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDataFlowValidationRequest)) {
            return false;
        }
        CreateDataFlowValidationRequest other = (CreateDataFlowValidationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals((Object)this.createDataFlowValidationDetails, (Object)other.createDataFlowValidationDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.createDataFlowValidationDetails == null ? 43 : this.createDataFlowValidationDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateDataFlowValidationRequest, CreateDataFlowValidationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private CreateDataFlowValidationDetails createDataFlowValidationDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder createDataFlowValidationDetails(CreateDataFlowValidationDetails createDataFlowValidationDetails) {
            this.createDataFlowValidationDetails = createDataFlowValidationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateDataFlowValidationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.createDataFlowValidationDetails(o.getCreateDataFlowValidationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateDataFlowValidationRequest build() {
            CreateDataFlowValidationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateDataFlowValidationDetails body) {
            this.createDataFlowValidationDetails(body);
            return this;
        }

        public CreateDataFlowValidationRequest buildWithoutInvocationCallback() {
            CreateDataFlowValidationRequest request = new CreateDataFlowValidationRequest();
            request.workspaceId = this.workspaceId;
            request.createDataFlowValidationDetails = this.createDataFlowValidationDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

