/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetFolderRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String folderKey;
    private String opcRequestId;
    private List<Projection> projection;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getFolderKey() {
        return this.folderKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<Projection> getProjection() {
        return this.projection;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).folderKey(this.folderKey).opcRequestId(this.opcRequestId).projection(this.projection);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",folderKey=").append(String.valueOf(this.folderKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",projection=").append(String.valueOf(this.projection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFolderRequest)) {
            return false;
        }
        GetFolderRequest other = (GetFolderRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.folderKey, other.folderKey) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.projection, other.projection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.folderKey == null ? 43 : this.folderKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.projection == null ? 43 : this.projection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetFolderRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String folderKey = null;
        private String opcRequestId = null;
        private List<Projection> projection = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder folderKey(String folderKey) {
            this.folderKey = folderKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder projection(List<Projection> projection) {
            this.projection = projection;
            return this;
        }

        public Builder projection(Projection singularValue) {
            return this.projection(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetFolderRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.folderKey(o.getFolderKey());
            this.opcRequestId(o.getOpcRequestId());
            this.projection(o.getProjection());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetFolderRequest build() {
            GetFolderRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetFolderRequest buildWithoutInvocationCallback() {
            GetFolderRequest request = new GetFolderRequest();
            request.workspaceId = this.workspaceId;
            request.folderKey = this.folderKey;
            request.opcRequestId = this.opcRequestId;
            request.projection = this.projection;
            return request;
        }
    }

    public static enum Projection implements BmcEnum
    {
        ChildCountStatistics("CHILD_COUNT_STATISTICS");

        private final String value;
        private static Map<String, Projection> map;

        private Projection(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Projection create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Projection: " + key);
        }

        static {
            map = new HashMap<String, Projection>();
            for (Projection v : Projection.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

