/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdateExternalPublicationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateExternalPublicationRequest
extends BmcRequest<UpdateExternalPublicationDetails> {
    private String workspaceId;
    private String taskKey;
    private String externalPublicationsKey;
    private UpdateExternalPublicationDetails updateExternalPublicationDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public String getExternalPublicationsKey() {
        return this.externalPublicationsKey;
    }

    public UpdateExternalPublicationDetails getUpdateExternalPublicationDetails() {
        return this.updateExternalPublicationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateExternalPublicationDetails getBody$() {
        return this.updateExternalPublicationDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).taskKey(this.taskKey).externalPublicationsKey(this.externalPublicationsKey).updateExternalPublicationDetails(this.updateExternalPublicationDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",taskKey=").append(String.valueOf(this.taskKey));
        sb.append(",externalPublicationsKey=").append(String.valueOf(this.externalPublicationsKey));
        sb.append(",updateExternalPublicationDetails=").append(String.valueOf((Object)this.updateExternalPublicationDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateExternalPublicationRequest)) {
            return false;
        }
        UpdateExternalPublicationRequest other = (UpdateExternalPublicationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.taskKey, other.taskKey) && Objects.equals(this.externalPublicationsKey, other.externalPublicationsKey) && Objects.equals((Object)this.updateExternalPublicationDetails, (Object)other.updateExternalPublicationDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.taskKey == null ? 43 : this.taskKey.hashCode());
        result = result * 59 + (this.externalPublicationsKey == null ? 43 : this.externalPublicationsKey.hashCode());
        result = result * 59 + (this.updateExternalPublicationDetails == null ? 43 : this.updateExternalPublicationDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateExternalPublicationRequest, UpdateExternalPublicationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String taskKey = null;
        private String externalPublicationsKey = null;
        private UpdateExternalPublicationDetails updateExternalPublicationDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder taskKey(String taskKey) {
            this.taskKey = taskKey;
            return this;
        }

        public Builder externalPublicationsKey(String externalPublicationsKey) {
            this.externalPublicationsKey = externalPublicationsKey;
            return this;
        }

        public Builder updateExternalPublicationDetails(UpdateExternalPublicationDetails updateExternalPublicationDetails) {
            this.updateExternalPublicationDetails = updateExternalPublicationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateExternalPublicationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.taskKey(o.getTaskKey());
            this.externalPublicationsKey(o.getExternalPublicationsKey());
            this.updateExternalPublicationDetails(o.getUpdateExternalPublicationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateExternalPublicationRequest build() {
            UpdateExternalPublicationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateExternalPublicationDetails body) {
            this.updateExternalPublicationDetails(body);
            return this;
        }

        public UpdateExternalPublicationRequest buildWithoutInvocationCallback() {
            UpdateExternalPublicationRequest request = new UpdateExternalPublicationRequest();
            request.workspaceId = this.workspaceId;
            request.taskKey = this.taskKey;
            request.externalPublicationsKey = this.externalPublicationsKey;
            request.updateExternalPublicationDetails = this.updateExternalPublicationDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

