/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdatePipelineDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdatePipelineRequest
extends BmcRequest<UpdatePipelineDetails> {
    private String workspaceId;
    private String pipelineKey;
    private UpdatePipelineDetails updatePipelineDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getPipelineKey() {
        return this.pipelineKey;
    }

    public UpdatePipelineDetails getUpdatePipelineDetails() {
        return this.updatePipelineDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdatePipelineDetails getBody$() {
        return this.updatePipelineDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).pipelineKey(this.pipelineKey).updatePipelineDetails(this.updatePipelineDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",pipelineKey=").append(String.valueOf(this.pipelineKey));
        sb.append(",updatePipelineDetails=").append(String.valueOf((Object)this.updatePipelineDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePipelineRequest)) {
            return false;
        }
        UpdatePipelineRequest other = (UpdatePipelineRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.pipelineKey, other.pipelineKey) && Objects.equals((Object)this.updatePipelineDetails, (Object)other.updatePipelineDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.pipelineKey == null ? 43 : this.pipelineKey.hashCode());
        result = result * 59 + (this.updatePipelineDetails == null ? 43 : this.updatePipelineDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdatePipelineRequest, UpdatePipelineDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String pipelineKey = null;
        private UpdatePipelineDetails updatePipelineDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder pipelineKey(String pipelineKey) {
            this.pipelineKey = pipelineKey;
            return this;
        }

        public Builder updatePipelineDetails(UpdatePipelineDetails updatePipelineDetails) {
            this.updatePipelineDetails = updatePipelineDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePipelineRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.pipelineKey(o.getPipelineKey());
            this.updatePipelineDetails(o.getUpdatePipelineDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePipelineRequest build() {
            UpdatePipelineRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdatePipelineDetails body) {
            this.updatePipelineDetails(body);
            return this;
        }

        public UpdatePipelineRequest buildWithoutInvocationCallback() {
            UpdatePipelineRequest request = new UpdatePipelineRequest();
            request.workspaceId = this.workspaceId;
            request.pipelineKey = this.pipelineKey;
            request.updatePipelineDetails = this.updatePipelineDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

