/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdateScheduleDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateScheduleRequest
extends BmcRequest<UpdateScheduleDetails> {
    private String workspaceId;
    private String applicationKey;
    private String scheduleKey;
    private UpdateScheduleDetails updateScheduleDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getScheduleKey() {
        return this.scheduleKey;
    }

    public UpdateScheduleDetails getUpdateScheduleDetails() {
        return this.updateScheduleDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateScheduleDetails getBody$() {
        return this.updateScheduleDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).applicationKey(this.applicationKey).scheduleKey(this.scheduleKey).updateScheduleDetails(this.updateScheduleDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",applicationKey=").append(String.valueOf(this.applicationKey));
        sb.append(",scheduleKey=").append(String.valueOf(this.scheduleKey));
        sb.append(",updateScheduleDetails=").append(String.valueOf((Object)this.updateScheduleDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateScheduleRequest)) {
            return false;
        }
        UpdateScheduleRequest other = (UpdateScheduleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.applicationKey, other.applicationKey) && Objects.equals(this.scheduleKey, other.scheduleKey) && Objects.equals((Object)this.updateScheduleDetails, (Object)other.updateScheduleDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.applicationKey == null ? 43 : this.applicationKey.hashCode());
        result = result * 59 + (this.scheduleKey == null ? 43 : this.scheduleKey.hashCode());
        result = result * 59 + (this.updateScheduleDetails == null ? 43 : this.updateScheduleDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateScheduleRequest, UpdateScheduleDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String applicationKey = null;
        private String scheduleKey = null;
        private UpdateScheduleDetails updateScheduleDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder scheduleKey(String scheduleKey) {
            this.scheduleKey = scheduleKey;
            return this;
        }

        public Builder updateScheduleDetails(UpdateScheduleDetails updateScheduleDetails) {
            this.updateScheduleDetails = updateScheduleDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateScheduleRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.scheduleKey(o.getScheduleKey());
            this.updateScheduleDetails(o.getUpdateScheduleDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateScheduleRequest build() {
            UpdateScheduleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateScheduleDetails body) {
            this.updateScheduleDetails(body);
            return this;
        }

        public UpdateScheduleRequest buildWithoutInvocationCallback() {
            UpdateScheduleRequest request = new UpdateScheduleRequest();
            request.workspaceId = this.workspaceId;
            request.applicationKey = this.applicationKey;
            request.scheduleKey = this.scheduleKey;
            request.updateScheduleDetails = this.updateScheduleDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

