/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdateWorkspaceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateWorkspaceRequest
extends BmcRequest<UpdateWorkspaceDetails> {
    private String workspaceId;
    private UpdateWorkspaceDetails updateWorkspaceDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public UpdateWorkspaceDetails getUpdateWorkspaceDetails() {
        return this.updateWorkspaceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateWorkspaceDetails getBody$() {
        return this.updateWorkspaceDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).updateWorkspaceDetails(this.updateWorkspaceDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",updateWorkspaceDetails=").append(String.valueOf((Object)this.updateWorkspaceDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateWorkspaceRequest)) {
            return false;
        }
        UpdateWorkspaceRequest other = (UpdateWorkspaceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals((Object)this.updateWorkspaceDetails, (Object)other.updateWorkspaceDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.updateWorkspaceDetails == null ? 43 : this.updateWorkspaceDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateWorkspaceRequest, UpdateWorkspaceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private UpdateWorkspaceDetails updateWorkspaceDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder updateWorkspaceDetails(UpdateWorkspaceDetails updateWorkspaceDetails) {
            this.updateWorkspaceDetails = updateWorkspaceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateWorkspaceRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.updateWorkspaceDetails(o.getUpdateWorkspaceDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateWorkspaceRequest build() {
            UpdateWorkspaceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateWorkspaceDetails body) {
            this.updateWorkspaceDetails(body);
            return this;
        }

        public UpdateWorkspaceRequest buildWithoutInvocationCallback() {
            UpdateWorkspaceRequest request = new UpdateWorkspaceRequest();
            request.workspaceId = this.workspaceId;
            request.updateWorkspaceDetails = this.updateWorkspaceDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

