/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservice;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.datalabelingservice.DataLabelingManagement;
import com.oracle.bmc.datalabelingservice.DataLabelingManagementPaginators;
import com.oracle.bmc.datalabelingservice.DataLabelingManagementWaiters;
import com.oracle.bmc.datalabelingservice.model.AnnotationFormatCollection;
import com.oracle.bmc.datalabelingservice.model.Dataset;
import com.oracle.bmc.datalabelingservice.model.DatasetCollection;
import com.oracle.bmc.datalabelingservice.model.WorkRequest;
import com.oracle.bmc.datalabelingservice.model.WorkRequestErrorCollection;
import com.oracle.bmc.datalabelingservice.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.datalabelingservice.model.WorkRequestSummaryCollection;
import com.oracle.bmc.datalabelingservice.requests.AddDatasetLabelsRequest;
import com.oracle.bmc.datalabelingservice.requests.ChangeDatasetCompartmentRequest;
import com.oracle.bmc.datalabelingservice.requests.CreateDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.DeleteDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.GenerateDatasetRecordsRequest;
import com.oracle.bmc.datalabelingservice.requests.GetDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.GetWorkRequestRequest;
import com.oracle.bmc.datalabelingservice.requests.ImportPreAnnotatedDataRequest;
import com.oracle.bmc.datalabelingservice.requests.ListAnnotationFormatsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListDatasetsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datalabelingservice.requests.RemoveDatasetLabelsRequest;
import com.oracle.bmc.datalabelingservice.requests.RenameDatasetLabelsRequest;
import com.oracle.bmc.datalabelingservice.requests.SnapshotDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.UpdateDatasetRequest;
import com.oracle.bmc.datalabelingservice.responses.AddDatasetLabelsResponse;
import com.oracle.bmc.datalabelingservice.responses.ChangeDatasetCompartmentResponse;
import com.oracle.bmc.datalabelingservice.responses.CreateDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.DeleteDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.GenerateDatasetRecordsResponse;
import com.oracle.bmc.datalabelingservice.responses.GetDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.GetWorkRequestResponse;
import com.oracle.bmc.datalabelingservice.responses.ImportPreAnnotatedDataResponse;
import com.oracle.bmc.datalabelingservice.responses.ListAnnotationFormatsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListDatasetsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestsResponse;
import com.oracle.bmc.datalabelingservice.responses.RemoveDatasetLabelsResponse;
import com.oracle.bmc.datalabelingservice.responses.RenameDatasetLabelsResponse;
import com.oracle.bmc.datalabelingservice.responses.SnapshotDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.UpdateDatasetResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLabelingManagementClient
extends BaseSyncClient
implements DataLabelingManagement {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATALABELINGMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://datalabeling-cp.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DataLabelingManagementClient.class);
    private final DataLabelingManagementWaiters waiters;
    private final DataLabelingManagementPaginators paginators;

    DataLabelingManagementClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DataLabelingManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DataLabelingManagementWaiters(executorService, this);
        this.paginators = new DataLabelingManagementPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AddDatasetLabelsResponse addDatasetLabels(AddDatasetLabelsRequest request) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddDatasetLabelsDetails(), "addDatasetLabelsDetails is required");
        return (AddDatasetLabelsResponse)this.clientCall(request, AddDatasetLabelsResponse::builder).logger(LOG, "addDatasetLabels").serviceDetails("DataLabelingManagement", "AddDatasetLabels", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/AddDatasetLabels").method(Method.POST).requestBuilder(AddDatasetLabelsRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).appendPathParam("actions").appendPathParam("addLabels").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", AddDatasetLabelsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", AddDatasetLabelsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeDatasetCompartmentResponse changeDatasetCompartment(ChangeDatasetCompartmentRequest request) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDatasetCompartmentDetails(), "changeDatasetCompartmentDetails is required");
        return (ChangeDatasetCompartmentResponse)this.clientCall(request, ChangeDatasetCompartmentResponse::builder).logger(LOG, "changeDatasetCompartment").serviceDetails("DataLabelingManagement", "ChangeDatasetCompartment", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/ChangeDatasetCompartment").method(Method.POST).requestBuilder(ChangeDatasetCompartmentRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeDatasetCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeDatasetCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDatasetResponse createDataset(CreateDatasetRequest request) {
        Objects.requireNonNull(request.getCreateDatasetDetails(), "createDatasetDetails is required");
        return (CreateDatasetResponse)this.clientCall(request, CreateDatasetResponse::builder).logger(LOG, "createDataset").serviceDetails("DataLabelingManagement", "CreateDataset", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/CreateDataset").method(Method.POST).requestBuilder(CreateDatasetRequest::builder).basePath("/20211001").appendPathParam("datasets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Dataset.class, CreateDatasetResponse.Builder::dataset).handleResponseHeaderString("etag", CreateDatasetResponse.Builder::etag).handleResponseHeaderString("location", CreateDatasetResponse.Builder::location).handleResponseHeaderString("Content-Location", CreateDatasetResponse.Builder::contentLocation).handleResponseHeaderString("opc-work-request-id", CreateDatasetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDatasetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDatasetResponse deleteDataset(DeleteDatasetRequest request) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        return (DeleteDatasetResponse)this.clientCall(request, DeleteDatasetResponse::builder).logger(LOG, "deleteDataset").serviceDetails("DataLabelingManagement", "DeleteDataset", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/DeleteDataset").method(Method.DELETE).requestBuilder(DeleteDatasetRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteDatasetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDatasetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GenerateDatasetRecordsResponse generateDatasetRecords(GenerateDatasetRecordsRequest request) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getGenerateDatasetRecordsDetails(), "generateDatasetRecordsDetails is required");
        return (GenerateDatasetRecordsResponse)this.clientCall(request, GenerateDatasetRecordsResponse::builder).logger(LOG, "generateDatasetRecords").serviceDetails("DataLabelingManagement", "GenerateDatasetRecords", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/GenerateDatasetRecords").method(Method.POST).requestBuilder(GenerateDatasetRecordsRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).appendPathParam("actions").appendPathParam("generateDatasetRecords").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", GenerateDatasetRecordsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", GenerateDatasetRecordsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDatasetResponse getDataset(GetDatasetRequest request) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        return (GetDatasetResponse)this.clientCall(request, GetDatasetResponse::builder).logger(LOG, "getDataset").serviceDetails("DataLabelingManagement", "GetDataset", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/GetDataset").method(Method.GET).requestBuilder(GetDatasetRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Dataset.class, GetDatasetResponse.Builder::dataset).handleResponseHeaderString("etag", GetDatasetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDatasetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DataLabelingManagement", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20211001").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ImportPreAnnotatedDataResponse importPreAnnotatedData(ImportPreAnnotatedDataRequest request) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getImportPreAnnotatedDataDetails(), "importPreAnnotatedDataDetails is required");
        return (ImportPreAnnotatedDataResponse)this.clientCall(request, ImportPreAnnotatedDataResponse::builder).logger(LOG, "importPreAnnotatedData").serviceDetails("DataLabelingManagement", "ImportPreAnnotatedData", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/ImportPreAnnotatedData").method(Method.POST).requestBuilder(ImportPreAnnotatedDataRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).appendPathParam("actions").appendPathParam("importPreAnnotatedData").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ImportPreAnnotatedDataResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ImportPreAnnotatedDataResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAnnotationFormatsResponse listAnnotationFormats(ListAnnotationFormatsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAnnotationFormatsResponse)this.clientCall(request, ListAnnotationFormatsResponse::builder).logger(LOG, "listAnnotationFormats").serviceDetails("DataLabelingManagement", "ListAnnotationFormats", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/AnnotationFormat/ListAnnotationFormats").method(Method.GET).requestBuilder(ListAnnotationFormatsRequest::builder).basePath("/20211001").appendPathParam("annotationFormats").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AnnotationFormatCollection.class, ListAnnotationFormatsResponse.Builder::annotationFormatCollection).handleResponseHeaderString("opc-request-id", ListAnnotationFormatsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAnnotationFormatsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDatasetsResponse listDatasets(ListDatasetsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDatasetsResponse)this.clientCall(request, ListDatasetsResponse::builder).logger(LOG, "listDatasets").serviceDetails("DataLabelingManagement", "ListDatasets", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/DatasetCollection/ListDatasets").method(Method.GET).requestBuilder(ListDatasetsRequest::builder).basePath("/20211001").appendPathParam("datasets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("annotationFormat", (Object)request.getAnnotationFormat()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DatasetCollection.class, ListDatasetsResponse.Builder::datasetCollection).handleResponseHeaderString("opc-request-id", ListDatasetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDatasetsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DataLabelingManagement", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/WorkRequest/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20211001").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DataLabelingManagement", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/WorkRequest/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20211001").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DataLabelingManagement", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20211001").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RemoveDatasetLabelsResponse removeDatasetLabels(RemoveDatasetLabelsRequest request) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveDatasetLabelsDetails(), "removeDatasetLabelsDetails is required");
        return (RemoveDatasetLabelsResponse)this.clientCall(request, RemoveDatasetLabelsResponse::builder).logger(LOG, "removeDatasetLabels").serviceDetails("DataLabelingManagement", "RemoveDatasetLabels", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/RemoveDatasetLabels").method(Method.POST).requestBuilder(RemoveDatasetLabelsRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).appendPathParam("actions").appendPathParam("removeLabels").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", RemoveDatasetLabelsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RemoveDatasetLabelsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RenameDatasetLabelsResponse renameDatasetLabels(RenameDatasetLabelsRequest request) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRenameDatasetLabelsDetails(), "renameDatasetLabelsDetails is required");
        return (RenameDatasetLabelsResponse)this.clientCall(request, RenameDatasetLabelsResponse::builder).logger(LOG, "renameDatasetLabels").serviceDetails("DataLabelingManagement", "RenameDatasetLabels", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/RenameDatasetLabels").method(Method.POST).requestBuilder(RenameDatasetLabelsRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).appendPathParam("actions").appendPathParam("renameLabels").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", RenameDatasetLabelsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RenameDatasetLabelsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SnapshotDatasetResponse snapshotDataset(SnapshotDatasetRequest request) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSnapshotDatasetDetails(), "snapshotDatasetDetails is required");
        return (SnapshotDatasetResponse)this.clientCall(request, SnapshotDatasetResponse::builder).logger(LOG, "snapshotDataset").serviceDetails("DataLabelingManagement", "SnapshotDataset", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/SnapshotDataset").method(Method.POST).requestBuilder(SnapshotDatasetRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).appendPathParam("actions").appendPathParam("snapshot").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", SnapshotDatasetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", SnapshotDatasetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDatasetResponse updateDataset(UpdateDatasetRequest request) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDatasetDetails(), "updateDatasetDetails is required");
        return (UpdateDatasetResponse)this.clientCall(request, UpdateDatasetResponse::builder).logger(LOG, "updateDataset").serviceDetails("DataLabelingManagement", "UpdateDataset", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/UpdateDataset").method(Method.PUT).requestBuilder(UpdateDatasetRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Dataset.class, UpdateDatasetResponse.Builder::dataset).handleResponseHeaderString("etag", UpdateDatasetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDatasetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DataLabelingManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DataLabelingManagementPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DataLabelingManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DataLabelingManagementClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataLabelingManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DataLabelingManagementClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataLabelingManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DataLabelingManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataLabelingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DataLabelingManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataLabelingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DataLabelingManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataLabelingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DataLabelingManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataLabelingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataLabelingManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataLabelingManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataLabelingManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataLabelingManagementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "datalabelingservice";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"datalabelingservice");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DataLabelingManagementClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DataLabelingManagementClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

