/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservice.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datalabelingservice.model.ImportFormat;
import com.oracle.bmc.datalabelingservice.model.ImportMetadataPath;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InitialImportDatasetConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="importFormat")
    private final ImportFormat importFormat;
    @JsonProperty(value="importMetadataPath")
    private final ImportMetadataPath importMetadataPath;

    @Deprecated
    @ConstructorProperties(value={"importFormat", "importMetadataPath"})
    public InitialImportDatasetConfiguration(ImportFormat importFormat, ImportMetadataPath importMetadataPath) {
        this.importFormat = importFormat;
        this.importMetadataPath = importMetadataPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ImportFormat getImportFormat() {
        return this.importFormat;
    }

    public ImportMetadataPath getImportMetadataPath() {
        return this.importMetadataPath;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InitialImportDatasetConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("importFormat=").append(String.valueOf((Object)this.importFormat));
        sb.append(", importMetadataPath=").append(String.valueOf((Object)this.importMetadataPath));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InitialImportDatasetConfiguration)) {
            return false;
        }
        InitialImportDatasetConfiguration other = (InitialImportDatasetConfiguration)((Object)o);
        return Objects.equals((Object)this.importFormat, (Object)other.importFormat) && Objects.equals((Object)this.importMetadataPath, (Object)other.importMetadataPath) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.importFormat == null ? 43 : this.importFormat.hashCode());
        result = result * 59 + (this.importMetadataPath == null ? 43 : this.importMetadataPath.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="importFormat")
        private ImportFormat importFormat;
        @JsonProperty(value="importMetadataPath")
        private ImportMetadataPath importMetadataPath;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder importFormat(ImportFormat importFormat) {
            this.importFormat = importFormat;
            this.__explicitlySet__.add("importFormat");
            return this;
        }

        public Builder importMetadataPath(ImportMetadataPath importMetadataPath) {
            this.importMetadataPath = importMetadataPath;
            this.__explicitlySet__.add("importMetadataPath");
            return this;
        }

        public InitialImportDatasetConfiguration build() {
            InitialImportDatasetConfiguration model = new InitialImportDatasetConfiguration(this.importFormat, this.importMetadataPath);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InitialImportDatasetConfiguration model) {
            if (model.wasPropertyExplicitlySet("importFormat")) {
                this.importFormat(model.getImportFormat());
            }
            if (model.wasPropertyExplicitlySet("importMetadataPath")) {
                this.importMetadataPath(model.getImportMetadataPath());
            }
            return this;
        }
    }
}

