/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservice.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datalabelingservice.model.ImportPreAnnotatedDataDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ImportPreAnnotatedDataRequest
extends BmcRequest<ImportPreAnnotatedDataDetails> {
    private String datasetId;
    private ImportPreAnnotatedDataDetails importPreAnnotatedDataDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getDatasetId() {
        return this.datasetId;
    }

    public ImportPreAnnotatedDataDetails getImportPreAnnotatedDataDetails() {
        return this.importPreAnnotatedDataDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ImportPreAnnotatedDataDetails getBody$() {
        return this.importPreAnnotatedDataDetails;
    }

    public Builder toBuilder() {
        return new Builder().datasetId(this.datasetId).importPreAnnotatedDataDetails(this.importPreAnnotatedDataDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",datasetId=").append(String.valueOf(this.datasetId));
        sb.append(",importPreAnnotatedDataDetails=").append(String.valueOf((Object)this.importPreAnnotatedDataDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportPreAnnotatedDataRequest)) {
            return false;
        }
        ImportPreAnnotatedDataRequest other = (ImportPreAnnotatedDataRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.datasetId, other.datasetId) && Objects.equals((Object)this.importPreAnnotatedDataDetails, (Object)other.importPreAnnotatedDataDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.datasetId == null ? 43 : this.datasetId.hashCode());
        result = result * 59 + (this.importPreAnnotatedDataDetails == null ? 43 : this.importPreAnnotatedDataDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportPreAnnotatedDataRequest, ImportPreAnnotatedDataDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String datasetId = null;
        private ImportPreAnnotatedDataDetails importPreAnnotatedDataDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public Builder importPreAnnotatedDataDetails(ImportPreAnnotatedDataDetails importPreAnnotatedDataDetails) {
            this.importPreAnnotatedDataDetails = importPreAnnotatedDataDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportPreAnnotatedDataRequest o) {
            this.datasetId(o.getDatasetId());
            this.importPreAnnotatedDataDetails(o.getImportPreAnnotatedDataDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportPreAnnotatedDataRequest build() {
            ImportPreAnnotatedDataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ImportPreAnnotatedDataDetails body) {
            this.importPreAnnotatedDataDetails(body);
            return this;
        }

        public ImportPreAnnotatedDataRequest buildWithoutInvocationCallback() {
            ImportPreAnnotatedDataRequest request = new ImportPreAnnotatedDataRequest();
            request.datasetId = this.datasetId;
            request.importPreAnnotatedDataDetails = this.importPreAnnotatedDataDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

